<?php 
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;
/********************************************************************/	
// validate tables missing data cells	
/********************************************************************/	
function wp_ada_compliance_validate_missing_td($content, $postinfo, $filteredcheck=0){
	
global $wp_ada_compliance_def;
	


// get options
$wp_ada_compliance_scanoptions = get_option('wp_ada_compliance_ignore_scan_rules', array());
	
// check if being scanned
if(in_array('missing_td', $wp_ada_compliance_scanoptions)) return;
    

    
// apply filters   
$wp_ada_compliance_filter_content = get_option('wp_ada_compliance_filter_content','true'); 
$wp_ada_compliance_report_filtered_errors = get_option('wp_ada_compliance_report_filtered_errors','false');     
    
if($wp_ada_compliance_filter_content == 'true' and (($wp_ada_compliance_report_filtered_errors == 'false' and strstr($content,'data-wp-ada-scanner')) or $filteredcheck == 1)) {
     
$dom = str_get_html($content);	
$dom = wp_ada_compliance_remove_empty_tables($dom);
if(is_object($dom)){
$content = $dom->save();  
} else return;	
}  
	
if($content == '') return;	
    
$dom = str_get_html($content);	         

$tables = $dom->find('table');

foreach ($tables as $table) {	

$tablecode = $table->outertext;
	

if($table != "" and !stristr($tablecode, "<td") and $table->getAttribute("data-ninja_table_instance") == ""){	


	// save error
	if(!$insertid = wp_ada_compliance_error_check($postinfo,"missing_td", $tablecode)){		
	$insertid = wp_ada_compliance_insert_error($postinfo,"missing_td", $wp_ada_compliance_def['missing_td']['StoredError'],  $tablecode);	
	}
		 
	}

}
return;
}

?>