<?php 
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;
/********************************************************************/	
// validate that more than one way is available to locate a Web page 
/********************************************************************/
function wp_ada_compliance_validate_multiple_ways_failure($content, $postinfo){

global $wp_ada_compliance_def;

// ignore check when scanning database only
if($postinfo['scantype'] == 'onsave') return;
if(stristr($postinfo['title'], __('Log In', 'wp-ada-compliance'))) return;
if(stristr($postinfo['title'], __('Login', 'wp-ada-compliance'))) return;	
	
$dom = str_get_html($content);	
		
// get options
$wp_ada_compliance_scanoptions = get_option('wp_ada_compliance_ignore_scan_rules', array());

// check if being scanned
if(in_array('multiple_ways_failure', $wp_ada_compliance_scanoptions)) return;

$links = $dom->find('a');
foreach ($links as $link) {
     if (isset($link) 
		 and (stristr($link->plaintext, 'sitemap') 
		 or stristr($link->plaintext, 'site map') 
		 or stristr($link->plaintext, 'table of content')  
		or stristr($link->plaintext, 'search')
		 or stristr($link->getAttribute('aria-label'), 'site map') 
		 or stristr($link->getAttribute('aria-label'), 'table of content')  
		or stristr($link->getAttribute('aria-label'), 'search')
			 or stristr($link->getAttribute('title'), 'site map') 
		 or stristr($link->getAttribute('title'), 'table of content')  
		or stristr($link->getAttribute('title'), 'search')			  
	   )) return;
}
	
$forms = $dom->find('form');
foreach ($forms as $form) {
	  $formhtml = $form->outertext;
     if (stristr($formhtml, 'search')) return;
	 
}	
	

$code =  __('Missing sitemap or search feature', 'wp-ada-compliance');

// save error
if(!$insertid = wp_ada_compliance_error_check($postinfo,"multiple_ways_failure", $code)){
$insertid = wp_ada_compliance_insert_error($postinfo,"multiple_ways_failure", $wp_ada_compliance_def['multiple_ways_failure']['StoredError'], $code);
}
			
}	
?>
