<?php 
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;
/********************************************************************/	
// target new window
/********************************************************************/	
function wp_ada_compliance_validate_new_window_tag($content, $postinfo, $filteredcheck=0){

global $wp_ada_compliance_def;

// get options
$wp_ada_compliance_scanoptions = get_option('wp_ada_compliance_ignore_scan_rules', array());

// check if being scanned
if(in_array('new_window_tag', $wp_ada_compliance_scanoptions)) return;	    

// apply filters   
$wp_ada_compliance_filter_content = get_option('wp_ada_compliance_filter_content','true'); 
$wp_ada_compliance_report_filtered_errors = get_option('wp_ada_compliance_report_filtered_errors','false');     

if($wp_ada_compliance_filter_content == 'true' and (($wp_ada_compliance_report_filtered_errors == 'false' and strstr($content,'data-wp-ada-scanner')) or $filteredcheck == 1)) {
      
$dom = str_get_html($content);
$striptarget = get_option('wp_ada_compliance_striptarget','addcsshover');
if($striptarget == 'remove')
$dom = wp_ada_compliance_remove_target_attributes($dom, $content);
else{
$dom = wp_ada_compliance_strip_target_attributes($dom, $content);	
}
if(is_object($dom)){
$content = $dom->save();  
} else return;	
}  

if($content == '') return;	

$dom = str_get_html($content);	  

$links = $dom->find('a');
foreach ($links as $link) {
$imagealtiscompliant = 0;
// check embeded image for compliance
$nodes = $link->children();
foreach ($nodes as $node) {
if($node->tag == "img" or $node->tag == "i") {
if(stristr($node->getAttribute('title'),"new window") 
or stristr($node->getAttribute('alt'),"new window") 
or stristr($node->getAttribute('aria-label'),"new window")
or stristr($node->getAttribute('title'),"new tab") 
or (stristr($node->getAttribute('alt'),"new window") 
or stristr($node->getAttribute('aria-label'),"new tab"))){
$imagealtiscompliant = 1;
}
}
}

if(isset($link) 
and ($link->getAttribute('target') == "_blank" or stristr($link->getAttribute('onclick'),"window.open") or stristr($link->getAttribute('onclick'),"openwindow")) 
and !stristr($link->plaintext,"new window") 
and !stristr($link->plaintext,"new tab")
and !stristr($link->getAttribute('title'),"new tab") 
and !stristr($link->getAttribute('aria-label'),"new tab")
and !stristr($link->getAttribute('title'),"new window")
and !stristr($link->getAttribute('aria-label'),"new window")
and $imagealtiscompliant == 0) {
    
if($filteredcheck == 1) return 1;    

$newwindowtag = $link->outertext;

// save error
if(!$insertid = wp_ada_compliance_error_check($postinfo,"new_window_tag", $newwindowtag))
$insertid = wp_ada_compliance_insert_error($postinfo,"new_window_tag", $wp_ada_compliance_def['new_window_tag']['StoredError'], $newwindowtag);

}
}
return;
}

?>