<?php 
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;
/********************************************************************/	
// validate redundant alt tags
/********************************************************************/
function wp_ada_compliance_validate_redundant_alt_text($content, $postinfo, $filteredcheck=0){
	
global $wp_ada_compliance_def;
	


// get options
$wp_ada_compliance_scanoptions = get_option('wp_ada_compliance_ignore_scan_rules', array());

	
// check if being scanned
if(in_array('redundant_alt_text', $wp_ada_compliance_scanoptions)) return;

    
// apply filters   
$wp_ada_compliance_filter_content = get_option('wp_ada_compliance_filter_content','true'); 
$wp_ada_compliance_report_filtered_errors = get_option('wp_ada_compliance_report_filtered_errors','false');     
    
if($wp_ada_compliance_filter_content == 'true' and (($wp_ada_compliance_report_filtered_errors == 'false' and strstr($content,'data-wp-ada-scanner')) or $filteredcheck == 1)) {
     
$dom = str_get_html($content);
$dom = wp_ada_compliance_remove_redundant_alttext($dom);
if(is_object($dom)){
$content = $dom->save();  
} else return;	
}  
	
if($content == '') return;	
    
$dom = str_get_html($content);	        
    

/********************************************************************/	
// validate redundant alt attributes on images
/********************************************************************/	
	
$images = $dom->find('img');
foreach ($images as $image) {
    $alttext = '';
    if($image->getAttribute('alt') != "")	{
         $alttext = $image->getAttribute('alt');   
        }
    elseif($image->getAttribute('title') != "")	{
         $alttext = $image->getAttribute('title');   
        }
     elseif($image->getAttribute('aria-label') != "")	{
         $alttext = $image->getAttribute('aria-label');   
        }  
    
    if($alttext != ''){
		if(isset($captioncode)) unset($captioncode);
			$pattern  = '/'."\[caption.*\](.*?)alt=[\"\']\b".preg_quote(strtolower(trim($alttext)),'/')."\b[\"\'](.*?)\b".preg_quote(strtolower(trim($alttext)),'/')."\b\[\/caption\]".'/';	
			
		if(preg_match($pattern,$content,$captioncode)){
			if(!stristr($captioncode[0],'<a')){ // if not inside an anchor
                
                if($filteredcheck == 1) return 1;
		
			// save error
			if(!$insertid = wp_ada_compliance_error_check($postinfo,"redundant_alt_text", $caption_code))
			$insertid = wp_ada_compliance_insert_error($postinfo,"redundant_alt_text", $wp_ada_compliance_def['redundant_alt_text']['StoredError'], $caption_code);

		
			}
			}
		}

}// end caption validate
	

/********************************************************************/	
// redundant alt text on image inside anchor
/********************************************************************/	
$images = $dom->find('a img');
foreach ($images as $image) {
if($image->getAttribute('alt') != ""){
if (isset($image) 
and (wp_ada_compliance_compare_strings($image->parent()->plaintext,$image->getAttribute('alt'))
or wp_ada_compliance_compare_strings($image->getAttribute('title'),$image->getAttribute('alt'))
)) {
if($filteredcheck == 1) return 1;
    
$redundantalttag = $image->parent()->outertext;
// save error
if(!$insertid = wp_ada_compliance_error_check($postinfo,"redundant_alt_text", $redundantalttag))
$insertid = wp_ada_compliance_insert_error($postinfo,"redundant_alt_text", $wp_ada_compliance_def['redundant_alt_text']['StoredError'], $redundantalttag);
}
}
}
	
/********************************************************************/	
// redundant alt text on image not inside an anchor
/********************************************************************/	
$images = $dom->find('img');
foreach ($images as $image) {
if($image->getAttribute('alt') != "" and $image->getAttribute('title') !=""){

if (isset($image) 
and wp_ada_compliance_compare_strings($image->getAttribute('title'),$image->getAttribute('alt'))
) {
    
if($filteredcheck == 1) return 1;
    
$redundantalttag = $image->outertext;

// save error
if(!$insertid = wp_ada_compliance_error_check($postinfo,"redundant_alt_text", $redundantalttag))
$insertid = wp_ada_compliance_insert_error($postinfo,"redundant_alt_text", $wp_ada_compliance_def['redundant_alt_text']['StoredError'], $redundantalttag);


}
}
}
    
/********************************************************************/	
// redundant alt text on image when parent element includes the same text THis includes all caption types
/********************************************************************/	
$images = $dom->find('img');
$alttext = '';
foreach ($images as $image) {
	
// don't report redundant link text when wrapped in a link
if($image->parent()->tag != 'a'){	
    
if($image->getAttribute('alt') != "")	{
$alttext = $image->getAttribute('alt');   
}
elseif($image->getAttribute('title') != "")	{
$alttext = $image->getAttribute('title');   
}
elseif($image->getAttribute('aria-label') != "")	{
$alttext = $image->getAttribute('aria-label');   
}
  
// check parent tag  
if(is_object($image->parent()) and $image->parent()->tag != 'a'){   
    $parent = $image->parent();
}
elseif(is_object($image->parent()->parent())){  
    $parent = $image->parent()->parent();
}
        
    
if(is_object($parent) and $alttext != ""){  
    
 // check parents text  
$parentstext = $parent->plaintext;    
if ($parentstext != '' and wp_ada_compliance_compare_strings($parentstext,$alttext)) {
if($filteredcheck == 1) return 1;   
$redundantalttag = $parent->outertext;
if(!$insertid = wp_ada_compliance_error_check($postinfo,"redundant_alt_text", $redundantalttag))
$insertid = wp_ada_compliance_insert_error($postinfo,"redundant_alt_text", $wp_ada_compliance_def['redundant_alt_text']['StoredError'], $redundantalttag);
}
    
 // check next element text
if(is_object($parent->next_sibling())){   
$nextelementtext = $parent->next_sibling()->plaintext;    
//if ($nextelementtext != '' and wp_ada_compliance_compare_strings($nextelementtext,$alttext)) {
if ($nextelementtext != '' and stristr($nextelementtext,$alttext)) {    
if($filteredcheck == 1) return 1;   
$redundantalttag = $parent->outertext.$parent->next_sibling()->outertext;
if(!$insertid = wp_ada_compliance_error_check($postinfo,"redundant_alt_text", $redundantalttag))
$insertid = wp_ada_compliance_insert_error($postinfo,"redundant_alt_text", $wp_ada_compliance_def['redundant_alt_text']['StoredError'], $redundantalttag);
}
}
    
 // check previous text
if(is_object($parent->prev_sibling())){       
$prevelementtext = $parent->prev_sibling()->plaintext;    
//if ($prevelementtext != '' and wp_ada_compliance_compare_strings($prevelementtext,$alttext)) {
if ($prevelementtext != '' and stristr($prevelementtext,$alttext)) {     
if($filteredcheck == 1) return 1;   
$redundantalttag = $parent->prev_sibling()->outertext.$parent->outertext;
if(!$insertid = wp_ada_compliance_error_check($postinfo,"redundant_alt_text", $redundantalttag))
$insertid = wp_ada_compliance_insert_error($postinfo,"redundant_alt_text", $wp_ada_compliance_def['redundant_alt_text']['StoredError'], $redundantalttag);
}
}
    
}
}
}
    
/********************************************************************/
// check figure captions - NO LONGER NEEDED, REPLACED WITH FUNCTION ABOVE
/********************************************************************	
$anchor = "";	
$figures = $dom->find('figure');
foreach ($figures as $figure) {
		
$figurecaption = $figure->find('figcaption',0);
$image = $figure->find('img',0);
$anchor = $figure->find('a',0);
if(isset($figurecaption)){
$figcaptioncode = $figurecaption->plaintext; 


$alttext = '';

if(isset($image) ){
if($image->getAttribute('alt') != "")	{
$alttext = $image->getAttribute('alt');   
}
elseif($image->getAttribute('title') != "")	{
$alttext = $image->getAttribute('title');   
}
elseif($image->getAttribute('aria-label') != "")	{
$alttext = $image->getAttribute('aria-label');   
}  
}
		
if($anchor == "" and wp_ada_compliance_compare_strings($figcaptioncode,$alttext) and $alttext != ""){

$caption_code = $figure->outertext;

if($filteredcheck == 1) return 1;    
    
// save error
if(!$insertid = wp_ada_compliance_error_check($postinfo,"redundant_alt_text", $caption_code))
$insertid = wp_ada_compliance_insert_error($postinfo,"redundant_alt_text", $wp_ada_compliance_def['redundant_alt_text']['StoredError'], $caption_code);

}
	}
}// end figure caption validate	
	*/
    
/********************************************************************/	
// check alt text on image inside captions marked up with a dl
/********************************************************************	
$figuredivs = $dom->find('dl');
foreach ($figuredivs as $figure) {

if(stristr($figure->getAttribute('class'),'wp-caption')){	

$figurecaption = $figure->find('dd',0);
$anchor = $figure->find('a',0);
if($anchor == "" and isset($figurecaption) and stristr($figurecaption->getAttribute('class'),'wp-caption-text')){	
$image = $figure->find('img',0);
$figcaptioncode = $figurecaption->plaintext; 


$alttext = '';

if(isset($image) ){
if($image->getAttribute('alt') != "")	{
$alttext = $image->getAttribute('alt');   
}
elseif($image->getAttribute('title') != "")	{
$alttext = $image->getAttribute('title');   
}
elseif($image->getAttribute('aria-label') != "")	{
$alttext = $image->getAttribute('aria-label');   
}  
}    

if(wp_ada_compliance_compare_strings($figcaptioncode,$alttext)
and $alttext != ""){

if($filteredcheck == 1) return 1;
    
$caption_code = $figure->outertext;
    
// save error
if(!$insertid = wp_ada_compliance_error_check($postinfo,"redundant_alt_text", $caption_code))
$insertid = wp_ada_compliance_insert_error($postinfo,"redundant_alt_text", $wp_ada_compliance_def['redundant_alt_text']['StoredError'], $caption_code);



}
}	
}
}   */ 
    
/********************************************************************/	
// check alt text on image inside captions marked up with a div
/********************************************************************	
$figuredivs = $dom->find('div[class=wp-caption]');
foreach ($figuredivs as $figure) {	

$figurecaption = $figure->find('p',0);
$anchor = $figure->find('a',0);
if($anchor == "" and isset($figurecaption) and stristr($figurecaption->getAttribute('class'),'wp-caption')){	
$image = $figure->find('img',0);
$figcaptioncode = $figurecaption->plaintext; 


$alttext = '';

if(isset($image) ){
if($image->getAttribute('alt') != "")	{
$alttext = $image->getAttribute('alt');   
}
elseif($image->getAttribute('title') != "")	{
$alttext = $image->getAttribute('title');   
}
elseif($image->getAttribute('aria-label') != "")	{
$alttext = $image->getAttribute('aria-label');   
}  
}    

if(wp_ada_compliance_compare_strings($figcaptioncode,$alttext)
and $alttext != ""){

if($filteredcheck == 1) return 1;

$caption_code = $figure->outertext;
    
// save error
if(!$insertid = wp_ada_compliance_error_check($postinfo,"redundant_alt_text", $caption_code))
$insertid = wp_ada_compliance_insert_error($postinfo,"redundant_alt_text", $wp_ada_compliance_def['redundant_alt_text']['StoredError'], $caption_code);

}
}	

}*/

return;
} 
?>