<?php 
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;
/********************************************************************/	
// validate tables with summary attributes that duplicate caption
/********************************************************************/	
function wp_ada_compliance_validate_redundant_table_summary($content, $postinfo){
	
global $wp_ada_compliance_def;
	
$dom = str_get_html($content);

// get options
$wp_ada_compliance_scanoptions = get_option('wp_ada_compliance_ignore_scan_rules', array());
	
// check if being scanned
if(in_array('redundant_table_summary', $wp_ada_compliance_scanoptions)) return;	

$tables = $dom->find('table');

foreach ($tables as $table) {	

$tablecode = $table->outertext;	

// get summary text
$summary = strtolower(trim($table->getAttribute('summary')));	

// get caption text
$captiontext = "";		
$captions = $dom->find('caption');
foreach ($captions as $caption) {
$captiontext = strtolower(trim($caption->plaintext));
}
	
if($table != "" and $captiontext != "" and	$captiontext == $summary ){	

	
	// save error
	if(!$insertid = wp_ada_compliance_error_check($postinfo,"redundant_table_summary", $tablecode)){		
	$insertid = wp_ada_compliance_insert_error($postinfo,"redundant_table_summary", $wp_ada_compliance_def['redundant_table_summary']['StoredError'],  $tablecode);	
	}

	}
	
}
return;
}

?>