<?php 
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;
/********************************************************************/	
// validate redundant title attributes
/********************************************************************/
function wp_ada_compliance_validate_redundant_title_tag($content, $postinfo, $filteredcheck=0){
	
global $wp_ada_compliance_def;
	


// get options
$wp_ada_compliance_scanoptions = get_option('wp_ada_compliance_ignore_scan_rules', array());

	
// check if being scanned
if(in_array('redundant_title_tag', $wp_ada_compliance_scanoptions)) return;
    
    
// apply filters   
$wp_ada_compliance_filter_content = get_option('wp_ada_compliance_filter_content','true'); 
$wp_ada_compliance_report_filtered_errors = get_option('wp_ada_compliance_report_filtered_errors','false');     
    
if($wp_ada_compliance_filter_content == 'true' and (($wp_ada_compliance_report_filtered_errors == 'false' and strstr($content,'data-wp-ada-scanner')) or $filteredcheck == 1)) {
     
$dom = str_get_html($content);
$dom = wp_ada_compliance_remove_redundant_alttext($dom);
$dom = wp_ada_compliance_convert_link_title_attributes_to_aria_labels($dom);    
if(is_object($dom)){
$content = $dom->save();  
} else return;	
}  
	
if($content == '') return;	
    
$dom = str_get_html($content);	        

// redundant title text without images
$titlearray = array();	
$links = $dom->find('a');
foreach ($links as $link) {
	if($link->getAttribute('title') != ""){
				$titlearray[] = __('permalink of ', 'wp-ada-compliance');
		$titlearray[] = __('permalink to ', 'wp-ada-compliance');
       if (isset($link) and strtolower(trim($link->plaintext)) == strtolower(trim(str_ireplace($titlearray, '', $link->getAttribute('title')))) or strtolower(trim(str_ireplace($titlearray, '', $link->getAttribute('title')))) === trim(strtolower($link->getAttribute('aria-label')))) {
			$redeidanttitletag = $link->outertext;
		 	
           if($filteredcheck == 1) return 1;

			// save error
			if(!$insertid = wp_ada_compliance_error_check($postinfo,"redundant_title_tag", $redeidanttitletag))
			$insertid = wp_ada_compliance_insert_error($postinfo,"redundant_title_tag", $wp_ada_compliance_def['redundant_title_tag']['StoredError'], $redeidanttitletag);
			
			
	   		}
		}
}
	
// redundant title text on links wrapping an image
$links = $dom->find('a');
foreach ($links as $link) {
	if($link->getAttribute('title') != ""){
      	$images = $link->find('img');
		foreach ($images as $image) {
		if($image->getAttribute('alt') != ""){
			
       if (isset($link) and isset($image) 
		   and strtolower(trim($link->getAttribute('title'))) == strtolower(trim($image->getAttribute('alt')))	   
		  ) {
		   
			$redeidanttitletag = $link->outertext;
		 	
           if($filteredcheck == 1) return 1;
 
			// save error
			if(!$insertid = wp_ada_compliance_error_check($postinfo,"redundant_title_tag", $redeidanttitletag))
			$insertid = wp_ada_compliance_insert_error($postinfo,"redundant_title_tag", $wp_ada_compliance_def['redundant_title_tag']['StoredError'], $redeidanttitletag);
			
			
	   		}
		}
		}
	}
}	

return;
}
?>