<?php 
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;
/********************************************************************/	
// validate form controls groups without fieldsets 
/********************************************************************/	
function wp_ada_compliance_validate_related_form_fields_not_grouped($content, $postinfo, $filteredcheck=0){
	
global $wp_ada_compliance_def;

// get options
$wp_ada_compliance_scanoptions = get_option('wp_ada_compliance_ignore_scan_rules', array());
	
// check if being scanned
if(in_array('related_form_fields_not_grouped', $wp_ada_compliance_scanoptions)) return;	


// apply filters   
$wp_ada_compliance_filter_content = get_option('wp_ada_compliance_filter_content','true'); 
$wp_ada_compliance_report_filtered_errors = get_option('wp_ada_compliance_report_filtered_errors','false');     
    
if($wp_ada_compliance_filter_content == 'true' and (($wp_ada_compliance_report_filtered_errors == 'false' and strstr($content,'data-wp-ada-scanner')) or $filteredcheck == 1)) {
     
$dom = str_get_html($content);	    
$dom = wp_ada_compliance_correct_VFP_labels($dom);
if(is_object($dom)){
$content = $dom->save();  
} else return;	
}  
	
if($content == '') return;	
    
$dom = str_get_html($content);
    
$forms = $dom->find('form');
foreach ($forms as $form){  
   $fieldnames = array(); 
$formfields = $form->find('input[type=radio], input[type=checkbox]');
foreach ($formfields as $formfield){
    $fieldnames[] = preg_replace('/\[\d\]/','',$formfield->getAttribute('name'));
}
foreach ($formfields as $formfield){
    $errorfound = 0;
    $parent = $formfield->parent();
    
    if(count(array_keys($fieldnames, preg_replace('/\[\d\]/','',$formfield->getAttribute('name')))) > 1){
        
        // check for fieldset
        if(isset($parent->tag) and $parent->tag == 'fieldset') $fieldset = $parent;  
        elseif(isset($parent->parent()->tag) and $parent->parent()->tag == 'fieldset') $fieldset = $parent->parent();
        elseif(!is_null($parent->parent()) and isset($parent->parent()->parent()->tag) and $parent->parent()->parent()->tag == 'fieldset') $fieldset = $parent->parent()->parent();
        elseif(!is_null($parent->parent()->parent()) and isset($parent->parent()->parent()->parent()->tag) and $parent->parent()->parent()->parent()->tag == 'fieldset') $fieldset = $parent->parent()->parent()->parent();
        elseif(!is_null($parent->parent()->parent()) and isset($parent->parent()->parent()->parent()->parent()->tag) and $parent->parent()->parent()->parent()->parent()->tag == 'fieldset') $fieldset = $parent->parent()->parent()->parent()->parent();
        elseif(!is_null($parent->parent()->parent()) and isset($parent->parent()->parent()->parent()->parent()->parent()->tag) and $parent->parent()->parent()->parent()->parent()->parent()->tag == 'fieldset') $fieldset = $parent->parent()->parent()->parent()->parent()->parent();
        
        if(!isset($fieldset->tag) or $fieldset->tag != 'fieldset') $errorfound = 1;
        
        if($errorfound == 0){
        $legends = $fieldset->find('legend');  
        if(count($legends) < 1) {
            $errorfound = 1;
        }
        }
        
        // check for div with role = radiogroup or group
        if(isset($parent->tag) and $parent->tag == 'div' 
           and ($parent->getAttribute('role') == 'group' or $parent->getAttribute('role') == 'radiogroup' )
           and $parent->hasAttribute('aria-labelledby'))   $errorfound = 0;  
        
    
    if ($errorfound == 1){
       $errorcode = '';  
    $affectedfields = $form->find('input[name^='.preg_replace('/\[\d\]/','',$formfield->getAttribute('name')).']');
      foreach ($affectedfields as $code){  
    $affectedlabels = $form->find('label[for='.$code->getAttribute('id').']'); 
     foreach ($affectedlabels as $label){
           $errorcode .= $label->outertext;
      }
        $errorcode .= $code->outertext;
    }
       

			
			// save error
			if(!$insertid = wp_ada_compliance_error_check($postinfo,"related_form_fields_not_grouped", $errorcode))
			$insertid = wp_ada_compliance_insert_error($postinfo,"related_form_fields_not_grouped", $wp_ada_compliance_def['related_form_fields_not_grouped']['StoredError'], $errorcode);
			

			
    }
}
}
}
	return;
}
?>