<?php 
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;
/********************************************************************/	
// validate skip nav links in theme files
/********************************************************************/
function wp_ada_compliance_validate_skip_nav_links($content, $postinfo){

global $wp_ada_compliance_def;

// ignore check when scanning database only
if($postinfo['scantype'] == 'onsave') return;	
    
    // ignore login screen
if(strstr($content,__('Powered by WordPress', 'wp-ada-compliance')) and strstr($content,__('Log In', 'wp-ada-compliance'))) return;   
		
// get options
$wp_ada_compliance_scanoptions = get_option('wp_ada_compliance_ignore_scan_rules', array());  

// check if being scanned
if(in_array('skip_nav_links', $wp_ada_compliance_scanoptions) or ($content =='')) return;
    
// apply filters      
$wp_ada_compliance_filter_content = get_option('wp_ada_compliance_filter_content','true'); 
if($wp_ada_compliance_filter_content == 'true' and strstr($content,'data-wp-ada-scanner')) {
$dom = str_get_html($content);		
$dom = wp_ada_compliance_add_skip_links($dom, 1); 
if(is_object($dom)){
$content = $dom->save();  
} else return;	
}  
	
if($content == '') return;	
    
$dom = str_get_html($content);
	
$code = '';	
$missingtargetid = '';
$duplicatetargetid = '';
$skiplinks = $dom->find('a[class*=skip], a[plaintext*='.__('skip', 'wp-ada-compliance').'], a[plaintext*='.__('Skip', 'wp-ada-compliance').']');		
if(!$skiplinks) 
$code .=  __('Missing skip links. ', 'wp-ada-compliance');

// if not missing continue checks
if($code == ''){	
	
// check if they are the first links
$firstlink = $dom->find('a',0); 
if(!stristr($firstlink->getAttribute('class'),'skip') and (!stristr($firstlink->innertext,__('skip', 'wp-ada-compliance')) or (!stristr($firstlink->innertext,__('content', 'wp-ada-compliance')) and !stristr($firstlink->innertext,__('navigation', 'wp-ada-compliance'))))){ 
$code .=  __('Skip to main content not the first link in the page. ', 'wp-ada-compliance');	    
}
elseif(wp_ada_compliance_check_skip_to_main_content_link($content, $firstlink->getAttribute('href'))){ 
// check that first link points to the main content
  $code .=  __('Skip to main content does not point to the main landmark. ', 'wp-ada-compliance');  
}
	
// check if id exists
$links = $dom->find('a[class*=skip], a[plaintext*='.__('skip', 'wp-ada-compliance').'], a[plaintext*='.__('Skip', 'wp-ada-compliance').']');
	
foreach ($links as $link) {	

if(preg_match('|^#|',$link->getAttribute('href')) and !wp_ada_compliance_check_for_missing_id($content, trim($link->getAttribute('href'),'#'))){
$missingtargetid .= $link->getAttribute('href').', ';
} 
	
if(preg_match('|^#|',$link->getAttribute('href')) and !wp_ada_compliance_check_for_duplicate_id($content, trim($link->getAttribute('href'),'#'))){
$duplicatetargetid .= $link->getAttribute('href').', ';
} 	

}

if(trim($missingtargetid) != '') $code .= __('Skip link target id was not found in the document. Missing ids:', 'wp-ada-compliance').' '.$missingtargetid;
if(trim($duplicatetargetid) != '') $code .= __('Duplicate skip link target ids were found in the document. Duplicate ids:', 'wp-ada-compliance').' '.$duplicatetargetid;	
}
	

     
// save error
if($code != ''){    

	
if(!$insertid = wp_ada_compliance_error_check($postinfo,"skip_nav_links", $code)){
$insertid = wp_ada_compliance_insert_error($postinfo,"skip_nav_links", $wp_ada_compliance_def['skip_nav_links']['StoredError'], $code);	
}
}
}	

/********************************************************************/	
// check if skip  to main content link points to 
/********************************************************************/
function wp_ada_compliance_check_skip_to_main_content_link($content, $href){
    
if(substr($href,0,1) != '#') return 0;  
    
$id = ltrim($href,'#');    
$dom = str_get_html($content);	
$mains = $dom->find('main,[role=main]');
foreach ($mains as $main) {
 if($main->getAttribute('id') != $id) return 1;  
} 
    
return 0;    
}

/********************************************************************/	
// check target id exists
/********************************************************************/
function wp_ada_compliance_check_for_missing_id($content, $id){
$dom = str_get_html($content);	

$ret = $dom->find('*[id='.$id.']');		
if(!$ret) return 0;
else return 1;	

}

/********************************************************************/	
// check for duplicate target id
/********************************************************************/
function wp_ada_compliance_check_for_duplicate_id($content, $id){
$dom = str_get_html($content);	

$ret = $dom->find('*[id='.$id.']');		
if(count($ret) > 1) return 0;
else return 1;	

}
?>