<?php 
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;
/********************************************************************/	
// validate justified text
/********************************************************************/	
function wp_ada_compliance_validate_text_justified($content, $postinfo, $filteredcheck=0){
	
global $wp_ada_compliance_def;
	
// get options
$wp_ada_compliance_scanoptions = get_option('wp_ada_compliance_ignore_scan_rules', array());

	
// check if being scanned
if(in_array('text_justified', $wp_ada_compliance_scanoptions)) return;
       
// apply filters   
$wp_ada_compliance_filter_content = get_option('wp_ada_compliance_filter_content','true'); 
$wp_ada_compliance_report_filtered_errors = get_option('wp_ada_compliance_report_filtered_errors','false');     
    
if($wp_ada_compliance_filter_content == 'true' and (($wp_ada_compliance_report_filtered_errors == 'false' and strstr($content,'data-wp-ada-scanner')) or $filteredcheck == 1)) {
     
$content = wp_ada_compliance_change_justified_text($content);
}      
    
$fontsearchpatterns = array();
$fontsearchpatterns[] = "|(text-)?align:\s?justify|i";

foreach($fontsearchpatterns as $key => $pattern){

	if(preg_match_all($pattern, $content, $matches,PREG_OFFSET_CAPTURE)){
	$matchsize = sizeof($matches[0]);
	
	for($i=0; $i < $matchsize; $i++){
        if(isset($matches[0][$i][0]) and $matches[0][$i][0] != ""){
		
		if($filteredcheck == 1) return 1;
            
		$text_justified_errorcode = htmlspecialchars($matches[0][$i][0]).__(' (char #: ','wp-ada-compliance').$matches[0][$i][1].')';	

		// save error
		if(!$insertid = wp_ada_compliance_error_check($postinfo,"text_justified", $text_justified_errorcode)){
			
		$insertid = wp_ada_compliance_insert_error($postinfo, "text_justified", $wp_ada_compliance_def['text_justified']['StoredError'], $text_justified_errorcode);
		}
		
		
	}
	}
	}
	
}
	return;
} 
?>