<?php 
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;

/********************************************************************/	
// links in content that are lot included in an anchor tag
/********************************************************************/	
function wp_ada_compliance_validate_unlinked_anchors($content, $postinfo, $filteredcheck=0){
	
global $wp_ada_compliance_def;
	
// get options
$wp_ada_compliance_scanoptions = get_option('wp_ada_compliance_ignore_scan_rules', array());

// check if being scanned
if(in_array('unlinked_anchors', $wp_ada_compliance_scanoptions)) return;
    
    
// apply filters   
$wp_ada_compliance_filter_content = get_option('wp_ada_compliance_filter_content','true'); 
$wp_ada_compliance_report_filtered_errors = get_option('wp_ada_compliance_report_filtered_errors','false');     
    
if($wp_ada_compliance_filter_content == 'true' and (($wp_ada_compliance_report_filtered_errors == 'false' and strstr($content,'data-wp-ada-scanner')) or $filteredcheck == 1)) {
    
$dom = str_get_html($content);	    
$dom = wp_ada_compliance_link_email_addresses_dom($dom);
if(is_object($dom)){
$content = $dom->save();  
} else return;	
}  
	
if($content == '') return;	

$dom = str_get_html($content);	
    
$tags = array('p','h1','h2','h3','h4','h5','h6','td', 'li','blockquote','address','dd','pre');
foreach($tags as $value){	
$tag = $dom->find($value);

	
$patterns = array();    
$patterns[] = "/<a.*?<\/a>(*SKIP)(*F)|http(s)?:\/\/+/i";
$patterns[] = '/<a.*?<\/a>(*SKIP)(*F)|[\!#\$%&\'\*\+-\/=\?^_`\{\|\}~,:;\@\[\]\.\w-]+@([\w-]+\.)+[\w-]+/i'; 	

foreach ($tag as $element) {
if($element->tag=='td'){
$code = $element->innertext;
} else $code = $element->outertext;
    
foreach($patterns as $pattern){    
    
	if(preg_match_all($pattern, $code, $matches,PREG_OFFSET_CAPTURE)){
	$matchsize = sizeof($matches[0]);
	
	for($i=0; $i < $matchsize; $i++){
	
        if(isset($matches[0][$i][0]) 
           and $matches[0][$i][0] != "" 
		   and strstr($element->plaintext, $matches[0][$i][0])
           and !wp_ada_compliance_check_excluded($code, $matches[0][$i][0])
		  ){
        
        if($filteredcheck == 1) return 1;       
            
        $emailaddressError = 0;
    
		
		$unlinked_anchors_errorcode = $code;
               

		// save error
		if(!$insertid = wp_ada_compliance_error_check($postinfo,"unlinked_anchors", $unlinked_anchors_errorcode)){
			
		$insertid = wp_ada_compliance_insert_error($postinfo, "unlinked_anchors", $wp_ada_compliance_def['unlinked_anchors']['StoredError'], $unlinked_anchors_errorcode);
		}
		
            // check if it is an email error
        if(preg_match("/<a.*?<\/a>(*SKIP)(*F)|[\!#\$%&\'\*\+-\/=\?^_`\{\|\}~,:;\@\[\]\.\w-]+@([\w-]+\.)+[\w-]+/i",$unlinked_anchors_errorcode)) $emailaddressError = 1;
            
		
	}
	}
    }
}
}
}
	return;
}

/********************************************************
exclude anchors wrapped in quotes
********************************************************/
function wp_ada_compliance_check_excluded($code, $match){
    $code = html_entity_decode ($code,ENT_QUOTES);	

if(stristr($code,"='".$match)) return 1;
if(stristr($code,"=”".$match)) return 1; 
if(stristr($code,"=".$match)) return 1; 	
if(stristr($code,"=\"".$match)) return 1; 
return 0;
}
?>