<?php 
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;
/********************************************************************/	
// form fields not marked as required
/********************************************************************/	
function wp_ada_compliance_validate_unmarked_required_fields($content, $postinfo){
	
global $wp_ada_compliance_def;
	
$dom = str_get_html($content);

// get options
$wp_ada_compliance_scanoptions = get_option('wp_ada_compliance_ignore_scan_rules', array());
	
// check if being scanned
if(in_array('unmarked_required_fields', $wp_ada_compliance_scanoptions)) return;	


$forms = $dom->find('form');
foreach ($forms as $form){
 
	
		$errorcode = $form->outertext;
		if (!stristr($errorcode,__('required','wp-ada-compliance')) and !stristr($errorcode, '*') and !stristr($errorcode, 'aria-required')){ 	
			
			if(wp_ada_compliance_count_form_fields($errorcode) > 1){
			
			// save error
			if(!$insertid = wp_ada_compliance_error_check($postinfo,"unmarked_required_fields", $errorcode))
			$insertid = wp_ada_compliance_insert_error($postinfo,"unmarked_required_fields", $wp_ada_compliance_def['unmarked_required_fields']['StoredError'], $errorcode);
			

		
			}
	}
}
	return;
}

// count number of fields
function wp_ada_compliance_count_form_fields($errorcode) {
$count = 0;	
$minuscount = 0;	
$count += substr_count($errorcode, '<input');
$count += substr_count($errorcode, '<select');
$count += substr_count($errorcode, '<textarea');	
	
$minuscount += substr_count($errorcode, 'type="hidden"');
$minuscount += substr_count($errorcode, "type='hidden'");
$minuscount += substr_count($errorcode, "type='submit'");
$minuscount += substr_count($errorcode, 'type="submit"');			
$count = $count - $minuscount;
	
return $count;
}
?>