<?php 
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;
/********************************************************************/	
//inaccessibile pdf checks
/********************************************************************/	
function wp_ada_compliance_untagged_document_checks($postinfo){
global $wp_ada_compliance_def;
$errorcode = '';		
// get options
$wp_ada_compliance_scanoptions = get_option('wp_ada_compliance_ignore_scan_rules', array());
	
	
// check if being scanned
if(in_array('untagged_document', $wp_ada_compliance_scanoptions)) return;	  

$errorcode = wp_ada_compliance_untagged_document($postinfo['content']); 
    
$errorcode .= wp_ada_compliance_pdf_undefined_language($postinfo['content']);

 /*   
if($errorcode == ''){
$obj_array = wp_ada_compliance_parce_pdf_content($postinfo['content'], 'obj'); 

$errorcode = wp_ada_compliance_pdf_undetectable_objects($postinfo['content'], $obj_array);    
} 
    
if($errorcode == '')  $errorcode = wp_ada_compliance_pdf_missing_title($postinfo['content'], $obj_array); 
 
if($errorcode == '')  $errorcode = wp_ada_compliance_undetectable_tags($postinfo['content'],$obj_array); 
    
if($errorcode == '') $errorcode = wp_ada_compliance_pdf_missing_th($postinfo['content'], $obj_array);
 */
// report error if error was found    
if ($errorcode){			
			
// save error
if(!$insertid = wp_ada_compliance_error_check($postinfo,"untagged_document", $errorcode))
$insertid = wp_ada_compliance_insert_error($postinfo,"untagged_document", $wp_ada_compliance_def['untagged_document']['StoredError'], $errorcode);
	

}
	
return;	
}

/********************************************************************/	
/// untagged document
/********************************************************************/	
function wp_ada_compliance_untagged_document($content){
		
if (!stristr($content,'/StructTreeRoot')){			
return __('Document is not tagged. ', 'wp-ada-compliance');
}	
	
return '';	
}

/********************************************************************/	
/// undefined document lang
/********************************************************************/	
function wp_ada_compliance_pdf_undefined_language($content){
	
if (!stristr($content,'/Lang')){	
	
return __('The primary language of this document is not defined. Setting the document language in a PDF enables screen readers to switch to the appropriate language. ', 'wp-ada-compliance');	
}	
	
return '';	
}


/********************************************************************/	
/// undetectable tags
/*******************************************************************
function wp_ada_compliance_undetectable_tags($content, $obj_array){
	
if (stristr($content,'/StructTreeRoot')){	
if(!wp_ada_compliance_pdfmultiKeyExists($obj_array, 'P') 
    and !wp_ada_compliance_pdfmultiKeyExists($obj_array, 'TABLE')
   and !wp_ada_compliance_pdfmultiKeyExists($obj_array, 'H1')
  and !wp_ada_compliance_pdfmultiKeyExists($obj_array, 'H2')
   and !wp_ada_compliance_pdfmultiKeyExists($obj_array, 'LI')
   and !wp_ada_compliance_pdfmultiKeyExists($obj_array, 'FORM')
  ){			
	
return '';
}	
}
    
return __('This PDF file includes structure groups but has no detectable structure tags such as P, TABLE, H1, LI, etc... This could mean that the document is tagged incorrectly or that the document was not created in the PDF 1.7 format or above.', 'wp-ada-compliance');	
}

/********************************************************************/	
/// missing table headers
/********************************************************************
function wp_ada_compliance_pdf_missing_th($content, $obj_array){

if(wp_ada_compliance_pdfmultiKeyExists($obj_array, 'TABLE') and !wp_ada_compliance_pdfmultiKeyExists($obj_array, 'TH')){
	
return __('One or more tables were found without table headings. Each table that includes data should have table headings. Tables that do not include data and are for presentation only do not require table headings.', 'wp-ada-compliance');	
	}	
return '';	
}

/********************************************************************/	
/// undectable objects
/********************************************************************	
function wp_ada_compliance_pdf_undetectable_objects($content, $obj_array){
    
if(wp_ada_compliance_pdfmultiKeyValue($obj_array, 'TITLE') == 1){		
return __('This PDF could not be validated. Use Adobe Acrobat Pro to ensure compliance.', 'wp-ada-compliance');	
}	
	
return '';	
}

/********************************************************************/	
/// missing_title
/********************************************************************	
function wp_ada_compliance_pdf_missing_title($content, $obj_array){
    
$title = wp_ada_compliance_pdfmultiKeyValue($obj_array, 'TITLE');	
    
if($title=='' or stristr($title, __('no title','wp-ada-compliance'))
	or stristr($title, __('untitled','wp-ada-compliance'))
   or stristr($title, __('Microsoft Word -','wp-ada-compliance'))
   or stristr($title, __('.doc','wp-ada-compliance'))
  ){			
	
return __('Document title is blank, missing or invalid. The first thing screen readers read when a user views the document is the title. Good titles are important to help people know what they are viewing.', 'wp-ada-compliance');	
}	
	
return '';	
}

/****************************************************************
parse pdf to get streams or objects
*****************************************************************

function wp_ada_compliance_parce_pdf_content($content, $type='obj'){
$return_array = array(); // master array to hold decoded stream or objects
$transformations = array(); // array to store transformations
$texts = array(); // array to store coded text	
$plaintext = array(); // array to store plain text		

    preg_match_all("#obj(.*)endobj#ismU", $content, $objects);
    $objects = @$objects[1];
	
 	for ($i = 0; $i < count($objects); $i++) {
     $currentObject = $objects[$i];
	
	if($type == 'obj'){ // if object requested return object
		
	$options = wp_ada_compliance_pdf_getObjectOptions($currentObject);
		
	$return_array[] = $options;	
	}
	elseif($type == 'stream'){ // if streams requested return streams
  
        if (preg_match("#stream(.*)endstream#ismU", $currentObject, $stream)) {
            $streams = ltrim($stream[1]);

            $options = wp_ada_compliance_pdf_getObjectOptions($currentObject);
			
						
            if (!(empty($options["Length1"]) && empty($options["Type"]) && empty($options["Subtype"])))
               continue;
		
			// decode the stream
            $data = wp_ada_compliance_pdf_getDecodedStream($streams, $options); 
			
			// get plain text from stream
			
			if (preg_match_all("#BT(.*)ET#ismU", $data, $textContainers)) {
                    $textContainers = @$textContainers[1];
                    $texts = wp_ada_compliance_pdf_getDirtyTexts($texts, $textContainers);				
			    }
			else{
            $transformations = wp_ada_compliance_pdf_getCharTransformations($transformations, $data);				
            }
			$plaintext = wp_ada_compliance_pdf_getTextUsingTransformations($texts, $transformations);	
			$return_array[] = $plaintext;
			
			
			$return_array[] = $data;
			}
        
        }
    }


return $return_array;
}

/**********************************************************
look for key in multi demensional array
**********************************************************
function wp_ada_compliance_pdfmultiKeyExists(array $arr, $key) {

	$arr = array_change_key_case($arr,CASE_UPPER);	
	
    // is in base array?
    if (array_key_exists($key, $arr)) {
        return true;
    }

    // check arrays contained in this array
    foreach ($arr as $element) {
        if (is_array($element)) {
			$element = array_change_key_case($element,CASE_UPPER);	
            if (wp_ada_compliance_pdfmultiKeyExists($element, $key)) {
                return true;
            }
        }

    }

    return false;
}

/**********************************************************
look for value of key in multi demensional array
**********************************************************
function wp_ada_compliance_pdfmultiKeyValue(array $arr, $key) {

	$arr = array_change_key_case($arr,CASE_UPPER);	
	$match = '';
    $value = '';
	
    // is in base array?
    if (array_key_exists($key, $arr)) {
		$match = 1;
         $value = $arr["$key"];
    }

    // check arrays contained in this array
    foreach ($arr as $element) {
        if (is_array($element)) {
			$element = array_change_key_case($element,CASE_UPPER);	
            if (wp_ada_compliance_pdfmultiKeyValue($element, $key) and array_key_exists($key, $element)) {
                $value = $element["$key"];
                $match = 1;
            }
        }

    }

if($match == '') return 1;
else return $value;
}

function wp_ada_compliance_pdf_decodeAsciiHex($input) {
    $output = "";

    $isOdd = true;
    $isComment = false;

    for($i = 0, $codeHigh = -1; $i < strlen($input) && $input[$i] != '>'; $i++) {
        $c = $input[$i];

        if($isComment) {
            if ($c == '\r' || $c == '\n')
                $isComment = false;
            continue;
        }

        switch($c) {
            case '\0': case '\t': case '\r': case '\f': case '\n': case ' ': break;
            case '%': 
                $isComment = true;
            break;

            default:
                $code = hexdec($c);
                if($code === 0 && $c != '0')
                    return "";

                if($isOdd)
                    $codeHigh = $code;
                else
                    $output .= chr($codeHigh * 16 + $code);

                $isOdd = !$isOdd;
            break;
        }
    }

    if($input[$i] != '>')
        return "";

    if($isOdd)
        $output .= chr($codeHigh * 16);

    return $output;
}
function wp_ada_compliance_pdf_decodeAscii85($input) {
    $output = "";

    $isComment = false;
    $ords = array();
    
    for($i = 0, $state = 0; $i < strlen($input) && $input[$i] != '~'; $i++) {
        $c = $input[$i];

        if($isComment) {
            if ($c == '\r' || $c == '\n')
                $isComment = false;
            continue;
        }

        if ($c == '\0' || $c == '\t' || $c == '\r' || $c == '\f' || $c == '\n' || $c == ' ')
            continue;
        if ($c == '%') {
            $isComment = true;
            continue;
        }
        if ($c == 'z' && $state === 0) {
            $output .= str_repeat(chr(0), 4);
            continue;
        }
        if ($c < '!' || $c > 'u')
            return "";

        $code = ord($input[$i]) & 0xff;
        $ords[$state++] = $code - ord('!');

        if ($state == 5) {
            $state = 0;
            for ($sum = 0, $j = 0; $j < 5; $j++)
                $sum = $sum * 85 + $ords[$j];
            for ($j = 3; $j >= 0; $j--)
                $output .= chr($sum >> ($j * 8));
        }
    }
    if ($state === 1)
        return "";
    elseif ($state > 1) {
        for ($i = 0, $sum = 0; $i < $state; $i++)
            $sum += ($ords[$i] + ($i == $state - 1)) * pow(85, 4 - $i);
        for ($i = 0; $i < $state - 1; $i++)
            $ouput .= chr($sum >> ((3 - $i) * 8));
    }

    return $output;
}
function wp_ada_compliance_pdf_decodeFlate($input) {
    return @gzuncompress($input);
}

function wp_ada_compliance_pdf_getObjectOptions($object) {
	$object = str_replace("(", " (", $object);
	
    $options = array();
    if (preg_match("#<<(.*)>>#ismU", $object, $options)) {
        $options = explode("/", $options[1]);
        @array_shift($options);

        $o = array();
        for ($j = 0; $j < @count($options); $j++) {
            $options[$j] = preg_replace("#\s+#", " ", trim($options[$j]));
            if (strpos($options[$j], " ") !== false) {
                $parts = explode(" ", $options[$j]);
                $o[$parts[0]] = $options[$j];
            } else
                $o[$options[$j]] = true;
        }
        $options = $o;
        unset($o);
    }

    return $options;
}
function wp_ada_compliance_pdf_getDecodedStream($stream, $options) {
    $data = "";
    if (empty($options["Filter"]))
        $data = $stream;
    else {
        $length = !empty($options["Length"]) ? $options["Length"] : strlen($stream);
		if(is_string($length)) $length = 1;
        $_stream = substr($stream, 0, $length);

        foreach ($options as $key => $value) {
            if ($key == "ASCIIHexDecode")
                $_stream = wp_ada_compliance_pdf_decodeAsciiHex($_stream);
            if ($key == "ASCII85Decode")
                $_stream = wp_ada_compliance_pdf_decodeAscii85($_stream);
            if ($key == "FlateDecode")
                $_stream = wp_ada_compliance_pdf_decodeFlate($_stream);
        }
        $data = $_stream;
    }
    return $data;
}
function wp_ada_compliance_pdf_getDirtyTexts($texts, $textContainers) {
    for ($j = 0; $j < count($textContainers); $j++) {
        if (preg_match_all("#\[(.*)\]\s*TJ#ismU", $textContainers[$j], $parts))
            $texts = array_merge($texts, @$parts[1]);
        elseif(preg_match_all("#Td\s*(\(.*\))\s*Tj#ismU", $textContainers[$j], $parts))
            $texts = array_merge($texts, @$parts[1]);
    }
	return $texts;
}
function wp_ada_compliance_pdf_getCharTransformations($transformations, $stream) {
    preg_match_all("#([0-9]+)\s+beginbfchar(.*)endbfchar#ismU", $stream, $chars, PREG_SET_ORDER);
    preg_match_all("#([0-9]+)\s+beginbfrange(.*)endbfrange#ismU", $stream, $ranges, PREG_SET_ORDER);

    for ($j = 0; $j < count($chars); $j++) {
        $count = $chars[$j][1];
        $current = explode("\n", trim($chars[$j][2]));
        for ($k = 0; $k < $count && $k < count($current); $k++) {
            if (preg_match("#<([0-9a-f]{2,4})>\s+<([0-9a-f]{4,512})>#is", trim($current[$k]), $map))
                $transformations[str_pad($map[1], 4, "0")] = $map[2];
        }
    }
    for ($j = 0; $j < count($ranges); $j++) {
        $count = $ranges[$j][1];
        $current = explode("\n", trim($ranges[$j][2]));
        for ($k = 0; $k < $count && $k < count($current); $k++) {
            if (preg_match("#<([0-9a-f]{4})>\s+<([0-9a-f]{4})>\s+<([0-9a-f]{4})>#is", trim($current[$k]), $map)) {
                $from = hexdec($map[1]);
                $to = hexdec($map[2]);
                $_from = hexdec($map[3]);

                for ($m = $from, $n = 0; $m <= $to; $m++, $n++)
                    $transformations[sprintf("%04X", $m)] = sprintf("%04X", $_from + $n);
            } elseif (preg_match("#<([0-9a-f]{4})>\s+<([0-9a-f]{4})>\s+\[(.*)\]#ismU", trim($current[$k]), $map)) {
                $from = hexdec($map[1]);
                $to = hexdec($map[2]);
                $parts = preg_split("#\s+#", trim($map[3]));
                
                for ($m = $from, $n = 0; $m <= $to && $n < count($parts); $m++, $n++)
                    $transformations[sprintf("%04X", $m)] = sprintf("%04X", hexdec($parts[$n]));
            }
        }
    }
	return $transformations;
}
/*
function wp_ada_compliance_pdf_getTextUsingTransformations($texts, $transformations) {
    $document = "";
    for ($i = 0; $i < count($texts); $i++) {
        $isHex = false;
        $isPlain = false;

        $hex = "";
        $plain = "";
        for ($j = 0; $j < strlen($texts[$i]); $j++) {
            $c = $texts[$i][$j];
            switch($c) {
                case "<":
                    $hex = "";
                    $isHex = true;
                break;
                case ">":
                    $hexs = str_split($hex, 4);
                    for ($k = 0; $k < count($hexs); $k++) {
                        $chex = str_pad($hexs[$k], 4, "0");
                        if (isset($transformations[$chex]))
                            $chex = $transformations[$chex];
                        $document .= html_entity_decode("&#x".$chex.";");
                    }
                    $isHex = false;
                break;
                case "(":
                    $plain = "";
                    $isPlain = true;
                break;
                case ")":
                    $document .= $plain;
                    $isPlain = false;
                break;
                case "\\":
                    $c2 = $texts[$i][$j + 1];
                    if (in_array($c2, array("\\", "(", ")"))) $plain .= $c2;
                    elseif ($c2 == "n") $plain .= '\n';
                    elseif ($c2 == "r") $plain .= '\r';
                    elseif ($c2 == "t") $plain .= '\t';
                    elseif ($c2 == "b") $plain .= '\b';
                    elseif ($c2 == "f") $plain .= '\f';
                    elseif ($c2 >= '0' && $c2 <= '9') {
                        $oct = preg_replace("#[^0-9]#", "", substr($texts[$i], $j + 1, 3));
                        $j += strlen($oct) - 1;
                        $plain .= html_entity_decode("&#".octdec($oct).";");
                    }
                    $j++;
                break;

                default:
                    if ($isHex)
                        $hex .= $c;
                    if ($isPlain)
                        $plain .= $c;
                break;
            }
        }
        $document .= "\n";
    }

    return $document;
}
*/
?>