<?php 
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;


/**********************************************
// validate scan themes
**********************************************/
function  wp_ada_compliance_validate_scan_themes($values){
$accepted = array('Blog Home',"404 Page","Search Page","Author Page");
 if(is_array($values) or $values == '') {
	  if(is_array($values)){
    foreach($values as $key => $value) {
     if(!in_array($value,$accepted)) unset($values[$key]);   
    }
	  }
     return wp_ada_compliance_sanitize_text_or_array_field($values);
 }
return $accepted;

}

/**********************************************
// validate deep scan
**********************************************
function wp_ada_compliance_validate_deep_scan($value) {
$accepted = array('basic','deep');

if(in_array($value,$accepted)) return wp_ada_compliance_sanitize_text_or_array_field($value);   

return 'deep';
}*/

/**********************************************
// hash password
**********************************************/
function  wp_ada_compliance_validate_password_field($password){
if($password != ''){
$password = wp_ada_compliance_sanitize_text_or_array_field($password);
return wp_ada_compliance_encrypt_decrypt('encrypt', $password);
}
return '';
}

/****************************************
encrypt/decrypt password
****************************************/
function wp_ada_compliance_encrypt_decrypt($action, $string) 
    {
$encrypt_method = "AES-256-CBC";
 
    // set initial values
if(get_option('wp_ada_compliance_secret_key','') == '') {
    update_option('wp_ada_compliance_secret_key', random_bytes(32));
}  
if(get_option('wp_ada_compliance_secret_iv','') == '') {
    update_option('wp_ada_compliance_secret_iv', openssl_random_pseudo_bytes(openssl_cipher_iv_length($encrypt_method)));
}    
    
$secret_key = get_option('wp_ada_compliance_secret_key');
$secret_iv = get_option('wp_ada_compliance_secret_iv');

$output = false;
// hash
$key = hash('sha256', $secret_key);    
// iv - encrypt method AES-256-CBC expects 16 bytes 
$iv = substr(hash('sha256', $secret_iv), 0, 16);
if ( $action == 'encrypt' ) {
$output = openssl_encrypt($string, $encrypt_method, $key, 0, $iv);
$output = base64_encode($output);
} else if( $action == 'decrypt' ) {
$output = openssl_decrypt(base64_decode($string), $encrypt_method, $key, 0, $iv);
}
return $output;
}

/**********************************************
// validate scan external sources
**********************************************/
function  wp_ada_compliance_validate_scan_external_sources($values){
$accepted = array('iframe',"css",'linked','pdf');
 if(is_array($values) or $values == '') {
	  if(is_array($values)){
    foreach($values as $key => $value) {
     if(!in_array($value,$accepted)) unset($values[$key]);   
    }
	  }
     return wp_ada_compliance_sanitize_text_or_array_field($values);
 }
return $accepted;

}

/**********************************************
// validate slugs / links
**********************************************/
function wp_ada_compliance_validate_slug_path($values){
 if(is_array($values) or $values == '') {
	  if(is_array($values)){
    foreach($values as $key => $value) {
     if(!preg_match("/^(([[:alnum:]]|-|[[:space:]]|[[:punct:]])+[^`!()\[\]{};:'\".,<>«»“”‘’])$/i", $value)) unset($values[$key]);   
    }
	  }
     return wp_ada_compliance_sanitize_text_or_array_field($values);
 } 

return array();
}

/**********************************************
// validate posts to ignore
**********************************************/
function wp_ada_compliance_validate_posts_to_ignore($values){
global $wpdb;
    
 if(is_array($values) or $values == '') {
	  if(is_array($values)){
    foreach($values as $key => $value) {
    $files = explode('|',$value); 
     if(!preg_match("/^([[:alnum:]]|-|_|[[:space:]]|[[:punct:]]|')+$/D",$value)) unset($values[$key]);   
    }
	  }
     return wp_ada_compliance_sanitize_text_or_array_field($values);
 } 

return array();
}


/**********************************************
// validate alnum space or puncuation in array
**********************************************/
function wp_ada_compliance_validate_alnum_punct_in_array($values){
 if(is_array($values) or $values == '') {
	  if(is_array($values)){
    foreach($values as $key => $value) {
     if(!preg_match("/^([[:alnum:]]|-|[[:space:]]|[[:punct:]]|')+$/D",$value)) unset($values[$key]);   
    }
	  }
     return wp_ada_compliance_sanitize_text_or_array_field($values);
 } 

return array();
}

/***************************************************
// validate alnum space or puncuation in text area
***************************************************/
function wp_ada_compliance_validate_alnum_punct_in_text_area($value){
if(preg_match("/^([[:alnum:]]|-|[[:space:]]|[[:punct:]]|')+$/D",$value)) return  sanitize_textarea_field($value); 
else return '';
}

/***************************************************
// validate alnum space or puncuation in text field
***************************************************/
function wp_ada_compliance_validate_alnum_punct_in_text_field($value){
if(preg_match("/^([[:alnum:]]|-|[[:space:]]|[[:punct:]]|'|»)+$/D",$value)) return  wp_ada_compliance_sanitize_text_or_array_field($value); 
else return '';
}

/***************************************************
// validate accessibility statement
***************************************************/
function wp_ada_compliance_validate_accessibility_widget_statement($value){
  
    return  strip_tags($value,'<a><br><span><p>'); 
    
    /*
if(preg_match("/^([[:alnum:]]|-|[[:space:]]|[[:punct:]]|[])+$/D",$value)) return  sanitize_textarea_field($value); 
else return __('The accessibility of our website is taken very seriously. We strive to meet WCAG 2.1 AA Web Accessibility standards by routinely evaluating our website using automated evaluation tools and manual testing when required. As content changes we review and correct issues and are responsive to our users needs. If you encounter issues with our website, please report them so they may be corrected in a timely manner.','wp-ada-compliance');*/
}

/***************************************************
// validate html allowed tags
***************************************************/
function wp_ada_compliance_validate_html_allowed_tags($value){
$value = trim($value);
if(preg_match("/^(<[[:alnum:]]+>)+$/i",$value)) return  str_replace(array('<script>','</script>'),'',$value); 
else return '<br>';
}

/***************************************************
// validate skip id
***************************************************/
function wp_ada_compliance_validate_skip_link_id($value){
$value = trim($value);
if(preg_match("/^(([[:alnum:]]|-|[[:space:]]|[[:punct:]])+[^`!()\[\]{};:'\".,<>«»“”‘’])$/i", $value)) return  wp_ada_compliance_sanitize_text_or_array_field($value); 
else return '';
}


/***************************************************
// validate read more text
***************************************************/
function wp_ada_compliance_validate_read_more_text($value){
if(preg_match("/^([[:alnum:]]|-|[[:space:]]|[[:punct:]]|'|»)+$/D",$value)) return  wp_ada_compliance_sanitize_text_or_array_field($value); 
else return __('Read More »','wp-ada-compliance');
}


/***************************************************
// validate notification_email
***************************************************/
function wp_ada_compliance_validate_notification_email($value){
$newvalue ='';
if(strstr($value,',')){
$parts = explode(',',$value);

foreach($parts as $key => $email){
if(filter_var($email, FILTER_VALIDATE_EMAIL)) $newvalue.= wp_ada_compliance_sanitize_text_or_array_field($email).','; 
}
}
else{
if(filter_var($value, FILTER_VALIDATE_EMAIL)) $newvalue = wp_ada_compliance_sanitize_text_or_array_field($value); 
}

if($newvalue != '') return rtrim($newvalue,',');
else return '';
}

/**********************************************
// validate terms
**********************************************/
function wp_ada_compliance_validate_terms($values){
global $wpdb;
$term_list = array();    
$table = $wpdb->prefix.'term_taxonomy';
$results = $wpdb->get_results("SELECT distinct(taxonomy) FROM $table", ARRAY_A);	
if($results){
foreach($results as $row){ 
	if(!in_array($row['taxonomy'], $term_list)) $term_list[] = $row['taxonomy'];
}
}
 if(is_array($values) or $values == '') {
	  if(is_array($values)){
    foreach($values as $key => $value) {
     if(!in_array($value,$term_list)) unset($values[$key]);    
    }
	  }
     return wp_ada_compliance_sanitize_text_or_array_field($values);
 }
return array('category');

}

/**********************************************
// validate metafields
**********************************************/
function wp_ada_compliance_validate_metafields($values){
global $wpdb;
$query = 'SELECT DISTINCT meta_key FROM '.$wpdb->prefix.'postmeta  ';

$results = $wpdb->get_results($query, ARRAY_A );
$meta_keylist = array();
if($results){
foreach($results as $row){ 
	if(!in_array($row['meta_key'], $meta_keylist)) $meta_keylist[] = $row['meta_key'];
}
}
 if(is_array($values) or $values == '') {
    if(is_array($values)){
	 foreach($values as $key => $value) {
     if(!in_array($value,$meta_keylist)) unset($values[$key]);    
    }
	}
     return wp_ada_compliance_sanitize_text_or_array_field($values);
 }
return array();

}

/**********************************************
// validate deep scan on editor screen
**********************************************
function wp_ada_compliance_validate_elementor_icon_and_img_widgets($value) {
$accepted = array('remove-iconlink','false','remove-titlelink','remove-centeronly');

if(in_array($value,$accepted)) return wp_ada_compliance_sanitize_text_or_array_field($value);   

return 'false';
}*/


/**********************************************
// validate deep scan on editor screen
**********************************************/
function wp_ada_compliance_validate_full_deep_scan_on_editor($value) {
$accepted = array('true','false','disabled');

if(in_array($value,$accepted)) return wp_ada_compliance_sanitize_text_or_array_field($value);   

return 'true';
}

/**********************************************
// validate post types
**********************************************/
function wp_ada_compliance_validate_posttypes($values) {
//global $wpdb;
    $post_type_list = array();
    // changed from database check for post types to get_post_type, remove after next schedule release
/*$results = $wpdb->get_results("SELECT distinct(post_type) FROM ".$wpdb->prefix."posts", ARRAY_A);	
if($results){
foreach($results as $row){ 
	if(!in_array($row['post_type'], $post_type_list )) $post_type_list[] = $row['post_type'];
}
}*/
$get_cpt_args = array(
    'public'   => true,
    '_builtin' => false
);
$post_types = get_post_types( $get_cpt_args, 'object' );
$post_type_list[] = "post";
$post_type_list[] = "page";   
foreach($post_types as $key => $value){ 
	if(!in_array($key, $post_type_list )) $post_type_list[] = $key;
}    
    
 if(is_array($values) or $values == '') {
	  if(is_array($values)){
    foreach($values as $key => $value) {
     if(!in_array($value,$post_type_list)) unset($values[$key]);  
    }
	  }
     return wp_ada_compliance_sanitize_text_or_array_field($values);
 }
return array('page','post');
}

/**********************************************
// validate scan rules
**********************************************/
function wp_ada_compliance_validate_scan_rules($values){
    global $wp_ada_compliance_def;
    
$allowed = array();    
    
    if(is_array($wp_ada_compliance_def))
foreach ($wp_ada_compliance_def as $rows => $row){
    if(!in_array($rows, $allowed )) $allowed[] = $rows;
}
    
 if(is_array($values) or $values == '') {
	  if(is_array($values)){
    foreach($values as $key => $value) {
     if(!in_array($value,$allowed)) unset($values[$key]);  
    }
	  }
     return wp_ada_compliance_sanitize_text_or_array_field($values);
 } 
return $allowed;    
}

   
/**********************************************
// validate widget placement
**********************************************/
function wp_ada_compliance_validate_widget_placement($value){
if(in_array($value,array('top','bottom','left'))) return wp_ada_compliance_sanitize_text_or_array_field($value); 
else return 'bottom';
}

/**********************************************
// validate auto scan options
**********************************************/
function wp_ada_compliance_validate_auto_scan_options($value){
if(in_array($value,array('monthly','weekly','daily','twicedaily','hourly','wpada30minutes','wpada15minutes','wpada5minutes','false'))) return wp_ada_compliance_sanitize_text_or_array_field($value); 
else return 'false';
}

/**********************************************
// validate widget options
**********************************************/
function wp_ada_compliance_validate_widget_options($value){
if(in_array($value,array('true','false','nobadge','badgeonly'))) return wp_ada_compliance_sanitize_text_or_array_field($value); 
else return 'false';
}


/**********************************************
// validate notification frequency
**********************************************/
function wp_ada_compliance_validate_notification_frequency($value){
if(in_array($value,array('monthly','weekly','daily','twicedaily','hourly'))) return wp_ada_compliance_sanitize_text_or_array_field($value); 
else return 'daily';
}

/**********************************************
// validate url
**********************************************/
function wp_ada_compliance_validate_url($value){
if(filter_var($value, FILTER_VALIDATE_URL)) return esc_url_raw($value); 
else return '';
}

/***************************************************
// validate excluded code blocks
***************************************************/
function wp_ada_compliance_validate_ignore_code_blocks($values){
 if(is_array($values) or $values == '') {
	  if(is_array($values)){
    foreach($values as $key => $value) {
     if(!preg_match("/^(([[:alnum:]]|-|[[:space:]]|[[:punct:]])+[^`!()\[\]{};:'\".,<>«»“”‘’])$/i", $value)) unset($values[$key]);   
    }
	  }
     return wp_ada_compliance_sanitize_text_or_array_field($values);
 } 

return array();
}

/**********************************************
// validate number
**********************************************/
function wp_ada_compliance_validate_number($value){
if(!is_numeric($value)) return '10';
    return (int)$value;
}
function wp_ada_compliance_validate_number_default_empty($value){
if(!is_numeric($value)) return '';
    return (int)$value;
}

/**********************************************
// validate true false values DEFAULT to true
**********************************************/
function wp_ada_compliance_validate_false_default_true($value){
if(in_array($value,array('true','false'))) return wp_ada_compliance_sanitize_text_or_array_field($value); 
else return 'true';
}

/**********************************************
// validate true false values DEFAULT to false
**********************************************/
function wp_ada_compliance_validate_true_default_false($value){
if(in_array($value,array('true','false'))) return wp_ada_compliance_sanitize_text_or_array_field($value); 
else return 'false';
}
/**********************************************
// validate settings users
**********************************************/
function wp_ada_compliance_validate_settingsusers($value){
if(in_array($value,array('edit_pages','manage_options'))) return wp_ada_compliance_sanitize_text_or_array_field($value); 
else return 'manage_options';
}

/**********************************************
// validate filtered errors
**********************************************/
function wp_ada_compliance_validate_filtered_errors($value){
if(in_array($value,array('scanonly','false','true'))) return wp_ada_compliance_sanitize_text_or_array_field($value); 
else return 'scanonly';
}

/**********************************************
// validate change fontsize
**********************************************/
function wp_ada_compliance_validate_changefontsize($value){
if(in_array($value,array('percent','em','false'))) return wp_ada_compliance_sanitize_text_or_array_field($value); 
else return 'percent';
}

/**********************************************
// validate change justified text
**********************************************/
function wp_ada_compliance_validate_change_justified_text($value){
if(in_array($value,array('left','right','false'))) return wp_ada_compliance_sanitize_text_or_array_field($value); 
else return 'left';
}

/**********************************************
// validate change non html links
**********************************************/
function wp_ada_compliance_validate_non_html_links($value){
if(in_array($value,array('addtitle','iconandtitle','titleonly','false'))) return wp_ada_compliance_sanitize_text_or_array_field($value); 
else return 'titleonly';
}


/**********************************************
// validate striptarget
**********************************************/
function wp_ada_compliance_validate_striptarget($value){
if(in_array($value,array('addtitle','remove','addcsshover','append','addicon','false'))) return wp_ada_compliance_sanitize_text_or_array_field($value); 
else return 'addcsshover';
}


/**********************************************
// validate language code
**********************************************/
function wp_ada_compliance_validate_language_code($value){
if(preg_match('/^[a-z]{2}(-[A-Z]{2})?$/i',$value)) return wp_ada_compliance_sanitize_text_or_array_field($value); 
else return 'en';
}

/**********************************************
// validate background color
**********************************************/
function wp_ada_compliance_validate_background_color($value){
if(preg_match('/^#([a-f0-9]{6}|[a-f0-9]{3})\b$/i',$value)) return wp_ada_compliance_sanitize_text_or_array_field($value); 
else return '#ffffff';
}

/**********************************************
// validate foreground color
**********************************************/
function wp_ada_compliance_validate_foreground_color($value){
if(preg_match('/^#([a-f0-9]{6}|[a-f0-9]{3})\b$/i',$value)) return wp_ada_compliance_sanitize_text_or_array_field($value); 
else return '#000000';
}

/**********************************************
// validate outline color
**********************************************/
function wp_ada_compliance_validate_outline_color($value){
if(preg_match('/^#([a-f0-9]{6}|[a-f0-9]{3})\b$/i',$value)) return wp_ada_compliance_sanitize_text_or_array_field($value); 
else return '#5E9ED6';
}

/**********************************************
// validate hex color
**********************************************/
function wp_ada_compliance_validate_hex_color($value){
if(preg_match('/^#([a-f0-9]{6}|[a-f0-9]{3})\b$/i',$value)) return wp_ada_compliance_sanitize_text_or_array_field($value); 
else return '';
}

/**********************************************
// validate starting H level
**********************************************/
function wp_ada_compliance_validate_starting_H_level($value){
if(in_array($value,array('h1','h2'))) return wp_ada_compliance_sanitize_text_or_array_field($value); 
else return 'h2';
}

/**********************************************
// validate font size selector
**********************************************/
function wp_ada_compliance_validate_starting_font_size_selector($value){
if(in_array($value,array('percent','em','default'))) return wp_ada_compliance_sanitize_text_or_array_field($value); 
else return 'percent';
}

/*********************************************
validate input
********************************************/
function wp_ada_compliance_validate_form_values(){
global $wpdb, $wp_ada_compliance_def;    
$error = '';
        
    
// validate post input    
foreach($_POST as $key => $value){ 
    
$_POST[$key] = sanitize_text_field($_POST[$key]);    
  
//error email
if($key == 'email' and !filter_var($value, FILTER_VALIDATE_EMAIL)){
$error = __('Email address is invalid','wp-ada-compliance');
}
    
    //error types
if($key == 'comments' and !preg_match("/^([[:alnum:]]|-|[[:space:]]|[[:punct:]]|')+$/D", $value) and $value != ''){
$error = __('Comments contain invalid text.','wp-ada-compliance');
}
    
elseif($key == 'error' and !array_key_exists($value,$wp_ada_compliance_def) and $value != ''){
$_POST['error'] = '';
}     
     
// check title search
if($key == 'searchtitle' and !preg_match("/^([[:alnum:]]|-|[[:space:]]|[[:punct:]]|')+$/D",$value) and $value != ''){
$_POST['searchtitle'] = '';
}        
    
//post types
if($key == 'type'){
$accepted =  array();
$query = "SELECT distinct(type) FROM ".$wpdb->prefix."wp_ada_compliance";
$results = $wpdb->get_results($query, ARRAY_A );
foreach ( $results as $row ) {
$accepted[] = $row['type'];
}
 if(!in_array($value,$accepted) and $value != '') 
$_POST['type'] = '';  
}      
}
    
foreach($_GET as $key => $value){
 
   $_GET[$key] = sanitize_text_field($_GET[$key]);
    
    
/*********************************
settings
*********************************/
    //post types
if($key == 'post_type'){
$accepted =  array('');
$results = $wpdb->get_results("SELECT distinct(post_type) FROM ".$wpdb->prefix."posts", ARRAY_A);	
foreach ( $results as $row ) {
$accepted[] = $row['post_type'];
}
 if(!in_array($value,$accepted) and $value != '') {
$_GET['post_type'] = ''; 
 }

}      

  
/********************
// link report 
*********************/    
if($key == 'monitor'){
$acceptable = array('yes','no','ignore');    
if(!in_array($value,$acceptable))    
$_GET['monitor'] = '';
}
    
if($key == 'linkstatus' and $value != ''){
$acceptable = array(); 
$query = "SELECT distinct(linkstatus) FROM ".$wpdb->prefix."wp_ada_compliance_links";
$results = $wpdb->get_results($query, ARRAY_A );
foreach ( $results as $row ) {
if(!in_array($row['linkstatus'],$acceptable)) $acceptable[] = $row['linkstatus'];
}    
if(!in_array($value,$acceptable))    
$_GET['linkstatus'] = '';
} 
    
if($key == 'searchtype'){
$accepted =  array('');
$query = "SELECT distinct(type) FROM ".$wpdb->prefix."wp_ada_compliance_links";
$results = $wpdb->get_results($query, ARRAY_A );
foreach ( $results as $row ) {
$accepted[] = $row['type'];
}
 if(!in_array($value,$accepted) and $value != '') 
$_GET['searchtype'] = '';  
}  
    
if($key == 'search' and !preg_match("/^([[:alnum:]]|-|[[:space:]]|[[:punct:]]|')+$/D",$value) and $value != ''){
$_GET['search'] = '';
}       

/********************
// error report 
*********************/
if($key == 'modifieddate' and wp_ada_compliance_validateDate($value,'m|d|Y') and $value != ''){
$_GET['modifieddate'] = '';
}
    
if($key == 'errorw' and !array_key_exists($value,$wp_ada_compliance_def) and $value != '' and $value != 'W' and $value != 'A'){
$_GET['errorw'] = '';
}
elseif($key == 'error' and !array_key_exists($value,$wp_ada_compliance_def) and $value != '' and $value != 'W' and $value != 'A'){
$_GET['error'] = '';
}     
     
if($key == 'searchtitle' and !preg_match("/^([[:alnum:]]|-|[[:space:]]|[[:punct:]]|')+$/D",$value) and $value != ''){
$_GET['searchtitle'] = '';
}        
    
if($key == 'type'){
$accepted =  array('attachment','pdf','term','post','page','customfield','excerpt', 'widget');
$query = "SELECT distinct(type) FROM ".$wpdb->prefix."wp_ada_compliance_links";
$results = $wpdb->get_results($query, ARRAY_A );
foreach ( $results as $row ) {
if(!in_array($row['type'], $accepted)) $accepted[] = $row['type'];
}
 if(!in_array($value,$accepted) and $value != '') 
$_GET['type'] = '';  
}     


/********************
// global / ignore
*********************/
 if($key == 'wpada_ignore_rule'){
   if(!array_key_exists($value,$wp_ada_compliance_def)){
    $_GET['wpada_ignore_rule'] = '';
}
}
 if($key == 'wpadaignorerule'){
     $values = explode('|',$_GET[ 'wpadaignorerule' ]); 
   if(!array_key_exists($values[2],$wp_ada_compliance_def)){
    $_GET['wpadaignorerule'] = '';
}
}    
if($key == 'wpadaignoreall'){
   $values = explode('-',$_GET[ 'wpadaignoreall' ]); 
   if(!array_key_exists($values[2],$wp_ada_compliance_def)){
    $_GET['wpadaignoreall'] = '';
}
}
    
if($key == 'wpadaignorefile'){
 if(!preg_match("/^([[:alnum:]]|\||-|_|[[:space:]]|[[:punct:]]|')+$/D",$value)) {
     $_GET[$key] = '';
 }
}
    
    
 if($key == 'errorcode'){
   if(!array_key_exists($value,$wp_ada_compliance_def)){
    $_GET['errorcode'] = '';
}
}
    
if($key == 'scantype'){
 if(!preg_match("/^([[:alnum:]]|\||-|_|[[:space:]]|[[:punct:]]|')+$/D",$value)) {
$_GET['scantype'] = '';  
} 
}
    
if($key == 'posttype'){
$accepted =  array('');
$query = "SELECT distinct(type) FROM ".$wpdb->prefix."wp_ada_compliance_links";
$results = $wpdb->get_results($query, ARRAY_A );
foreach ( $results as $row ) {
$accepted[] = $row['type'];
}
 if(!in_array($value,$accepted) and $value != '') 
$_GET['posttype'] = '';  
}      
    
} // end get loop
    
return $error;      
}
// validate date
function wp_ada_compliance_validateDate($date, $format = 'Y-m-d'){
    $d = DateTime::createFromFormat($format, $date);
    return $d && $d->format($format) === $date;
}


/*********************************************************
sanitize array
*********************************************************/
function wp_ada_compliance_sanitize_text_or_array_field($array_or_string) {
    if( is_string($array_or_string) ){
        $array_or_string = sanitize_text_field($array_or_string);
    }elseif( is_array($array_or_string) ){
        foreach ( $array_or_string as $key => &$value ) {
            if ( is_array( $value ) ) {
                $value = sanitize_text_or_array_field($value);
            }
            else {
                $value = sanitize_text_field( $value );
            }
        }
    }

    return $array_or_string;
}
?>