<?php 
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;
/*****************************************************
// cron function to send notifications of new issues
****************************************************/
function wp_ada_compliance_send_email_notifications() {
  	$notification_email = get_option('wp_ada_compliance_notification_email','');
	
	$emailaddresses = explode(",",$notification_email);
	foreach($emailaddresses as $key => $email){
	if($email !=  '') {
	$headers = array('Content-Type: text/html; charset=UTF-8');
	$blogname = get_bloginfo('name');
	$subject = sprintf(__('%s', 'wp-ada-compliance'), esc_html($blogname));
	$subject .= __(' Web Accessibility Report', 'wp-ada-compliance');
	
	$body = wp_ada_compliance_create_email_report($email);
	if($body != ''){
       $body = '<h2>'.__(' Web Accessibility Report', 'wp-ada-compliance').'</h2>'.$body;
	wp_mail($email, $subject, $body, $headers );
    }
	}
	}
}
/********************************************
// send email report
**********************************************/
function wp_ada_compliance_send_report(){
    
    $error = wp_ada_compliance_validate_form_values();
    
    $urlstring = get_site_url().'/wp-admin/admin.php?page=ada_compliance%2Fcompliancereport.php';
   foreach($_GET as $key => $value){
       if($key != 'page' and $key != 'iframe') $urlstring .= '&'.$key.'='.$value;
   }
    $reportlink = '<a href="'.esc_url($urlstring).'">'.__(' View Report', 'wp-ada-compliance').'</a>';
   
    
	if(isset($_GET['view'])) {
		$postinfo['view'] = (int)$_GET['view'];
	} else $postinfo['view'] = 1;
	if(isset($_GET['sort'])) {
		$postinfo['sort'] = (int)$_GET['sort'];
	} else $postinfo['sort'] = 1;
	if(isset($_GET['errorid'])) {
		$postinfo['errorid'] = (int)$_GET['errorid'];
	} else $postinfo['errorid'] = "";
	if(isset($_GET['error'])) {
		$postinfo['error'] = sanitize_text_field($_GET['error']);
	} else $postinfo['error'] = "";
	if(isset($_GET['type'])) {
		$postinfo['type'] = sanitize_text_field($_GET[ 'type' ]);
	} else $postinfo['type'] = "";
	if(isset($_GET['searchtitle'])) {
	$postinfo['searchtitle'] = sanitize_text_field($_GET['searchtitle']);
	} else $postinfo['searchtitle'] = "";
	if(isset($_GET['excludedups'])) {
		$postinfo['excludedups'] = (int)$_GET['excludedups'];
	} else $postinfo['excludedups'] = 0;
	if(isset($_GET['excludethemes'])) {
		$postinfo['excludethemes'] = (int)$_GET['excludethemes'];
	} else $postinfo['excludethemes'] = 0;
    if(isset($_GET['modifieddate'])) {
		$postinfo['modifieddate'] = sanitize_text_field($_GET['modifieddate']);
	} else $postinfo['modifieddate'] ='';
	
		
if(isset($_POST['email']) and $error ==''){
	$postinfo['email'] = sanitize_text_field($_POST['email']);
    $postinfo['reporttype'] = (int)$_POST['reporttype'];
	$postinfo['view'] = (int)$_POST['view'];
	$postinfo['sort'] = (int)$_POST['sort'];
	$postinfo['errorid'] = (int)$_POST['errorid'];
	$postinfo['error'] = sanitize_text_field($_POST[ 'error' ]);
	$postinfo['type'] = sanitize_text_field($_POST[ 'type' ]);
    $postinfo['comments'] = sanitize_text_field($_POST[ 'comments' ]);	
	$postinfo['searchtitle'] = sanitize_text_field($_POST['searchtitle']);
	$postinfo['excludedups'] = (int)$_GET['excludedups'];
	$postinfo['excludethemes'] = (int)$_GET['excludethemes'];
    $postinfo['modifieddate'] = sanitize_text_field($_GET['modifieddate']);
    
	
$headers = array('Content-Type: text/html; charset=UTF-8');
    
	$blogname = get_bloginfo('name');
	$subject = sprintf(__('%s', 'wp-ada-compliance'), esc_html($blogname));
	$subject .= __(' Web Accessibility Report', 'wp-ada-compliance');
	if($postinfo['reporttype'] == 2)
	$body = wp_ada_compliance_create_email_report($postinfo['email'],$postinfo);
    elseif($postinfo['reporttype'] == 1)
    $body = wp_ada_compliance_create_summary_report($postinfo,'email');
	if($body != ''){
	$body = '<p>'.$postinfo['comments'].'</p>'.$reportlink.$body;

        $body = '<h2>'.__(' Web Accessibility Report', 'wp-ada-compliance').'</h2>'.$body;
	wp_mail($postinfo['email'], $subject, $body, $headers );
	echo '<p class="ada_report_sent">';
		_e('Report sent!', 'wp-ada-compliance');
	echo '</p>';	
	}else{
	echo '<p class="adaRedText">';
		_e('No records to send!', 'wp-ada-compliance');
	echo '</p>';		
	}
}elseif($error != '') echo '<p class="notice notice-error">'.esc_attr($error).'</p>';
    
$total_records = wp_ada_compliance_count_errors();
    
echo "<style>#wpadminbar, #adminmenuwrap, #adminmenuback{display:none;} body{margin-left:15px; margin-top: -40px;}</style>";
echo '<form action="" method="post" class="wp-ada-send-report">
	<p><label for="email">'.__('Email:','wp-ada-compliance').' <input type="text" id="email" name="email"></label>
	<input type="submit"></p>
    <p><label for="summary"><input type="radio" id="summary" name="reporttype" value="1" checked>'.__('summary report','wp-ada-compliance').' ';
    if($total_records >0){
        echo'</label><label for="full"><input type="radio" id="full" name="reporttype" value="2">'.__('full report','wp-ada-compliance').' </label>';
    }
echo'</p>
<p><label for="comments">'.__('Comments:','wp-ada-compliance').'<br /><textarea id="comments" name="comments" cols="45" rows="5"></textarea></label></p>
<input type="hidden" name="view" value="'.esc_attr($postinfo['view']).'" />
<input type="hidden" name="error" value="'.esc_attr($postinfo['error']).'" />
<input type="hidden" name="errorid" value="'.esc_attr($postinfo['errorid']).'" />
	<input type="hidden" name="type" value="'.esc_attr($postinfo['type']).'" />
	<input type="hidden" name="sort" value="'.esc_attr($postinfo['sort']).'" />
		<input type="hidden" name="excludethemes" value="'.esc_attr($postinfo['excludethemes']).'" />
		<input type="hidden" name="excludedups" value="'.esc_attr($postinfo['excludedups']).'" />
	<input type="hidden" name="searchtitle" value="'.esc_attr($postinfo['searchtitle']).'" />
	</form>';
}
/********************************************
// print report
**********************************************/
function wp_ada_compliance_print_report(){
    wp_ada_compliance_validate_form_values();
  
    
	if(isset($_GET['view'])) {
		$postinfo['view'] = (int)$_GET['view'];
	} else $postinfo['view'] = 1;
	if(isset($_GET['sort'])) {
		$postinfo['sort'] = (int)$_GET['sort'];
	} else $postinfo['sort'] = 1;
	if(isset($_GET['errorid'])) {
		$postinfo['errorid'] = (int)$_GET['errorid'];
	} else $postinfo['errorid'] = "";
	if(isset($_GET['error'])) {
		$postinfo['error'] = sanitize_text_field($_GET['error']);
	} else $postinfo['error'] = "";
	if(isset($_GET['type'])) {
		$postinfo['type'] = sanitize_text_field($_GET[ 'type' ]);
	} else $postinfo['type'] = "";
	if(isset($_GET['searchtitle'])) {
	$postinfo['searchtitle'] = sanitize_text_field($_GET['searchtitle']);
	} else $postinfo['searchtitle'] = "";
	if(isset($_GET['excludedups'])) {
		$postinfo['excludedups'] = (int)$_GET['excludedups'];
	} else $postinfo['excludedups'] = 0;
	if(isset($_GET['excludethemes'])) {
		$postinfo['excludethemes'] = (int)$_GET['excludethemes'];
	} else $postinfo['excludethemes'] = 0;
    
    if(isset($_GET['modifieddate'])) {
	$postinfo['modifieddate'] = sanitize_text_field($_GET['modifieddate']);
	} else $postinfo['modifieddate'] ='';

    $headers = array('Content-Type: text/html; charset=UTF-8');
    $body = '';
    
        
    if(isset($_GET['wp-ada-report'])){
        // print full report
        if($_GET['wp-ada-report'] ==1){
            echo '<div class="wp-ada-preparing-report2">';
     echo __('Stand by while we create the report, this could take a few minutes.', 'wp-ada-compliance');
     echo '</div>';
        
        $blogname = get_bloginfo('name');
        $subject = sprintf(__('%s', 'wp-ada-compliance'), esc_html($blogname));
        $subject .= __(' Web Accessibility Report', 'wp-ada-compliance');

       $body = wp_ada_compliance_create_email_report('print',$postinfo);
        }
         if($_GET['wp-ada-report'] ==2){
            $body = wp_ada_compliance_create_summary_report($postinfo, 'print');
        }
    }
     echo '<div class="wp-ada-preparing-report"><span class="adaworking">&nbsp;</span> ';
     echo __('Preparing report', 'wp-ada-compliance');
     echo '</div>';
     
    echo'<div class="wp-ada-print-btns">';
    
    $total_records = wp_ada_compliance_count_errors();
    if($total_records >0){
        echo '<p><a href="'.esc_url(get_site_url()).'/wp-admin/admin.php?page=ada_compliance/print-report.php&wp-ada-report=1&excludedups='.esc_attr($postinfo['excludedups']).'&excludethemes='.esc_attr($postinfo['excludethemes']).'&error='.esc_attr($postinfo['error']).'&type='.esc_attr($postinfo['type']).'&errorid='.esc_attr($postinfo['errorid']).'&searchtitle='.esc_attr($postinfo['searchtitle']).'&view='.esc_attr($postinfo['view']).'&modifieddate='.esc_attr($postinfo['modifieddate']).'&iframe=1&TB_iframe=true&width=450&height=250" class="btnwpada btnwpada-primary wp-ada-report-btn">';
      _e(' Full Report', 'wp-ada-compliance');  
        echo '</a></p>';
    }
    
            echo '<p><a href="'.esc_url(get_site_url()).'/wp-admin/admin.php?page=ada_compliance/print-report.php&wp-ada-report=2&excludedups='.esc_attr($postinfo['excludedups']).'&excludethemes='.esc_attr($postinfo['excludethemes']).'&error='.esc_attr($postinfo['error']).'&type='.esc_attr($postinfo['type']).'&errorid='.esc_attr($postinfo['errorid']).'&searchtitle='.esc_attr($postinfo['searchtitle']).'&view='.esc_attr($postinfo['view']).'&modifieddate='.esc_attr($postinfo['modifieddate']).'&iframe=1&TB_iframe=true&width=450&height=250" class="btnwpada btnwpada-primary wp-ada-report-btn">';
      _e(' Summary Report', 'wp-ada-compliance');  
        echo '</a></p>';
	if($total_records >0){
		echo '<p> <a href="'.esc_url(get_site_url()).'/wp-admin/admin.php?page=ada_compliance/export-report.php&excludedups='.esc_attr($postinfo['excludedups']).'&excludethemes='.esc_attr($postinfo['excludethemes']).'&error='.esc_attr($postinfo['error']).'&type='.esc_attr($postinfo['type']).'&errorid='.esc_attr($postinfo['errorid']).'&modifieddate='.esc_attr($postinfo['modifieddate']).'&searchtitle='.esc_attr($postinfo['searchtitle']).'&view='.esc_attr($postinfo['view']).'&iframe=1&TB_iframe=true&width=450&height=250" class="thickbox btnwpada btnwpada-primary" name="'.__('Download started, close this window when the download is complete.', 'wp-ada-compliance').'"> '.__('Export to Excel', 'wp-ada-compliance').'</a></p>';	
    }
	echo '<p>  <a href="'.esc_url(get_site_url()).'/wp-admin/admin.php?page=ada_compliance/send-report.php&excludedups='.esc_attr($postinfo['excludedups']).'&excludethemes='.esc_attr($postinfo['excludethemes']).'&error='.esc_attr($postinfo['error']).'&modifieddate='.esc_attr($postinfo['modifieddate']).'&type='.esc_attr($postinfo['type']).'&errorid='.esc_attr($postinfo['errorid']).'&searchtitle='.esc_attr($postinfo['searchtitle']).'&view='.esc_attr($postinfo['view']).'&iframe=1&TB_iframe=true&width=450&height=275" class="thickbox btnwpada btnwpada-primary" name="'.__('Email this report.', 'wp-ada-compliance').'">'.__('Email', 'wp-ada-compliance').'</a></p>';
	
    echo'</div>';
    
    
    if($body != ''){
                // get logo image    
$license_expire_date = get_option('wp_ada_compliance_license_expire_date','');    
if($license_expire_date == '' or strtotime($license_expire_date) > time()){    
 $image_id  = get_option( 'wp_ada_compliance_report_logo');
if( intval( $image_id ) > 0 ) {
// Change with the image size you want to use
$image = wp_get_attachment_image( $image_id, 'full', false, array( 'id' => 'wp-ada-compliance-logo' ) );
}
}
        
        $blogname = get_bloginfo('name');
        $subject = sprintf(__('%s', 'wp-ada-compliance'), esc_html($blogname));
        $subject .= __(' Web Accessibility Report', 'wp-ada-compliance');
        
        echo '<div class="wp-ada-print_results">';
         if(isset($image)) echo $image;
        echo '<h2>'.$subject.'</h2>'.$body.'</div>';
       // echo __('- End of Report -', 'wp-ada-compliance');
echo '<script>window.print();</script>';
	}

}
?>