<?php 
/*
Plugin - WP ADA Compliance Check
functions to display admin setting pages and process related actions
*/
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;
/************************************************************
// add the admin settings 
**********************************************************/
function  wp_ada_compliance_admin_init(){

/***********************************************************************
DEFINE CONTENT TO SCAN SETTINGS
**************************************************************************/	
add_settings_section('wp_ada_compliance_scantypes', __('Content To Monitor', 'wp-ada-compliance'), 'wp_ada_compliance_scantypetext', 'wp_ada_compliance');		

// theme files
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_scan_themes', array('type' => 'array','sanitize_callback' =>'wp_ada_compliance_validate_scan_themes'));
add_settings_field('wp_ada_compliance_scan_themes', '', 'wp_ada_compliance_settings_scan_themes', 'wp_ada_compliance', 'wp_ada_compliance_scantypes');	
    
    // post types
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_posttypes',array('type' => 'array','sanitize_callback' =>'wp_ada_compliance_validate_posttypes'));
add_settings_field('wp_ada_compliance_posttypes', '', 'wp_ada_compliance_settings_posttypes', 'wp_ada_compliance', 'wp_ada_compliance_scantypes');
    
// terms
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_terms',array('type' => 'array','sanitize_callback' => 'wp_ada_compliance_validate_terms'));
add_settings_field('wp_ada_compliance_terms', '', 'wp_ada_compliance_settings_terms', 'wp_ada_compliance', 'wp_ada_compliance_scantypes');    
	
	// external source files
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_scan_external_sources', array('type' => 'array','sanitize_callback' =>'wp_ada_compliance_validate_scan_external_sources'));
add_settings_field('wp_ada_compliance_scan_external_sources', '', 'wp_ada_compliance_settings_scan_external_sources', 'wp_ada_compliance', 'wp_ada_compliance_scantypes');
	
	
	// external sources file domains
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_scan_external_domains',array('type' => 'string','sanitize_callback' =>'wp_ada_compliance_validate_true_default_false'));
add_settings_field('wp_ada_compliance_scan_external_domains', '', 'wp_ada_compliance_settings_scan_external_domains', 'wp_ada_compliance', 'wp_ada_compliance_scantypes');	
 
    	//  excluded link paths 
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_excluded_link_path', array('type' => 'array','sanitize_callback' =>'wp_ada_compliance_validate_slug_path'));
add_settings_field('wp_ada_compliance_excluded_link_path', '', 'wp_ada_compliance_settings_excluded_link_path', 'wp_ada_compliance', 'wp_ada_compliance_scantypes');

 //  excluded link paths 
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_ignore_code_blocks', array('type' => 'array','sanitize_callback' =>'wp_ada_compliance_validate_ignore_code_blocks'));
add_settings_field('wp_ada_compliance_ignore_code_blocks', '', 'wp_ada_compliance_settings_ignore_code_blocks', 'wp_ada_compliance', 'wp_ada_compliance_scantypes');
	
	// scan widgets
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_scan_widgets',array('type' => 'string','sanitize_callback' =>'wp_ada_compliance_validate_false_default_true'));
add_settings_field('wp_ada_compliance_scan_widgets', '', 'wp_ada_compliance_settings_scan_widgets', 'wp_ada_compliance', 'wp_ada_compliance_scantypes');	
    
// custom fields
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_metafields',array('type' => 'array','sanitize_callback' => 'wp_ada_compliance_validate_metafields'));
add_settings_field('wp_ada_compliance_metafields', '', 'wp_ada_compliance_settings_metafields', 'wp_ada_compliance', 'wp_ada_compliance_scantypes');	    
	
/***********************************************************************
DEFINE FILTERS SETTINGS
**************************************************************************/
add_settings_section('wp_ada_compliance_filters', __('Content Filters', 'wp-ada-compliance'), 'wp_ada_compliance_filtertext', 'wp_ada_compliance');	
		
// turn on content filtering
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_filter_content', array('type' => 'string','sanitize_callback' => 'wp_ada_compliance_validate_false_default_true'), array('type' => 'string','sanitize_callback' => 'wp_ada_compliance_validate_false_default_true'));
add_settings_field('wp_ada_compliance_filter_content', '', 'wp_ada_compliance_settings_filter_content', 'wp_ada_compliance', 'wp_ada_compliance_filters');		
		
	// allow users to exclude pages from php filtering
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_php_buffering_page_exclusions', array('type' => 'array','sanitize_callback' =>'wp_ada_compliance_validate_slug_path'));
add_settings_field('wp_ada_compliance_php_buffering_page_exclusions', '', 'wp_ada_compliance_settings_php_buffering_page_exclusions', 'wp_ada_compliance', 'wp_ada_compliance_filters');
    
    // report issues that are being filtered
	/*
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_report_filtered_errors', array('type' => 'string','sanitize_callback' =>'wp_ada_compliance_validate_filtered_errors'));
add_settings_field('wp_ada_compliance_report_filtered_errors', '', 'wp_ada_compliance_settings_report_filtered_errors', 'wp_ada_compliance', 'wp_ada_compliance_filters');*/
		
	
	// change font size in content
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_changefontsize', array('type' => 'string','sanitize_callback' =>'wp_ada_compliance_validate_changefontsize'));
add_settings_field('wp_ada_compliance_changefontsize', '', 'wp_ada_compliance_settings_changefontsize', 'wp_ada_compliance', 'wp_ada_compliance_filters');	
	
	// change justified text in content
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_changejustifiedtext', array('type' => 'string','sanitize_callback' =>'wp_ada_compliance_validate_change_justified_text'));
add_settings_field('wp_ada_compliance_changejustifiedtext', '', 'wp_ada_compliance_settings_changejustifiedtext', 'wp_ada_compliance', 'wp_ada_compliance_filters');		

// strip redundant text
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_strip_redundant_alt_txt', array('type' => 'string','sanitize_callback' => 'wp_ada_compliance_validate_false_default_true')); 
add_settings_field('wp_ada_compliance_strip_redundant_alt_txt', '', 'wp_ada_compliance_settings_strip_redundant_alt_txt', 'wp_ada_compliance','wp_ada_compliance_filters');	
    
// add icon to in page links
//register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_correct_link_to_in_page_content');
//add_settings_field('wp_ada_compliance_correct_link_to_in_page_content', '', 'wp_ada_compliance_settings_correct_link_to_in_page_content', 'wp_ada_compliance', 'wp_ada_compliance_filters');
    
    // add icon to external document file links
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_correct_non_html_links', array('type' => 'string','sanitize_callback' => 'wp_ada_compliance_validate_non_html_links'));
add_settings_field('wp_ada_compliance_correct_non_html_links', '', 'wp_ada_compliance_settings_correct_non_html_links', 'wp_ada_compliance', 'wp_ada_compliance_filters');
	
// strip target
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_striptarget', array('type' => 'string','sanitize_callback' => 'wp_ada_compliance_validate_striptarget'));
add_settings_field('wp_ada_compliance_striptarget', '', 'wp_ada_compliance_settings_striptarget', 'wp_ada_compliance', 'wp_ada_compliance_filters');
	
// strip tags
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_striptags', array('type' => 'string','sanitize_callback' => 'wp_ada_compliance_validate_false_default_true'));
add_settings_field('wp_ada_compliance_striptags', '', 'wp_ada_compliance_settings_striptags', 'wp_ada_compliance', 'wp_ada_compliance_filters');	
	
// correct unlinked email addresses
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_link_email_addresses', array('type' => 'string','sanitize_callback' => 'wp_ada_compliance_validate_false_default_true'));
add_settings_field('wp_ada_compliance_link_email_addresses', '', 'wp_ada_compliance_link_email_addresses_settings', 'wp_ada_compliance', 'wp_ada_compliance_filters');		
	
// edit embed code to add title attributes to iframe tags
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_edit_embed_code', array('type' => 'string','sanitize_callback' => 'wp_ada_compliance_validate_false_default_true'));
add_settings_field('wp_ada_compliance_edit_embed_code', '', 'wp_ada_compliance_settings_edit_embed_code', 'wp_ada_compliance', 'wp_ada_compliance_filters');
	
// detect post title and add aria-label to ambiguous links when possible
//register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_correct_ambiguous_link_text');
//add_settings_field('wp_ada_compliance_correct_ambiguous_link_text', array('type' => 'string','sanitize_callback' => 'wp_ada_compliance_validate_false_default_true'), 'wp_ada_compliance_settings_correct_ambiguous_link_text', 'wp_ada_compliance', 'wp_ada_compliance_filters');
    

    // convert titles to aria-labels when no link text is found
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_convert_link_titles');
add_settings_field('wp_ada_compliance_convert_link_titles', array('type' => 'string','sanitize_callback' => 'wp_ada_compliance_validate_false_default_true'), 'wp_ada_compliance_settings_convert_link_titles', 'wp_ada_compliance', 'wp_ada_compliance_filters');    
        
	
// options to convert links titles on font awesome icon to aria-label
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_link_titles_font_awesome', array('type' => 'string','sanitize_callback' => 'wp_ada_compliance_validate_false_default_true'));
add_settings_field('wp_ada_compliance_link_titles_font_awesome', '', 'wp_ada_compliance_settings_link_titles_font_awesome', 'wp_ada_compliance', 'wp_ada_compliance_filters');
	
// user defined font awesome conversions
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_font_awesome_conversion_text', array('type' => 'string','sanitize_callback' => 'wp_ada_compliance_validate_alnum_punct_in_text_area'));
add_settings_field('wp_ada_compliance_font_awesome_conversion_text', '', 'wp_ada_compliance_settings_font_awesome_conversion_text', 'wp_ada_compliance', 'wp_ada_compliance_filters');
	
	
// hide font awesome icons
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_hide_font_awesome_icons', array('type' => 'string','sanitize_callback' => 'wp_ada_compliance_validate_false_default_true'));
add_settings_field('wp_ada_compliance_hide_font_awesome_icons', '', 'wp_ada_compliance_settings_hide_font_awesome_icons', 'wp_ada_compliance', 'wp_ada_compliance_filters');	
	
// strip auto play from video, audio and object tags
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_strip_autoplay', array('type' => 'string','sanitize_callback' => 'wp_ada_compliance_validate_false_default_true'));
add_settings_field('wp_ada_compliance_edit_strip_autoplay', '', 'wp_ada_compliance_settings_strip_autoplay', 'wp_ada_compliance', 'wp_ada_compliance_filters');	
	
// add aria-label to read more links 
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_modify_readmore_links', array('type' => 'string','sanitize_callback' => 'wp_ada_compliance_validate_false_default_true'));
add_settings_field('wp_ada_compliance_modify_readmore_links', '', 'wp_ada_compliance_settings_modify_readmore_links', 'wp_ada_compliance', 'wp_ada_compliance_filters');	
	
// define read more link text
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_read_more_link_text', array('type' => 'string','sanitize_callback' => 'wp_ada_compliance_validate_read_more_text'));
add_settings_field('wp_ada_compliance_read_more_link_text', '', 'wp_ada_compliance_settings_read_more_link_text', 'wp_ada_compliance', 'wp_ada_compliance_filters');	
	
// add role=presentation to tables with role-presentation class
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_presentation_tables', array('type' => 'string','sanitize_callback' => 'wp_ada_compliance_validate_false_default_true'));
add_settings_field('wp_ada_compliance_presentation_tables', '', 'wp_ada_compliance_settings_presentation_tables', 'wp_ada_compliance', 'wp_ada_compliance_filters');

	// remove invalid alt text from images
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_remove_invalid_img_alt_text', array('type' => 'string','sanitize_callback' => 'wp_ada_compliance_validate_false_default_true'));
add_settings_field('wp_ada_compliance_remove_invalid_img_alt_text', '', 'wp_ada_compliance_settings_remove_invalid_img_alt_text', 'wp_ada_compliance', 'wp_ada_compliance_filters');
	
// remove links from images that are linked to self
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_remove_images_linked_to_self', array('type' => 'string','sanitize_callback' => 'wp_ada_compliance_validate_false_default_true'));
add_settings_field('wp_ada_compliance_remove_images_linked_to_self', '', 'wp_ada_compliance_settings_remove_images_linked_to_self', 'wp_ada_compliance', 'wp_ada_compliance_filters');	
	
// strip html from the title tag
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_strip_html_from_title', array('type' => 'string','sanitize_callback' => 'wp_ada_compliance_validate_true_default_false'));
add_settings_field('wp_ada_compliance_strip_html_from_title', '', 'wp_ada_compliance_settings_strip_html_from_title', 'wp_ada_compliance', 'wp_ada_compliance_filters');	
	
// allowed html in the title tag
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_strip_html_allowed_tags', array('type' => 'string','sanitize_callback' => 'wp_ada_compliance_validate_html_allowed_tags'));
add_settings_field('wp_ada_compliance_strip_html_allowed_tags', '', 'wp_ada_compliance_settings_strip_html_allowed_tags', 'wp_ada_compliance', 'wp_ada_compliance_filters');	
	
// add lang attribute to html tag
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_add_lang_attribute', array('type' => 'string','sanitize_callback' => 'wp_ada_compliance_validate_false_default_true'));
add_settings_field('wp_ada_compliance_add_lang_attribute', '', 'wp_ada_compliance_settings_add_lang_attribute', 'wp_ada_compliance', 'wp_ada_compliance_filters');	
	
// add skip link
//register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_skip_link_id', array('type' => 'string','sanitize_callback' => 'wp_ada_compliance_validate_skip_link_id'));
//add_settings_field('wp_ada_compliance_skip_link_id', '', 'wp_ada_compliance_settings_skip_link_id', 'wp_ada_compliance', 'wp_ada_compliance_filters');	
    
// add additional skip link
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_skip_links', array('type' => 'array','sanitize_callback' => 'wp_ada_compliance_validate_alnum_punct_in_array'));
add_settings_field('wp_ada_compliance_skip_links', '', 'wp_ada_compliance_settings_skip_links', 'wp_ada_compliance', 'wp_ada_compliance_filters');
    

    // add landmarks
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_landmarks', array('type' => 'array','sanitize_callback' => 'wp_ada_compliance_validate_alnum_punct_in_array'));
add_settings_field('wp_ada_compliance_landmarks', '', 'wp_ada_compliance_settings_landmarks', 'wp_ada_compliance', 'wp_ada_compliance_filters');
    
    // add landmarks
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_add_wpform_labels', array('type' => 'array','sanitize_callback' => 'wp_ada_compliance_validate_false_default_true'));
add_settings_field('wp_ada_compliance_add_wpform_labels', '', 'wp_ada_compliance_setting_add_wpform_labels', 'wp_ada_compliance', 'wp_ada_compliance_filters');
	
// correct emulating links
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_correct_emulating_links', array('type' => 'string','sanitize_callback' => 'wp_ada_compliance_validate_false_default_true'));
add_settings_field('wp_ada_compliance_correct_emulating_links', '', 'wp_ada_compliance_settings_correct_emulating_links', 'wp_ada_compliance', 'wp_ada_compliance_filters');
    
// correct event handlers without keyboard support
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_correct_event_handlers', array('type' => 'string','sanitize_callback' => 'wp_ada_compliance_validate_false_default_true'));
add_settings_field('wp_ada_compliance_correct_event_handlers', '', 'wp_ada_compliance_settings_correct_event_handlers', 'wp_ada_compliance', 'wp_ada_compliance_filters');
	
// overside css to correct issues
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_focus_styles', array('type' => 'string','sanitize_callback' => 'wp_ada_compliance_validate_false_default_true'));
add_settings_field('wp_ada_compliance_focus_styles', '', 'wp_ada_compliance_settings_focus_styles', 'wp_ada_compliance', 'wp_ada_compliance_filters');
	
// allow user to choose outline color
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_outline_color', array('type' => 'string','sanitize_callback' => 'wp_ada_compliance_validate_outline_color')); 
add_settings_field('wp_ada_compliance_outline_color', '', 'wp_ada_compliance_settings_outline_color', 'wp_ada_compliance', 'wp_ada_compliance_filters');
	
// include outline on links when hovering over them
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_include_hover', array('type' => 'string','sanitize_callback' => 'wp_ada_compliance_validate_true_default_false'));
add_settings_field('wp_ada_compliance_include_hover', '', 'wp_ada_compliance_settings_include_hover', 'wp_ada_compliance', 'wp_ada_compliance_filters');
    
    
    // correct inline styles with focus removed
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_correct_visual_focus', array('type' => 'string','sanitize_callback' => 'wp_ada_compliance_validate_false_default_true'));
add_settings_field('wp_ada_compliance_correct_visual_focus', '', 'wp_ada_compliance_settings_correct_visual_focus', 'wp_ada_compliance', 'wp_ada_compliance_filters');
    
	
       // correct broken page anchors
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_correct_anchor_links', array('type' => 'string','sanitize_callback' => 'wp_ada_compliance_validate_false_default_true'));
add_settings_field('wp_ada_compliance_correct_anchor_links', '', 'wp_ada_compliance_settings_correct_anchor_links', 'wp_ada_compliance', 'wp_ada_compliance_filters'); 
	
       // correct elementor toggles
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_correct_elementor_toggles', array('type' => 'string','sanitize_callback' => 'wp_ada_compliance_validate_false_default_true'));
add_settings_field('wp_ada_compliance_correct_elementor_toggles', '', 'wp_ada_compliance_settings_correct_elementor_toggles', 'wp_ada_compliance', 'wp_ada_compliance_filters'); 

	
    // correct elementor icon and image widgets
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_correct_elementor_icon_and_img_widgets', array('type' => 'string','sanitize_callback' => 'wp_ada_compliance_validate_false_default_true'));
add_settings_field('wp_ada_compliance_correct_elementor_icon_and_img_widgets', '', 'wp_ada_compliance_settings_correct_elementor_icon_and_img_widgets', 'wp_ada_compliance', 'wp_ada_compliance_filters');  
    
    // correct elementor posts widget
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_correct_elementor_post_widget', array('type' => 'string','sanitize_callback' => 'wp_ada_compliance_validate_false_default_true'));
add_settings_field('wp_ada_compliance_correct_elementor_post_widget', '', 'wp_ada_compliance_settings_correct_elementor_post_widget', 'wp_ada_compliance', 'wp_ada_compliance_filters');     
    
    
    // correct elementor table of contents widget
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_correct_elementor_TOC', array('type' => 'string','sanitize_callback' => 'wp_ada_compliance_validate_false_default_true'));
add_settings_field('wp_ada_compliance_correct_elementor_TOC', '', 'wp_ada_compliance_settings_correct_elementor_TOC', 'wp_ada_compliance', 'wp_ada_compliance_filters');   
    
    // stop image carousels
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_stop_autoplay_image_carousel', array('type' => 'string','sanitize_callback' => 'wp_ada_compliance_validate_true_default_false'));
add_settings_field('wp_ada_compliance_stop_autoplay_image_carousel', '', 'wp_ada_compliance_settings_stop_autoplay_image_carousel', 'wp_ada_compliance', 'wp_ada_compliance_filters');       
   	
    
        // correct vfb labels
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_correct_vfb_labels', array('type' => 'string','sanitize_callback' => 'wp_ada_compliance_validate_false_default_true'));
add_settings_field('wp_ada_compliance_correct_vfb_labels', '', 'wp_ada_compliance_settings_correct_vfb_labels', 'wp_ada_compliance', 'wp_ada_compliance_filters');  
    
    
    // correct gravity forms issues
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_correct_gravity_forms_issues', array('type' => 'string','sanitize_callback' => 'wp_ada_compliance_validate_false_default_true'));
add_settings_field('wp_ada_compliance_correct_gravity_forms_issues', '', 'wp_ada_compliance_settings_correct_gravity_forms_issues', 'wp_ada_compliance', 'wp_ada_compliance_filters');  
        
    
    
/***********************************************************************
DEFINE AUTO SCAN & NOTIFICATION SETTINGS
**************************************************************************/	
add_settings_section('wp_ada_compliance_notify', __('Scan & Notification', 'wp-ada-compliance'), 'wp_ada_compliance_notifications', 'wp_ada_compliance');	
    
// scan with wpget files
//register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_deep_scan',array('type' => 'string','sanitize_callback' =>'wp_ada_compliance_validate_deep_scan'));
//add_settings_field('wp_ada_compliance_deep_scan', '', 'wp_ada_compliance_settings_deep_scan', 'wp_ada_compliance', 'wp_ada_compliance_notify');	    

// should deep scan be run on editor screen to clear custom filed errors and such
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_deep_scan_on_editor',array('type' => 'string','sanitize_callback' =>'wp_ada_compliance_validate_full_deep_scan_on_editor'));
add_settings_field('wp_ada_compliance_full_deep_scan_on_editor', '', 'wp_ada_compliance_settings_deep_scan_on_editor', 'wp_ada_compliance', 'wp_ada_compliance_notify');		
    
	// filesize limit
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_file_size_limit',array('type' => 'string','sanitize_callback' =>'wp_ada_compliance_validate_number'));
add_settings_field('wp_ada_compliance_file_size_limit', '', 'wp_ada_compliance_settings_file_size_limit', 'wp_ada_compliance', 'wp_ada_compliance_notify');	    
	
	// how many posts to scan during full scans
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_full_scan_post_count',array('type' => 'string','sanitize_callback' =>'wp_ada_compliance_validate_number'));
add_settings_field('wp_ada_compliance_full_scan_post_count', '', 'wp_ada_compliance_settings_full_scan_post_count', 'wp_ada_compliance', 'wp_ada_compliance_notify');	
	
// choose auto scan options
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_auto_scan_options',array('type' => 'string','sanitize_callback' =>'wp_ada_compliance_validate_auto_scan_options'));
add_settings_field('wp_ada_compliance_auto_scan_options', '', 'wp_ada_compliance_settings_auto_scan_options', 'wp_ada_compliance', 'wp_ada_compliance_notify');		
	
// how many posts to scan during cron
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_cron_scan_post_count',array('type' => 'string','sanitize_callback' =>'wp_ada_compliance_validate_number'));
add_settings_field('wp_ada_compliance_cron_scan_post_count', '', 'wp_ada_compliance_settings_cron_scan_post_count', 'wp_ada_compliance', 'wp_ada_compliance_notify');		

// notification email fields
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_notification_email',array('type' => 'string','sanitize_callback' =>'wp_ada_compliance_validate_notification_email'));
add_settings_field('wp_ada_compliance_notification_email', '', 'wp_ada_compliance_settings_notification_email', 'wp_ada_compliance', 'wp_ada_compliance_notify');
    
// send reminders when issues exists but have not been corrected
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_notification_send_reminders', array('type' => 'string','sanitize_callback' => 'wp_ada_compliance_validate_false_default_true'));
add_settings_field('wp_ada_compliance_notification_send_reminders', '', 'wp_ada_compliance_settings_notification_send_reminders', 'wp_ada_compliance', 'wp_ada_compliance_notify');	    
	
// notification frequency fields
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_notification_frequency', array('type' => 'string','sanitize_callback' => 'wp_ada_compliance_validate_notification_frequency'));
add_settings_field('wp_ada_compliance_notification_frequency', '', 'wp_ada_compliance_settings_notification_frequency', 'wp_ada_compliance', 'wp_ada_compliance_notify');
    
    
// display enable secure sites setting
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_enable_secure_site_scans',array('type' => 'string','sanitize_callback' =>'wp_ada_compliance_validate_true_default_false'));
add_settings_field('wp_ada_compliance_enable_secure_site_scans', '', 'wp_ada_compliance_settings_enable_secure_site_scans_field', 'wp_ada_compliance', 'wp_ada_compliance_notify'); 
    
    // username option
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_setting_password_protect_username',array('type' => 'string','sanitize_callback' =>'wp_ada_compliance_validate_password_field'));
add_settings_field('wp_ada_compliance_setting_password_protect_username', '', 'wp_ada_compliance_setting_password_protect_username_field', 'wp_ada_compliance', 'wp_ada_compliance_notify');  
    
    //password option
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_setting_password_protect_password',array('type' => 'string','sanitize_callback' =>'wp_ada_compliance_validate_password_field'));
add_settings_field('wp_ada_compliance_setting_password_protect_password', '', 'wp_ada_compliance_setting_password_protect_password_field', 'wp_ada_compliance', 'wp_ada_compliance_notify');        
	
/***********************************************************************
DEFINE IGNORE SETTINGS
**************************************************************************/	
add_settings_section('wp_ada_compliance_posts_to_ignore', __('Ignored Content', 'wp-ada-compliance'), 'wp_ada_compliance_ignored_files_text', 'wp_ada_compliance');	
	
// ignored file section
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_posts_to_ignore',array('type' => 'array','sanitize_callback' =>'wp_ada_compliance_validate_posts_to_ignore'));
add_settings_field('wp_ada_compliance_posts_to_ignore', '', 'wp_ada_compliance_settings_ignored_files', 'wp_ada_compliance', 'wp_ada_compliance_posts_to_ignore');
	

/***********************************************************************
DEFINE SCAN RULE SETTINGS
**************************************************************************/	
add_settings_section('wp_ada_compliance_scan_rules', __('Rules', 'wp-ada-compliance'), 'wp_ada_compliance_scan_rule_text', 'wp_ada_compliance');
    
// scan rules section
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_scan_rules',array('type' => 'array','sanitize_callback' =>'wp_ada_compliance_validate_scan_rules'));
add_settings_field('wp_ada_compliance_scan_rules', '', 'wp_ada_compliance_settings_scan_rule', 'wp_ada_compliance', 'wp_ada_compliance_scan_rules');

    
/***********************************************************************
DEFINE WIDGET SETTINGS
**************************************************************************/
add_settings_section('wp_ada_compliance_widget', __('Widget', 'wp-ada-compliance'), 'wp_ada_compliance_widget_text', 'wp_ada_compliance');   
    
    // use the accessibility widget
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_use_accessibility_widget', array('type' => 'string','sanitize_callback' => 'wp_ada_compliance_validate_widget_options'));
add_settings_field('wp_ada_compliance_use_accessibility_widget', '', 'wp_ada_compliance_settings_use_accessibility_widget', 'wp_ada_compliance', 'wp_ada_compliance_widget');   
    
// use shortcode
    register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_use_accessibility_widget_shortcode', array('type' => 'string','sanitize_callback' => 'wp_ada_compliance_validate_true_default_false'));
add_settings_field('wp_ada_compliance_use_accessibility_widget_shortcode', '', 'wp_ada_compliance_settings_use_accessibility_widget_shortcode', 'wp_ada_compliance', 'wp_ada_compliance_widget');   
	
    
// link to report form for web accessibility issues
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_use_accessibility_widget_form', array('type' => 'string','sanitize_callback' => 'wp_ada_compliance_validate_url'));
add_settings_field('wp_ada_compliance_use_accessibility_widget_form', '', 'wp_ada_compliance_settings_use_accessibility_widget_form', 'wp_ada_compliance', 'wp_ada_compliance_widget'); 
    
// link to statement on commitment to web accessibility
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_use_accessibility_widget_statement', array('type' => 'string','sanitize_callback' => 'wp_ada_compliance_validate_accessibility_widget_statement'));
add_settings_field('wp_ada_compliance_use_accessibility_widget_statement', '', 'wp_ada_compliance_settings_use_accessibility_widget_statement', 'wp_ada_compliance', 'wp_ada_compliance_widget');   
	
//use logo
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_accessibility_widget_use_logo', array('type' => 'string','sanitize_callback' => 'wp_ada_compliance_validate_true_default_false'));
add_settings_field('wp_ada_compliance_accessibility_widget_use_logo', '', 'wp_ada_compliance_setting_accessibility_widget_use_logo', 'wp_ada_compliance', 'wp_ada_compliance_widget');   
    
 // placement
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_accessibility_widget_placement', array('type' => 'string','sanitize_callback' => 'wp_ada_compliance_validate_widget_placement'));
add_settings_field('wp_ada_compliance_accessibility_widget_placement', '', 'wp_ada_compliance_setting_accessibility_widget_placement', 'wp_ada_compliance', 'wp_ada_compliance_widget');   
    
// primary color
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_accessibility_widget_primary_color', array('type' => 'string','sanitize_callback' => 'wp_ada_compliance_validate_hex_color'));
add_settings_field('wp_ada_compliance_accessibility_widget_primary_color', '', 'wp_ada_compliance_setting_accessibility_widget_primary_color', 'wp_ada_compliance', 'wp_ada_compliance_widget'); 
    
  
	
// secondary color
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_accessibility_widget_secondary_color', array('type' => 'string','sanitize_callback' => 'wp_ada_compliance_validate_hex_color'));
//add_settings_field('wp_ada_compliance_accessibility_widget_secondary_color', '', 'wp_ada_compliance_setting_accessibility_widget_secondary_color', 'wp_ada_compliance', 'wp_ada_compliance_widget'); 	
  
	
/***********************************************************************
DEFINE MISC SETTINGS
**************************************************************************/	
add_settings_section('wp_ada_compliance_main', __('Miscellaneous', 'wp-ada-compliance'), 'wp_ada_compliance_text', 'wp_ada_compliance');  
	

    // display logo setting
   
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_report_logo',array('type' => 'string','sanitize_callback' =>'wp_ada_compliance_validate_number_default_empty'));
add_settings_field('wp_ada_compliance_report_logo', '', 'wp_ada_compliance_settings_report_logo_field', 'wp_ada_compliance', 'wp_ada_compliance_main');    
	
  //white label link
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_report_logo_url',array('type' => 'string','sanitize_callback' =>'wp_ada_compliance_validate_url'));
//add_settings_field('wp_ada_compliance_report_logo_url', '', 'wp_ada_compliance_settings_report_logo_url_field', 'wp_ada_compliance', 'wp_ada_compliance_main');   
     

    // number of errors per page to display on error report
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_errors_per_page',array('type' => 'string','sanitize_callback' =>'wp_ada_compliance_validate_number'));
add_settings_field('wp_ada_compliance_errors_per_page', '', 'wp_ada_compliance_settings_errors_per_page', 'wp_ada_compliance', 'wp_ada_compliance_main');	
    
    // include error summary on reports
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_report_summary', array('type' => 'string','sanitize_callback' => 'wp_ada_compliance_validate_false_default_true'));
add_settings_field('wp_ada_compliance_report_summary', '', 'wp_ada_compliance_settings_report_summary', 'wp_ada_compliance', 'wp_ada_compliance_main');
    	

    // include url column on full report
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_report_include_link_column', array('type' => 'string','sanitize_callback' => 'wp_ada_compliance_validate_true_default_false'));
add_settings_field('wp_ada_compliance_report_include_link_column', '', 'wp_ada_compliance_settings_report_include_link_column', 'wp_ada_compliance', 'wp_ada_compliance_main');
    
// options to convert title tags to aria-label and add title option to linking tool
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_link_title_tools', array('type' => 'string','sanitize_callback' => 'wp_ada_compliance_validate_false_default_true'));
add_settings_field('wp_ada_compliance_link_title_tools', '', 'wp_ada_compliance_settings_link_title_tools_function', 'wp_ada_compliance', 'wp_ada_compliance_main');    

// default linking behavior
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_remove_linking_images', array('type' => 'string','sanitize_callback' => 'wp_ada_compliance_validate_false_default_true'));
add_settings_field('wp_ada_compliance_remove_linking_images', '', 'wp_ada_compliance_settings_remove_linking_images', 'wp_ada_compliance', 'wp_ada_compliance_main');	
	
// font size 
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_fontsize_selector',array('type' => 'string','sanitize_callback' =>'wp_ada_compliance_validate_starting_font_size_selector'));
add_settings_field('wp_ada_compliance_fontsize_selector', '', 'wp_ada_compliance_settings_fontsize', 'wp_ada_compliance', 'wp_ada_compliance_main');
	
	// attachment title check
/*register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_attachmenttitles',array('type' => 'string','sanitize_callback' =>'wp_ada_compliance_validate_true_default_false'));
add_settings_field('wp_ada_compliance_attachmenttitles', '', 'wp_ada_compliance_settings_attachmenttitles', 'wp_ada_compliance', 'wp_ada_compliance_main');	*/

	// settings authorized user
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_settingsusers',array('type' => 'string','sanitize_callback' =>'wp_ada_compliance_validate_settingsusers'));
add_settings_field('wp_ada_compliance_settingsusers', '', 'wp_ada_compliance_settings_settingsusers', 'wp_ada_compliance', 'wp_ada_compliance_main');	
	
	// website language code
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_language_code',array('type' => 'string','sanitize_callback' =>'wp_ada_compliance_validate_language_code'));
add_settings_field('wp_ada_compliance_language_code', '', 'wp_ada_compliance_settings_language_code', 'wp_ada_compliance', 'wp_ada_compliance_main');	
	
	// assumed background color
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_background_color',array('type' => 'string','sanitize_callback' =>'wp_ada_compliance_validate_background_color'));
add_settings_field('wp_ada_compliance_background_color', '', 'wp_ada_compliance_settings_background_color', 'wp_ada_compliance', 'wp_ada_compliance_main');	
    
	// assumed foreground color
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_foreground_color',array('type' => 'string','sanitize_callback' =>'wp_ada_compliance_validate_foreground_color'));
add_settings_field('wp_ada_compliance_foreground_color', '', 'wp_ada_compliance_settings_foreground_color', 'wp_ada_compliance', 'wp_ada_compliance_main');	    
	
// modify tinymce colors
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_tinymce_color_pallet', array('type' => 'string','sanitize_callback' => 'wp_ada_compliance_validate_false_default_true'));
add_settings_field('wp_ada_compliance_tinymce_color_pallet', '', 'wp_ada_compliance_settings_tinymce_color_pallet', 'wp_ada_compliance', 'wp_ada_compliance_main');		
	
	// starting heading in page content
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_starting_H_level',array('type' => 'string','sanitize_callback' =>'wp_ada_compliance_validate_starting_H_level'));
add_settings_field('wp_ada_compliance_starting_H_level', '', 'wp_ada_compliance_settings_starting_H_level', 'wp_ada_compliance', 'wp_ada_compliance_main');		
	
	// remove justify option from tinymce
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_removejustify', array('type' => 'string','sanitize_callback' => 'wp_ada_compliance_validate_false_default_true'));
add_settings_field('wp_ada_compliance_removejustify', '', 'wp_ada_compliance_settings_removejustify', 'wp_ada_compliance', 'wp_ada_compliance_main');	
	
// enable wave evaluation tools
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_enablewave',array('type' => 'string','sanitize_callback' =>'wp_ada_compliance_validate_false_default_true'));
add_settings_field('wp_ada_compliance_enablewave', '', 'wp_ada_compliance_settings_enablewave', 'wp_ada_compliance', 'wp_ada_compliance_main');
	
	// retain settings when plugin is deleted
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_retain_settings',array('type' => 'string','sanitize_callback' =>'wp_ada_compliance_validate_true_default_false'));
add_settings_field('wp_ada_compliance_retain_settings', '', 'wp_ada_compliance_settings_retain_settings', 'wp_ada_compliance', 'wp_ada_compliance_main');	
    
	// disable font awesome on public pages
register_setting( 'wp_ada_compliance_options', 'wp_ada_compliance_disable_fontawesome_public',array('type' => 'string','sanitize_callback' =>'wp_ada_compliance_validate_true_default_false'));
add_settings_field('wp_ada_compliance_disable_fontawesome_public', '', 'wp_ada_compliance_disable_fontawesome_public_settings', 'wp_ada_compliance', 'wp_ada_compliance_main');	
	    
	
}

// instructions for notification settings goes here
function  wp_ada_compliance_notifications() {
echo '<p class="ada_compliance_settings_text">';
_e('The settings in this section may be adjusted to reduce resource usage on your web server. Cron scans use less resources and are a convenient way to complete the scan process.  
', 'wp-ada-compliance');	
echo '</p>';

}	

// instructions for misc settings goes here
function  wp_ada_compliance_text() {
    echo '<p class="ada_compliance_settings_text wp-ada-important">';
_e('The default settings will work for most websites, however settings marked with a red bar on the left should be reviewed and set according to your website requirements.', 'wp-ada-compliance');	
echo '</p>';
}	

// ignored files section text goes here
function  wp_ada_compliance_ignored_files_text() {


}

// scan rule section text goes here
function  wp_ada_compliance_scan_rule_text() {


}	


// widget section text goes here
function  wp_ada_compliance_widget_text() {
echo '<div class="ada_compliance_widget_text wp-ada-important">';
echo '<p>';
_e('Use of the accessibility widget and display of the included compliance seal requires a commitment by the website owner to comply with WCAG 2.1 AA Web Accessibility standards. Committing to accessibility means you pledge to correct or evaluate the validity of all issues found by the software, will complete the provided manual checks and will implement a web accessibility policy to ensure the website remains free from errors. By using the software you have agreed to our terms of use and understand that we do not warrant that your website will be free from web accessibility issues while using our software. The displayed badge does not indicate that your website is free from errors but is intended only to provide website users with the confidence that you are dedicated to compliance and will do your best to ensure your website is accessible to everyone.', 'wp-ada-compliance'); 
echo '</p>';
echo '</div>';

}    

// filter section text goes here
function  wp_ada_compliance_filtertext() {
echo '<div class="ada_compliance_settings_text">';    
echo '<p>';
_e('Choose options for automatically correcting issues found on your website.', 'wp-ada-compliance');	
echo '</p>';	
echo '<p class="wp-ada-important">';
_e('The default settings will work for most websites, however settings marked with a red bar on the left should be reviewed and set according to your website requirements.', 'wp-ada-compliance');	
echo '</p></div>';
}	

// enable secure site scans
function wp_ada_compliance_settings_enable_secure_site_scans_field(){
$setting = get_option('wp_ada_compliance_enable_secure_site_scans','false');
echo '<h2>'.__('Password Protected Website Settings', 'wp-ada-compliance');
echo '</h2>';    
echo '<fieldset>';
    
echo '<legend>';
    echo '<p>';
   _e('Websites protected by Apache Basic Authentication or a Wordpress login are now supported. ', 'wp-ada-compliance');   
echo '<a href="https://www.alumnionlineservices.com/faq/can-i-scan-password-protected-websites-using-the-wp-ada-compliance-plugin/">';
_e('Learn more about these options', 'wp-ada-compliance');   
echo '</a>.';
      echo '</p>';
_e('Enable support for websites that require users to be logged in to access website content. (htaccess password protected directories and Wordpress Login are both supported)', 'wp-ada-compliance');    

echo '</legend>';
echo '<br />';
	
echo '<input type="radio" name="wp_ada_compliance_enable_secure_site_scans" id="wp_ada_compliance_enable_secure_site_scans_true" value="true" ';
if($setting == 'true') echo ' checked';
echo '><label for="wp_ada_compliance_enable_secure_site_scans_true">';
_e('Yes', 'wp-ada-compliance');
echo '</label> ';	
	
echo '<input type="radio" name="wp_ada_compliance_enable_secure_site_scans" id="wp_ada_compliance_enable_secure_site_scans_false" value="false" ';
if($setting == 'false') echo ' checked';
echo '><label for="wp_ada_compliance_enable_secure_site_scans_false">';
_e('No', 'wp-ada-compliance');
echo '</label> ';	
	
echo '</fieldset>';
}

/// password protected user username
function  wp_ada_compliance_setting_password_protect_username_field() {

$wp_ada_compliance_setting_password_protect_username = get_option('wp_ada_compliance_setting_password_protect_username','');
        $wp_ada_compliance_setting_password_protect_username = wp_ada_compliance_encrypt_decrypt('decrypt', $wp_ada_compliance_setting_password_protect_username);

echo '<fieldset>';
echo '<legend>';	
_e('Websites secured using Apache Basic Authentication or better known as Password Protected Directories require authentication during scans. Enter the username and password required to access the website in the fields provided below. ', 'wp-ada-compliance');
echo '</legend>';    
    
echo '<p>';
echo '<label for="wp_ada_compliance_setting_password_protect_username">';
_e('Username: ', 'wp-ada-compliance');	
echo '</label><br />';
echo '<input type="text" size="25" autocomplete="off" name="wp_ada_compliance_setting_password_protect_username" id="wp_ada_compliance_setting_password_protect_username" value="'.esc_attr($wp_ada_compliance_setting_password_protect_username).'" />';
echo '</p>'; 
    
    $wp_ada_compliance_setting_password_protect_password = get_option('wp_ada_compliance_setting_password_protect_password','');
    $wp_ada_compliance_setting_password_protect_password = wp_ada_compliance_encrypt_decrypt('decrypt', $wp_ada_compliance_setting_password_protect_password);
echo '<p>';
echo '<label for="wp_ada_compliance_setting_password_protect_password">';
_e('Password: ', 'wp-ada-compliance');	
echo '</label><br />';
echo '<input type="password" size="25" autocomplete="off" name="wp_ada_compliance_setting_password_protect_password" id="wp_ada_compliance_setting_password_protect_password" value="'.esc_attr($wp_ada_compliance_setting_password_protect_password).'" />';
echo '</p>'; 
    
    echo '</fieldset>';
}

/// password protected user password
function  wp_ada_compliance_setting_password_protect_password_field() {

  
}

// use of widget
function  wp_ada_compliance_settings_correct_visual_focus() {

$correct_visual_focus = get_option('wp_ada_compliance_correct_visual_focus','true');

echo '<fieldset class=" wp-ada-important">';
echo '<legend>';	
_e('Remove inline styles that obscure or remove visual focus from focusable elements (a, button, etc...)', 'wp-ada-compliance');
echo '</legend>';
echo '<br />';
	
echo '<input type="radio" name="wp_ada_compliance_correct_visual_focus" id="wp_ada_compliance_correct_visual_focus_true" value="true" ';
if($correct_visual_focus == 'true') echo ' checked';
echo '><label for="wp_ada_compliance_correct_visual_focus_true">';
_e('Yes', 'wp-ada-compliance');
echo '</label> ';	
	
echo '<input type="radio" name="wp_ada_compliance_correct_visual_focus" id="wp_ada_compliance_correct_visual_focus_false" value="false" ';
if($correct_visual_focus == 'false') echo ' checked';
echo '><label for="wp_ada_compliance_correct_visual_focus_false">';
_e('No', 'wp-ada-compliance');
echo '</label> ';	
	
echo '</fieldset>';

}

// correct visual focus removed
function  wp_ada_compliance_settings_use_accessibility_widget() {

$use_accessibility_widget = get_option('wp_ada_compliance_use_accessibility_widget','false');

echo '<fieldset class=" wp-ada-important">';
echo '<legend>';	
_e('Display the accessibility widget and toolbar on your public facing website. Note: the widget requires the use of cookies being set in a users browser. Refer to the user guide for a list of cookies that may be present.', 'wp-ada-compliance');
echo '</legend>';
echo '<br />';
	
echo '<input type="radio" name="wp_ada_compliance_use_accessibility_widget" id="wp_ada_compliance_use_accessibility_widget_true" value="true" ';
if($use_accessibility_widget == 'true') echo ' checked';
echo '><label for="wp_ada_compliance_use_accessibility_widget_true">';
_e('Display the accessibility widget, tools and compliance seal', 'wp-ada-compliance');
echo '</label> ';
    echo '<br />';
echo '<input type="radio" name="wp_ada_compliance_use_accessibility_widget" id="wp_ada_compliance_use_accessibility_widget_nobadge" value="nobadge" ';
if($use_accessibility_widget == 'nobadge') echo ' checked';
echo '><label for="wp_ada_compliance_use_accessibility_widget_nobadge">';
_e('Display the accessibility widget and tools (compliance seal will not be displayed)', 'wp-ada-compliance');
echo '</label> ';	    
    echo '<br />';
echo '<input type="radio" name="wp_ada_compliance_use_accessibility_widget" id="wp_ada_compliance_use_accessibility_widget_badgeonly" value="badgeonly" ';
if($use_accessibility_widget == 'badgeonly') echo ' checked';
echo '><label for="wp_ada_compliance_use_accessibility_widget_badgeonly">';
_e('Display the accessibility widget and compliance seal (users will click on a link to view the accessibility toolbar)', 'wp-ada-compliance');
echo '</label> ';	    
	echo '<br />';
echo '<input type="radio" name="wp_ada_compliance_use_accessibility_widget" id="wp_ada_compliance_use_accessibility_widget_false" value="false" ';
if($use_accessibility_widget == 'false') echo ' checked';
echo '><label for="wp_ada_compliance_use_accessibility_widget_false">';
_e('Disable the acessibility widget', 'wp-ada-compliance');
echo '</label> ';	
	
echo '</fieldset>';

}


// use the shortcode
function  wp_ada_compliance_settings_use_accessibility_widget_shortcode() {

$use_accessibility_shortcode = get_option('wp_ada_compliance_use_accessibility_widget_shortcode','false');

echo '<div><p>';
	_e('The widget toolbar may also be implemented using a shortcode. When enabled below and the [wp-ada-access-tools] shortcode is placed on your website a button will be displayed. When the button is clicked the accessibility options toolbar will be displayed at the bottom of the screen. ', 'wp-ada-compliance');
	echo '</p>';
	echo '<p>';
	echo 'example: [wp-ada-access-tools icon="fa-universal-access" class="" text="" alttext="'.__('Show Accessibility Tool Bar', 'wp-ada-compliance').'"]';
	echo '</p>';
		echo '<p>';
	echo '<span class="adaBoldText">';
	_e('Available Attributes:', 'wp-ada-compliance');
	echo '</span>';
	echo '<br />';
	echo '<span class="adaBoldText">';
	_e('icon: ', 'wp-ada-compliance');
	echo '</span>';
	_e('set to either an image url or font awesome 4 icon. (default: fa-universal-access)', 'wp-ada-compliance');
	echo '<br />';
	echo '<span class="adaBoldText">';
	_e('class: ', 'wp-ada-compliance');
	echo '</span>';
	_e('to include a custom class for designing the button. (default: wp-ada-compliance-accessibility-widget-showtools)', 'wp-ada-compliance');
	echo '<br />';
	echo '<span class="adaBoldText">';
	_e('text: ', 'wp-ada-compliance');
	echo '</span>';
	_e('displays visbile text after the icon. (default: none)', 'wp-ada-compliance');
	echo '<br />';
	echo '<span class="adaBoldText">';
	_e('alttext: ', 'wp-ada-compliance');
	echo '</span>';
	_e('included in the aria-label for the button link. (default: Show Accessibility Tool Bar)', 'wp-ada-compliance');
	echo '</p>';
	echo '</div>';
    
echo '<fieldset class="">';
echo '<legend>';	
_e('Enable the shortcode for use on your public facing website. Note: requires the use of cookies being set in a users browser. Refer to the user guide for a list of cookies that may be present.', 'wp-ada-compliance');

echo '<br />';
	
echo '<input type="radio" name="wp_ada_compliance_use_accessibility_widget_shortcode" id="wp_ada_compliance_use_accessibility_widget_shortcode_true" value="true" ';
if($use_accessibility_shortcode== 'true') echo ' checked';
echo '><label for="wp_ada_compliance_use_accessibility_widget_shortcode_true">';
_e('Yes', 'wp-ada-compliance');
echo '</label> ';	
	
echo '<input type="radio" name="wp_ada_compliance_use_accessibility_widget_shortcode" id="wp_ada_compliance_use_accessibility_widget_shortcode_false" value="false" ';
if($use_accessibility_shortcode == 'false') echo ' checked';
echo '><label for="wp_ada_compliance_use_accessibility_widget_shortcode_false">';
_e('No', 'wp-ada-compliance');
echo '</label> ';	
	
echo '</fieldset>';
	

}

// use of cutom logo 
function  wp_ada_compliance_setting_accessibility_widget_use_logo() {

$use_logo = get_option('wp_ada_compliance_accessibility_widget_use_logo','false'); 

echo '<fieldset class=" wp-ada-important">';
echo '<legend>';	
_e('Replace the protected by link in the accessibility widget with a custom logo. Define a logo under the Miscellaneous tab. This option requires a continuously active license. ', 'wp-ada-compliance');
echo '</legend>';
echo '<br />';
	
echo '<input type="radio" name="wp_ada_compliance_accessibility_widget_use_logo" id="wp_ada_compliance_accessibility_widget_use_logo_true" value="true" ';
if($use_logo == 'true') echo ' checked';
echo '><label for="wp_ada_compliance_accessibility_widget_use_logo_true">';
_e('Yes', 'wp-ada-compliance');
echo '</label> ';	
	
echo '<input type="radio" name="wp_ada_compliance_accessibility_widget_use_logo" id="wp_ada_compliance_accessibility_widget_use_logo_false" value="false" ';
if($use_logo == 'false') echo ' checked';
echo '><label for="wp_ada_compliance_accessibility_widget_use_logo_false">';
_e('No', 'wp-ada-compliance');
echo '</label> ';
    
echo '</fieldset>';
    


}

// widget placement 
function  wp_ada_compliance_setting_accessibility_widget_placement() {

$placement = get_option('wp_ada_compliance_accessibility_widget_placement','bottom'); 

echo '<fieldset class=" wp-ada-important">';
echo '<legend>';	
_e('Choose the location of the accessibility widget icon.', 'wp-ada-compliance');
echo '</legend>';
echo '<br />';
	
echo '<input type="radio" name="wp_ada_compliance_accessibility_widget_placement" id="wp_ada_compliance_accessibility_widget_placement_top" value="top" ';
if($placement == 'top') echo ' checked';
echo '><label for="wp_ada_compliance_accessibility_widget_placement_top">';
_e('top right', 'wp-ada-compliance');
echo '</label> <br />';	
	
echo '<input type="radio" name="wp_ada_compliance_accessibility_widget_placement" id="wp_ada_compliance_accessibility_widget_placement_bottom" value="bottom" ';
if($placement == 'bottom') echo ' checked';
echo '><label for="wp_ada_compliance_accessibility_widget_placement_bottom">';
_e('bottom right', 'wp-ada-compliance');
echo '</label> <br />';
    
echo '<input type="radio" name="wp_ada_compliance_accessibility_widget_placement" id="wp_ada_compliance_accessibility_widget_placement_left" value="left" ';
if($placement == 'left') echo ' checked';
echo '><label for="wp_ada_compliance_accessibility_widget_placement_left">';
_e('bottom left', 'wp-ada-compliance');
echo '</label> ';    
    
echo '</fieldset>';
    


}

// widget primary color
function  wp_ada_compliance_setting_accessibility_widget_primary_color() {

$accessibility_widget_primary_color = get_option('wp_ada_compliance_accessibility_widget_primary_color','');		
echo '<fieldset>';
echo '<legend>';
_e('Choose color options for the widget:', 'wp-ada-compliance');
echo '</legend>';
echo '<p>';
_e('The primary color is used for widget header, footer and toolbar backgrounds an button links.', 'wp-ada-compliance');
echo '<br /><label for="wp_ada_compliance_accessibility_widget_primary_color">';
_e('Choose a primary color for the accessibility widget:', 'wp-ada-compliance');	
echo '</label><br />';
echo '<input type="text" size="25" name="wp_ada_compliance_accessibility_widget_primary_color" id="wp_ada_compliance_accessibility_widget_primary_color" value="'.esc_attr($accessibility_widget_primary_color).'" />';
echo '</p>';

// secondary color
$accessibility_widget_secondary_color = get_option('wp_ada_compliance_accessibility_widget_secondary_color','');		
echo '<p>';
_e('The secondary color is used for the widget header, footer and toolbar text.', 'wp-ada-compliance');
echo '<br /><label for="wp_ada_compliance_accessibility_widget_secondary_color">';
_e('Choose a secondary color for the accessibility widget:', 'wp-ada-compliance');	
echo '</label><br />';
echo '<input type="text" size="25" name="wp_ada_compliance_accessibility_widget_secondary_color" id="wp_ada_compliance_accessibility_widget_secondary_color" value="'.esc_attr($accessibility_widget_secondary_color).'" />';
echo '</p>';
echo '</fieldset>';
}

// widget secondary color
function  wp_ada_compliance_setting_accessibility_widget_secondary_color() {
// see field above
return;
	
}

// Field for logo on reports and widget 
function wp_ada_compliance_settings_report_logo_field() {
     echo '<p style="font-weight:bold;">'.__('White Label Options:', 'wp-ada-compliance');
    echo '</p>';
  echo '<p>'.__('White label options allow marketing firms and web designers to add their brand to the plugin when installing it for clients.  While the license remains active you may add a logo to report pages and logo and website url to the accessibility widget displayed on the public website. If a license becomes inactive the logo will no longer be displayed on reports and in the accessibility widget.', 'wp-ada-compliance');

    echo '</p><p>';  
    echo '<label for="wp_ada_compliance_media_manager">';
 _e('Select a logo image to be used on reports and optionally in the widget when displayed on your website. The logo should be no more than 150px tall and wide. For optimal display the suggested size is 150px X 60px on a transparent background.', 'wp-ada-compliance');	
echo '</label></p>';

$image_id  = get_option( 'wp_ada_compliance_report_logo');

if( intval( $image_id ) > 0 ) {
    // Change with the image size you want to use
   $image = wp_get_attachment_image( $image_id, 'full', false, array( 'id' => 'wp-ada-compliance-preview-image' ) );
}
else{
        $image= '<img src="../wp-content/plugins/wp-ada-compliance/res/default-image.jpg" alt="'.__('default image', 'wp-ada-compliance').'" id="wp-ada-compliance-preview-image" >'; 
}
echo $image; ?>
<br />
 <input type="hidden" name="wp_ada_compliance_report_logo" id="wp_ada_compliance_report_logo" value="<?php echo esc_attr( $image_id ); ?>" class="regular-text" />
 <input type='button' class="button-primary" value="<?php _e( 'Select an image', 'wp-ada-compliance' ); ?>" id="wp_ada_compliance_media_manager"/>
 <input type='button' class="button-primary" value="<?php _e( 'Remove', 'wp-ada-compliance' ); ?>" id="wp_ada_compliance_remove_image"/>
<?php 
    
    $report_logo_url = get_option('wp_ada_compliance_report_logo_url','');   
echo '<p>';
echo '<label for="wp_ada_compliance_report_logo_url">';
_e('Include a website url to link the logo to your website:', 'wp-ada-compliance');	
echo '</label><br />';
echo '<input type="text" size="45" name="wp_ada_compliance_report_logo_url" id="wp_ada_compliance_report_logo_url" value="'.esc_url($report_logo_url).'" />';
echo '</p>';
}

// Ajax action to refresh the user image
add_action( 'wp_ajax_wp_ada_compliance_get_image', 'wp_ada_compliance_get_report_image'   );
function wp_ada_compliance_get_report_image() {
    if(isset($_GET['id']) ){
        $image = wp_get_attachment_image( filter_input( INPUT_GET, 'id', FILTER_VALIDATE_INT ), 'full', false, array( 'id' => 'wp-ada-compliance-preview-image' ) );
        $data = array(
            'image'    => $image,
        );
        wp_send_json_success( $data );
    } else {
        wp_send_json_error();
    }
}

// report logo url field
function  wp_ada_compliance_settings_report_logo_url_field() {
// see logo field above    

    return;
}

// display report form link
function  wp_ada_compliance_settings_use_accessibility_widget_form() {

$use_accessibility_widget_form = get_option('wp_ada_compliance_use_accessibility_widget_form','');
echo '<p class=" wp-ada-important">';
	echo '<label for="wp_ada_compliance_use_accessibility_widget_form">';
_e('Enter the full url of your contact form and a "report problems" link will be displayed inside the web accessibility widget popup. (including https://)', 'wp-ada-compliance');	
echo '</label>';
    echo '<br />';
	echo '<input type="text" size="65" name="wp_ada_compliance_use_accessibility_widget_form" id="wp_ada_compliance_use_accessibility_widget_form" value="'.esc_attr($use_accessibility_widget_form).'" />';
echo '</p>';
}

	// text for the statement of commitment
function  wp_ada_compliance_settings_use_accessibility_widget_statement() {
$use_accessibility_widget_statement = get_option('wp_ada_compliance_use_accessibility_widget_statement',__('The accessibility of our website is taken very seriously. We strive to meet WCAG 2.1 AA Web Accessibility standards by routinely evaluating our website using automated evaluation tools and manual testing when required. As content changes we review and correct issues and are responsive to our users needs. If you encounter issues with our website, please report them so they may be corrected in a timely manner.','wp-ada-compliance'));
    
echo '<p class=" wp-ada-important">';
echo '<label for="wp_ada_compliance_use_accessibility_widget_statement">';
_e('The statement entered into this field will be displayed when a user click on the "Our Commitment" link inside the web accessibility widget popup. (plain text only)', 'wp-ada-compliance');	
echo '</label>';
    echo'<br />';
	echo '<textarea rows="6" cols="75" name="wp_ada_compliance_use_accessibility_widget_statement" id="wp_ada_compliance_use_accessibility_widget_statement">'.esc_attr($use_accessibility_widget_statement).'</textarea>';
echo '</p>';
}

// scan type section text goes here
function  wp_ada_compliance_scantypetext() {

if(isset($_GET['settings-updated'])){    
// purge error records	
//wp_ada_compliance_purge_records_not_monitored();
}
    
echo '<div class="ada_compliance_settings_text">';    
echo '<p>';
_e('Choose the website content to be monitored.', 'wp-ada-compliance');	
echo '</p>';
echo '<p class=" wp-ada-important">';
_e('The default settings will work for most websites, however settings marked with a red bar on the left should be reviewed and set according to your website requirements.', 'wp-ada-compliance');	
echo '</p></div>';
}

// select if theme files should be scanned
//DEFINE THEME FILE SCAN ITEMS
$wp_ada_compliance_theme_scan_items[0] = __("Blog Home", 'wp-ada-compliance');
$wp_ada_compliance_theme_scan_items[1] = __("404 Page", 'wp-ada-compliance');
$wp_ada_compliance_theme_scan_items[2] = __("Search Page", 'wp-ada-compliance');
$wp_ada_compliance_theme_scan_items[3] = __("Author Page", 'wp-ada-compliance');
//$wp_ada_compliance_theme_scan_items[4] = __("Post Archives", 'wp-ada-compliance');
//$wp_ada_compliance_theme_scan_items[5] = __("Taxonomy Archives", 'wp-ada-compliance');	

function  wp_ada_compliance_settings_scan_themes() {
global $wp_ada_compliance_theme_scan_items;

$scan_themes = get_option('wp_ada_compliance_scan_themes',array('Blog Home',"404 Page","Search Page"));
echo '<fieldset class="wp-ada-important">';
echo '<legend>';
_e('Choose the theme content to be monitored:', 'wp-ada-compliance');
echo '</legend>';
foreach($wp_ada_compliance_theme_scan_items as $key => $value){	
echo '<input type="checkbox" name="wp_ada_compliance_scan_themes[]" id="wp_ada_compliance_scan_themes_'.str_replace(" ", "_",esc_attr($value)).'" value="'.esc_attr($value).'" ';
if(get_option('wp_ada_compliance_posttypes', '') != '' or $value != "Blog Home" or ($value == "Blog Home" and get_option('show_on_front') == 'posts')) {
    
if(is_array($scan_themes) and in_array($value, $scan_themes)) echo ' checked';
}
echo '><label for="wp_ada_compliance_scan_themes_'.str_replace(" ", "_",esc_attr($value)).'">';
echo strtolower(esc_attr($value));
if($value == 'Blog Home' and get_option('show_on_front') == 'page')  { 
    echo '<span class="ada_red_text"> ';
    _e(' - a static page is set as the home page, uncheck this option to reduce duplication ', 'wp-ada-compliance');  
   
    echo '</span>';
}
echo '</label> <br />';	
}
echo '</fieldset>';
	
}

function  wp_ada_compliance_settings_scan_external_sources() {

    // purge types no longer monitored
    wp_ada_compliance_purge_external_src();
	
$scan_external_sources = get_option('wp_ada_compliance_scan_external_sources',array('iframe', 'linked'));
echo '<fieldset class="wp-ada-important">';
echo '<legend>';	
_e('Select additional sources to be monitored. During the scan process all website links will be identified and scanned, including those to content created outside of Wordpress. To disable this behavior uncheck "links found while crawling the website". ', 'wp-ada-compliance');
    _e('It is normally best to leave style sheet sources and postscript document format files unchecked during your initial scan. This allows you to focus on your webpage content. At a later date you can return to the settings screen and enable these options. This plugin conducts only a basic accessibility check of PDF files. Most PDF accessibility issues can only be detected using Adobe Acrobat Pro. Always use Adobe Acrobat Pro or other suitable PDF creation software to identify and correct issues in PDF documents prior to uploading them to your website.', 'wp-ada-compliance');
echo '</legend>';
echo '<input type="checkbox" name="wp_ada_compliance_scan_external_sources[]" id="wp_ada_compliance_scan_external_sources_links" value="linked" ';
if(is_array($scan_external_sources) and in_array('linked', $scan_external_sources)) echo ' checked';
echo '><label for="wp_ada_compliance_scan_external_sources_links">';
echo __('links found while crawling the website','wp-ada-compliance');
echo '</label> ';
 
echo '<br /><input type="checkbox" name="wp_ada_compliance_scan_external_sources[]" id="wp_ada_compliance_scan_external_sources_iframe" value="iframe" ';
if(is_array($scan_external_sources) and in_array('iframe', $scan_external_sources)) echo ' checked';
echo '><label for="wp_ada_compliance_scan_external_sources_iframe">';
echo __('iframe sources','wp-ada-compliance');
echo '</label> <br />';	
echo '<input type="checkbox" name="wp_ada_compliance_scan_external_sources[]" id="wp_ada_compliance_scan_external_sources_css" value="css" ';
if(is_array($scan_external_sources) and in_array('css', $scan_external_sources)) echo ' checked';
echo '><label for="wp_ada_compliance_scan_external_sources_css">';
echo __('style sheet sources (CSS)','wp-ada-compliance');
echo '</label> <br />';	
    echo '</legend>';
echo '<input type="checkbox" name="wp_ada_compliance_scan_external_sources[]" id="wp_ada_compliance_scan_external_sources_pdf" value="pdf" ';
if(is_array($scan_external_sources) and in_array('pdf', $scan_external_sources)) echo ' checked';
echo '><label for="wp_ada_compliance_scan_external_sources_pdf">';
echo __('postscript document format files (PDF) ','wp-ada-compliance');
echo '</label> ';
echo '</fieldset>';

}
	
// include error summary on report screens
function  wp_ada_compliance_settings_report_summary() {

$report_summary = get_option('wp_ada_compliance_report_summary','true');

echo '<fieldset>';
echo '<legend>';	
_e('Display error summary on reports.', 'wp-ada-compliance');
echo '</legend>';
echo '<br />';
	
echo '<input type="radio" name="wp_ada_compliance_report_summary" id="wp_ada_compliance_report_summary_true" value="true" ';
if($report_summary == 'true') echo ' checked';
echo '><label for="wp_ada_compliance_report_summary_true">';
_e('Yes', 'wp-ada-compliance');
echo '</label> ';	
	
echo '<input type="radio" name="wp_ada_compliance_report_summary" id="wp_ada_compliance_report_summary_false" value="false" ';
if($report_summary == 'false') echo ' checked';
echo '><label for="wp_ada_compliance_report_summary_false">';
_e('No', 'wp-ada-compliance');
echo '</label> ';	
	
echo '</fieldset>';

}


// scan external domains
function  wp_ada_compliance_settings_scan_external_domains() {
    
$scan_external_domains = get_option('wp_ada_compliance_scan_external_domains','false');

echo '<fieldset class="wp_ada_advanced">';
echo '<legend>';	
_e('Should CSS files from external domains be included.', 'wp-ada-compliance');
echo '</legend>';
echo '<br />';
	
echo '<input type="radio" name="wp_ada_compliance_scan_external_domains" id="wp_ada_compliance_scan_external_domains_true" value="true" ';
if($scan_external_domains == 'true') echo ' checked';
echo '><label for="wp_ada_compliance_scan_external_domains_true">';
_e('Yes', 'wp-ada-compliance');
echo '</label> <br />';	
	
echo '<input type="radio" name="wp_ada_compliance_scan_external_domains" id="wp_ada_compliance_scan_external_domains_false" value="false" ';
if($scan_external_domains == 'false' or $scan_external_domains == '') echo ' checked';
echo '><label for="wp_ada_compliance_scan_external_domains_false">';
_e('No', 'wp-ada-compliance');
echo '</label> <br />';	
	
echo '</fieldset>';

}

// display settings for correcting prentation tables
function  wp_ada_compliance_settings_presentation_tables() {

$presentation_tables = get_option('wp_ada_compliance_presentation_tables','true');

echo '<fieldset class="wp_ada_advanced">';
echo '<legend>';	
_e('Tables used for presentation only should have the attribute role="presentation". Using the default editor you must switch to text view, locate the affected table and add the attribute. By enabling this option a "Format" selector will be added to the Wordpress Classic Editor or classic block allowing you to select the table and mark it as "Presentation Table". The plugin will add the role="presentation" attribute as the page is loaded.', 'wp-ada-compliance');	
echo '</legend>';
echo '<br />';
	
echo '<input type="radio" name="wp_ada_compliance_presentation_tables" id="wp_ada_compliance_presentation_tables_true" value="true" ';
if($presentation_tables == 'true') echo ' checked';
echo '><label for="wp_ada_compliance_presentation_tables_true">';
_e('Add a Format selector to the visual editor and apply role="presentation" to tables when marked as Presentation Tables', 'wp-ada-compliance');
echo '</label> <br />';	
	
echo '<input type="radio" name="wp_ada_compliance_presentation_tables" id="wp_ada_compliance_presentation_tables_false" value="false" ';
if($presentation_tables == 'false') echo ' checked';
echo '><label for="wp_ada_compliance_presentation_tables_false">';
_e('Do not add a Format selector to the visual editor or apply role="presentation" to tables.', 'wp-ada-compliance');
echo '</label> <br />';	
	
echo '</fieldset>';

}

// display settings deep scan (scan with wpget)
function  wp_ada_compliance_settings_deep_scan() {
		
$wp_ada_compliance_deep_scan = get_option('wp_ada_compliance_deep_scan','deep');	
	
echo '<fieldset class="wp_ada_advanced">';
echo '<legend>';	
_e('Choose a content scan type:', 'wp-ada-compliance');	
echo '</legend>';	
	
echo '<input type="radio" name="wp_ada_compliance_deep_scan" id="wp_ada_compliance_deep_scan_deep" value="deep" ';
if($wp_ada_compliance_deep_scan == 'deep') echo ' checked';
echo '><label for="wp_ada_compliance_deep_scan_deep">';
_e('Deep Scan (Slower but thorough scan, will identify issues over the entire website.)', 'wp-ada-compliance');
echo '</label> <br />';	
	
echo '<input type="radio" name="wp_ada_compliance_deep_scan" id="wp_ada_compliance_deep_scan_basic" value="basic" ';
if($wp_ada_compliance_deep_scan == 'basic') echo ' checked';
echo '><label for="wp_ada_compliance_deep_scan_basic">';
_e('Basic Scan (Scan of database fields only, will not identify issues found in theme files.)');
echo '</label> <br />';	
	
echo '</fieldset>';

}

// should deep scan be run on editor screen to clear custom field errors and such
function  wp_ada_compliance_settings_deep_scan_on_editor() {
$deep_scan_on_editor = get_option('wp_ada_compliance_deep_scan_on_editor','true');
	
// purge onsave records when deep scan is used on editor screen
wp_ada_compliance_purge_onsave_errors();		

echo '<fieldset class="wp_ada_advanced">';
echo '<legend>';
_e('Enable this option to scan content from the editor screen. Use the "recheck" option on the report screen when deep scan is disabled.', 'wp-ada-compliance');	
echo '</legend>';	
echo '<br />';
	
echo '<input type="radio" name="wp_ada_compliance_deep_scan_on_editor" id="wp_ada_compliance_deep_scan_on_editor_true" value="true" ';
if($deep_scan_on_editor == 'true') echo ' checked';
echo '><label for="wp_ada_compliance_deep_scan_on_editor_true">';
_e('Enable deep scan on editor screen', 'wp-ada-compliance');
echo '</label> <br />';	

echo '<input type="radio" name="wp_ada_compliance_deep_scan_on_editor" id="wp_ada_compliance_deep_scan_on_editor_false" value="false" ';
if($deep_scan_on_editor == 'false') echo ' checked';
echo '><label for="wp_ada_compliance_deep_scan_on_editor_false">';
_e('Disable deep scan on editor screen (may result in duplicate errors in report)', 'wp-ada-compliance');  
echo '</label> <br />';	
    
echo '<input type="radio" name="wp_ada_compliance_deep_scan_on_editor" id="wp_ada_compliance_deep_scan_on_editor_disabled" value="disabled" ';
if($deep_scan_on_editor == 'disabled') echo ' checked';
echo '><label for="wp_ada_compliance_deep_scan_on_editor_disabled">';
_e('Disable scan on editor screen', 'wp-ada-compliance'); 
echo '</label> <br />';	  
	
echo '</fieldset>';	
	
}

// correct visual form builder labels and radio buttons
function  wp_ada_compliance_settings_correct_vfb_labels() {
$correct_vfb_labels = get_option('wp_ada_compliance_correct_vfb_labels','true'); 
echo '<h2>'.__('Miscellaneous Plugin Filter Settings', 'wp-ada-compliance').'</h2>';
echo '<fieldset class="wp_ada_advanced">';
echo '<legend>';
_e('The Visual Form Builder plugin creates radio buttons and captcha fields that may cause issues in screen readers. Enable this option to correct these issues.', 'wp-ada-compliance');	
echo '</legend>';	
echo '<br />';
	
echo '<input type="radio" name="wp_ada_compliance_correct_vfb_labels" id="wp_ada_compliance_correct_vfb_labels_true" value="true" ';
if($correct_vfb_labels == 'true') echo ' checked';
echo '><label for="wp_ada_compliance_correct_vfb_labels_true">';
_e('Yes', 'wp-ada-compliance');
echo '</label> ';	
	
echo '<input type="radio" name="wp_ada_compliance_correct_vfb_labels" id="wp_ada_compliance_correct_vfb_labels_false" value="false" ';
if($correct_vfb_labels == 'false') echo ' checked';
echo '><label for="wp_ada_compliance_correct_vfb_labels_false">';
_e('No', 'wp-ada-compliance');
echo '</label> ';	   
	
echo '</fieldset>';	
	
}

// correct gravity forms issues
function  wp_ada_compliance_settings_correct_gravity_forms_issues() {
$correct_issues = get_option('wp_ada_compliance_correct_gravity_forms_issues','true'); 

echo '<fieldset class="wp_ada_advanced">';
echo '<legend>';
_e('The Gravity Forms plugin creates captcha fields that may create confusion for screen reader users. Enable this option to correct this issue.', 'wp-ada-compliance');	
echo '</legend>';	
echo '<br />';
	
echo '<input type="radio" name="wp_ada_compliance_correct_gravity_forms_issues" id="wp_ada_compliance_correct_gravity_forms_issues_true" value="true" ';
if($correct_issues == 'true') echo ' checked';
echo '><label for="wp_ada_compliance_correct_gravity_forms_issues_true">';
_e('Yes', 'wp-ada-compliance');
echo '</label> ';	
	
echo '<input type="radio" name="wp_ada_compliance_correct_gravity_forms_issues" id="wp_ada_compliance_correct_gravity_forms_issues_false" value="false" ';
if($correct_issues == 'false') echo ' checked';
echo '><label for="wp_ada_compliance_correct_gravity_forms_issues_false">';
_e('No', 'wp-ada-compliance');
echo '</label> ';	   
	
echo '</fieldset>';	
	
}


// correct elementor table of contents
function  wp_ada_compliance_settings_correct_elementor_TOC() {
    
if ( ! function_exists( 'is_plugin_active' ) )
     require_once( ABSPATH . '/wp-admin/includes/plugin.php' );    
    
if(!is_plugin_active('elementor-pro/elementor-pro.php')) return;      
    
$setting = get_option('wp_ada_compliance_correct_elementor_TOC','true'); 
    
echo '<fieldset class="wp_ada_advanced">';
echo '<legend>';
_e('The Elementor Table of Contents widget creates links that do not change focus when clicked. This disorients screen reader users who expect the link to take them to the linked content. Enable this option to correct this issue. ', 'wp-ada-compliance');	
echo '</legend>';	
echo '<br />';
	
echo '<input type="radio" name="wp_ada_compliance_correct_elementor_TOC" id="wp_ada_compliance_correct_elementor_TOC_true" value="true" ';
if($setting == 'true') echo ' checked';
echo '><label for="wp_ada_compliance_correct_elementor_TOC_true">';
_e('Yes', 'wp-ada-compliance');
echo '</label> ';

    
echo '<input type="radio" name="wp_ada_compliance_correct_elementor_TOC" id="wp_ada_compliance_correct_elementor_TOC_false" value="false" ';
if($setting == 'false') echo ' checked';
echo '><label for="wp_ada_compliance_correct_elementor_TOC_false">';
_e('No', 'wp-ada-compliance');
echo '</label> ';  
    echo '<br />';
    	   
	
echo '</fieldset>';	
	
}

// stop autoplay on image carousels
function wp_ada_compliance_settings_stop_autoplay_image_carousel() {
    
if ( ! function_exists( 'is_plugin_active' ) )
     require_once( ABSPATH . '/wp-admin/includes/plugin.php' );    
    
if(!is_plugin_active('elementor-pro/elementor-pro.php')) return;      
    
$setting = get_option('wp_ada_compliance_stop_autoplay_image_carousel','false'); 
    
echo '<fieldset class="wp_ada_advanced  wp-ada-important">';
echo '<legend>';
_e('The Elementor image carousel widget defaults to autoplay but does not provide controls to pause or stop. Any moving, blinking or scrolling information that starts automatically, lasts more than five seconds, and is presented in parallel with other content must have a mechanism for the user to pause, stop, or hide it. Enable this option to disable auto play of the Elementor carousel widget and to add aria role and labels to image carousels to clearly define the purpose of the carousel.', 'wp-ada-compliance');	
echo ' <i class="fas fa-plus-circle adanewitem"> '.__('new setting', 'wp-ada-compliance').' </i>';
echo '</legend>';	
    
echo '<br />';
	
echo '<input type="radio" name="wp_ada_compliance_stop_autoplay_image_carousel" id="wp_ada_compliance_stop_autoplay_image_carousel_true" value="true" ';
if($setting == 'true') echo ' checked';
echo '><label for="wp_ada_compliance_stop_autoplay_image_carousel_true">';
_e('Yes', 'wp-ada-compliance');
echo '</label> ';

    
echo '<input type="radio" name="wp_ada_compliance_stop_autoplay_image_carousel" id="wp_ada_compliance_stop_autoplay_image_carousel_false" value="false" ';
if($setting == 'false') echo ' checked';
echo '><label for="wp_ada_compliance_stop_autoplay_image_carousel_false">';
_e('No', 'wp-ada-compliance');
echo '</label> ';  
    echo '<br />';
    	   
	
echo '</fieldset>';	
	
}


// hide font awesome icons
function wp_ada_compliance_settings_hide_font_awesome_icons() {
        
$setting = get_option('wp_ada_compliance_hide_font_awesome_icons','true'); 
    
echo '<fieldset class="wp_ada_advanced ">';
echo '<legend>';
_e('Font awesome icons used for decoration should be hidden from screen reader users using the aria-hidden attribute. Enable this option to add aria-hidden="true" to font awesome icons that do not include text, title or aria-labels.', 'wp-ada-compliance');	
echo ' <i class="fas fa-plus-circle adanewitem"> '.__('new setting', 'wp-ada-compliance').' </i>';
echo '</legend>';	
    
echo '<br />';
	
echo '<input type="radio" name="wp_ada_compliance_hide_font_awesome_icons" id="wp_ada_compliance_hide_font_awesome_icons_true" value="true" ';
if($setting == 'true') echo ' checked';
echo '><label for="wp_ada_compliance_hide_font_awesome_icons_true">';
_e('Yes', 'wp-ada-compliance');
echo '</label> ';

    
echo '<input type="radio" name="wp_ada_compliance_hide_font_awesome_icons" id="wp_ada_compliance_hide_font_awesome_icons_false" value="false" ';
if($setting == 'false') echo ' checked';
echo '><label for="wp_ada_compliance_hide_font_awesome_icons_false">';
_e('No', 'wp-ada-compliance');
echo '</label> ';  
    echo '<br />';
    	   
	
echo '</fieldset>';	
	
}

// correct elementor anchor links
function  wp_ada_compliance_settings_correct_anchor_links() {
    
if ( ! function_exists( 'is_plugin_active' ) )
     require_once( ABSPATH . '/wp-admin/includes/plugin.php' );    

    if(!is_plugin_active('elementor/elementor.php')) return $dom;         
    
$setting = get_option('wp_ada_compliance_correct_anchor_links','true'); 
		
echo '<fieldset class="wp_ada_advanced">';
echo '<legend>';
_e('Some themes and plugins change page anchor (i.e... #maincontent) behavior to create a scrolling affect and by doing so do not move focus to the actual page content. This behavior, when not done correctly, may result in anchor links being inaccessible to screen reader users. Enable this option to correct this issue. Note: Smooth scroll may be implemented by adding html{scroll-behavior: smooth} to your custom CSS.', 'wp-ada-compliance');
echo ' <i class="fas fa-plus-circle adanewitem"> '.__('new setting', 'wp-ada-compliance').' </i>';	
echo '</legend>';	
echo '<br />';
	
echo '<input type="radio" name="wp_ada_compliance_correct_anchor_links" id="wp_ada_compliance_correct_anchor_links_true" value="true" ';
if($setting == 'true') echo ' checked';
echo '><label for="wp_ada_compliance_correct_anchor_links_true">';
_e('Yes', 'wp-ada-compliance');
echo '</label> ';

    
echo '<input type="radio" name="wp_ada_compliance_correct_anchor_links" id="wp_ada_compliance_correct_anchor_links_false" value="false" ';
if($setting == 'false') echo ' checked';
echo '><label for="wp_ada_compliance_correct_anchor_links_false">';
_e('No', 'wp-ada-compliance');
echo '</label> ';  
    echo '<br />';
    	   
	
echo '</fieldset>';	
	
}


// correct elementor toggles
function  wp_ada_compliance_settings_correct_elementor_toggles() {
    
if ( ! function_exists( 'is_plugin_active' ) )
     require_once( ABSPATH . '/wp-admin/includes/plugin.php' );    

    if(!is_plugin_active('elementor/elementor.php')) return $dom;         
    
$setting = get_option('wp_ada_compliance_correct_elementor_toggles','true'); 
    
	   echo '<h2>'.__('Elementor Filter Settings', 'wp-ada-compliance').'</h2>'; 
    
echo '<fieldset class="wp_ada_advanced ">';
echo '<legend>';
_e('Because they provide no audible indication of the state of the toggle (opened or closed), the Elementor Toggle or Accordion widget may cause confusion for screen reader users. Additionally these controls as well as the Elementor tab widget do not support use of the spacebar. Enable this option to correct these issues.', 'wp-ada-compliance');	
echo '</legend>';	
echo '<br />';
	
echo '<input type="radio" name="wp_ada_compliance_correct_elementor_toggles" id="wp_ada_compliance_correct_elementor_toggles_true" value="true" ';
if($setting == 'true') echo ' checked';
echo '><label for="wp_ada_compliance_correct_elementor_toggles_true">';
_e('Yes', 'wp-ada-compliance');
echo '</label> ';

    
echo '<input type="radio" name="wp_ada_compliance_correct_elementor_toggles" id="wp_ada_compliance_correct_elementor_toggles_false" value="false" ';
if($setting == 'false') echo ' checked';
echo '><label for="wp_ada_compliance_correct_elementor_toggles_false">';
_e('No', 'wp-ada-compliance');
echo '</label> ';  
    echo '<br />';
    	   
	
echo '</fieldset>';	
	
}



    
// correct elementor and image widgets
function  wp_ada_compliance_settings_correct_elementor_post_widget() {
    
if ( ! function_exists( 'is_plugin_active' ) )
     require_once( ABSPATH . '/wp-admin/includes/plugin.php' );    
if(!is_plugin_active('elementor-pro/elementor-pro.php')) return;      
    
$wp_ada_compliance_correct_elementor_post_widget = get_option('wp_ada_compliance_correct_elementor_post_widget','false'); 

echo '<fieldset class="wp_ada_advanced">';
echo '<legend>';
_e('Using the Elementor post widget may result in a variety of issue such as empty anchor tag or adjacent identical links. Enable this option to correct these issues using tabindex and aria-hidden.', 'wp-ada-compliance');	
echo '</legend>';	
echo '<br />';
	
echo '<input type="radio" name="wp_ada_compliance_correct_elementor_post_widget" id="wp_ada_compliance_correct_elementor_post_widget_true" value="true" ';
if($wp_ada_compliance_correct_elementor_post_widget == 'true') echo ' checked';
echo '><label for="wp_ada_compliance_correct_elementor_post_widget_true">';
_e('Correct Elementor post widgets', 'wp-ada-compliance');
echo '</label>';	
	echo'<br />';
echo '<input type="radio" name="wp_ada_compliance_correct_elementor_post_widget" id="wp_ada_compliance_correct_elementor_post_widget_false" value="false" ';
if($wp_ada_compliance_correct_elementor_post_widget == 'false') echo ' checked';
echo '><label for="wp_ada_compliance_correct_elementor_post_widget_false">';
_e('Do not correct Elementor post widgets', 'wp-ada-compliance');
echo '</label> <br />';	
	
echo '</fieldset>';	
}
    

// correct elementor icon and image widgets
function  wp_ada_compliance_settings_correct_elementor_icon_and_img_widgets() {
    
if ( ! function_exists( 'is_plugin_active' ) )
     require_once( ABSPATH . '/wp-admin/includes/plugin.php' );    
if(!is_plugin_active('elementor-pro/elementor-pro.php')) return;      
    
$correct_correct_elementor_icon_and_img_widgets = get_option('wp_ada_compliance_correct_elementor_icon_and_img_widgets','false'); 
if($correct_correct_elementor_icon_and_img_widgets != 'false' and $correct_correct_elementor_icon_and_img_widgets != 'true') $correct_correct_elementor_icon_and_img_widgets = 'true';
    
echo '<fieldset class="wp_ada_advanced">';
echo '<legend>';
_e('Using the Elementor icon or image box widget may result in a variety of issue such as empty anchor tag or adjacent identical links. Enable this option to correct these issues using tabindex and aria-hidden.', 'wp-ada-compliance');	
echo '</legend>';	
echo '<br />';
	
echo '<input type="radio" name="wp_ada_compliance_correct_elementor_icon_and_img_widgets" id="wp_ada_compliance_correct_elementor_icon_and_img_widgets_true" value="true" ';
if($correct_correct_elementor_icon_and_img_widgets == 'true') echo ' checked';
echo '><label for="wp_ada_compliance_correct_elementor_icon_and_img_widgets_true">';
_e('Correct Elementor icon and image widgets', 'wp-ada-compliance');
echo '</label>';	
	echo'<br />';
echo '<input type="radio" name="wp_ada_compliance_correct_elementor_icon_and_img_widgets" id="wp_ada_compliance_correct_elementor_icon_and_img_widgets_false" value="false" ';
if($correct_correct_elementor_icon_and_img_widgets == 'false') echo ' checked';
echo '><label for="wp_ada_compliance_correct_elementor_icon_and_img_widgets_false">';
_e('Do not correct Elementor icon and image widgets', 'wp-ada-compliance');
echo '</label> <br />';	
	
echo '</fieldset>';	
}
   
/*
// correct elementor and image widgets
function  wp_ada_compliance_settings_correct_elementor_icon_and_img_widgets() {
    
if ( ! function_exists( 'is_plugin_active' ) )
     require_once( ABSPATH . '/wp-admin/includes/plugin.php' );    
if(!is_plugin_active('elementor-pro/elementor-pro.php')) return;      
    
$correct_correct_elementor_icon_and_img_widgets = get_option('wp_ada_compliance_correct_elementor_icon_and_img_widgets','false'); 
    
echo '<fieldset class="wp_ada_advanced  wp-ada-important">';
echo '<legend>';
_e('Using the Elementor icon or image box widget may result in a variety of issue such as empty anchor tag or adjacent identical links. Enable this option to correct these issues. When icons are stacked/centered the links will be combined into a single link. When icons are aligned left or right one link will be removed depending upon the preferences selected below. When removing the title link ensure that an aria-label attribute (aria-label|alternate text) is added under link options. If no aria-label or title attribute is set and removing the title would result in the only available link being empty the icon will be removed instead. Apply "wp-ada-compliance-ignore" to the class attribute of the elementor icon or image widget to exclude it from being filtered.', 'wp-ada-compliance');	
echo '</legend>';	
echo '<br />';
	
echo '<input type="radio" name="wp_ada_compliance_correct_elementor_icon_and_img_widgets" id="wp_ada_compliance_correct_elementor_icon_and_img_widgets_remove-iconlink" value="remove-iconlink" ';
if($correct_correct_elementor_icon_and_img_widgets == 'remove-iconlink') echo ' checked';
echo '><label for="wp_ada_compliance_correct_elementor_icon_and_img_widgets_remove-iconlink">';
_e('Correct Elementor icon or image box widgets, when aligned left or right remove the icon link. (suggested)', 'wp-ada-compliance');
echo '</label> ';
    echo '<br />';
    
echo '<input type="radio" name="wp_ada_compliance_correct_elementor_icon_and_img_widgets" id="wp_ada_compliance_correct_elementor_icon_and_img_widgets_remove-titlelink" value="remove-titlelink" ';
if($correct_correct_elementor_icon_and_img_widgets == 'remove-titlelink') echo ' checked';
echo '><label for="wp_ada_compliance_correct_elementor_icon_and_img_widgets_remove-titlelink">';
_e('Correct Elementor icon or image box widgets, when aligned left or right remove the title link.', 'wp-ada-compliance');
echo '</label> ';  
    echo '<br />';
    
    echo '<input type="radio" name="wp_ada_compliance_correct_elementor_icon_and_img_widgets" id="wp_ada_compliance_correct_elementor_icon_and_img_widgets_remove-centeronly" value="remove-centeronly" ';
if($correct_correct_elementor_icon_and_img_widgets == 'remove-centeronly') echo ' checked';
echo '><label for="wp_ada_compliance_correct_elementor_icon_and_img_widgets_remove-centeronly">';
_e('Correct Elementor icon or image box widgets when center aligned only.', 'wp-ada-compliance');
echo '</label> ';  
    echo '<br />';
	
echo '<input type="radio" name="wp_ada_compliance_correct_elementor_icon_and_img_widgets" id="wp_ada_compliance_correct_elementor_icon_and_img_widgets_false" value="false" ';
if($correct_correct_elementor_icon_and_img_widgets == 'false') echo ' checked';
echo '><label for="wp_ada_compliance_correct_elementor_icon_and_img_widgets_false">';
_e('Do not correct Elementor icon or image box widgets.', 'wp-ada-compliance');
echo '</label> ';	   
	
echo '</fieldset>';	
	
}
*/

// correct emulating links 
function  wp_ada_compliance_settings_correct_emulating_links() {
$wp_ada_compliance_correct_links = get_option('wp_ada_compliance_correct_emulating_links','true');

echo '<fieldset class="wp_ada_advanced">';
echo '<legend>';
_e('If not done correctly, using javascript event handlers on elements that do not normally receive focus (i.e...IMG, DIV, SPAN, etc...) creates a problem for screen reader users. Enable this option to automatically add role and tabindex attributes to affected elements. (tabindex="0" and role="link")', 'wp-ada-compliance');	
echo '</legend>';	
echo '<br />';
	
echo '<input type="radio" name="wp_ada_compliance_correct_emulating_links" id="wp_ada_compliance_correct_emulating_links_true" value="true" ';
if($wp_ada_compliance_correct_links == 'true') echo ' checked';
echo '><label for="wp_ada_compliance_correct_emulating_links_true">';
_e('Yes', 'wp-ada-compliance');
echo '</label>';	
	
echo '<input type="radio" name="wp_ada_compliance_correct_emulating_links" id="wp_ada_compliance_correct_emulating_links_false" value="false" ';
if($wp_ada_compliance_correct_links == 'false') echo ' checked';
echo '><label for="wp_ada_compliance_correct_emulating_links_false">';
_e('No', 'wp-ada-compliance');
echo '</label> <br />';	
	
echo '</fieldset>';	
	
}
// correct event handlers without keyboard support
function  wp_ada_compliance_settings_correct_event_handlers() {
$wp_ada_compliance_correct_event_handlers = get_option('wp_ada_compliance_correct_event_handlers','true');

echo '<fieldset class="wp_ada_advanced">';
echo '<legend>';
_e('When using a mouse event handler such as onclick an equivalent keyboard event handler must be provided for keyboard users. Enable this option to automatically add onkeypress attributes when not present.', 'wp-ada-compliance');	
echo '</legend>';	
echo '<br />';
	
echo '<input type="radio" name="wp_ada_compliance_correct_event_handlers" id="wp_ada_compliance_correct_event_handlers_true" value="true" ';
if($wp_ada_compliance_correct_event_handlers == 'true') echo ' checked';
echo '><label for="wp_ada_compliance_correct_event_handlers_true">';
_e('Yes', 'wp-ada-compliance');
echo '</label>';	
	
echo '<input type="radio" name="wp_ada_compliance_correct_event_handlers" id="wp_ada_compliance_correct_event_handlers_false" value="false" ';
if($wp_ada_compliance_correct_event_handlers == 'false') echo ' checked';
echo '><label for="wp_ada_compliance_correct_event_handlers_false">';
_e('No', 'wp-ada-compliance');
echo '</label> <br />';	
	
echo '</fieldset>';	
	
}


// optional styles
function  wp_ada_compliance_settings_focus_styles() {
$wp_ada_compliance_focus_styles = get_option('wp_ada_compliance_focus_styles','true');

echo '<fieldset class="wp-ada-important">';
echo '<legend>';
_e('Some developers will remove the outline from links, buttons and other focusable content. Enable this option to apply CSS styles to restore visual indicators when an element is in focus or optionally when moused over.', 'wp-ada-compliance');	
echo '</legend>';	
echo '<br />';
	
echo '<input type="radio" name="wp_ada_compliance_focus_styles" id="wp_ada_compliance_focus_styles_true" value="true" ';
if($wp_ada_compliance_focus_styles == 'true') echo ' checked';
echo '><label for="wp_ada_compliance_focus_styles_true">';
_e('Yes', 'wp-ada-compliance');
echo '</label>';	
	
echo '<input type="radio" name="wp_ada_compliance_focus_styles" id="wp_ada_compliance_focus_styles_false" value="false" ';
if($wp_ada_compliance_focus_styles == 'false') echo ' checked';
echo '><label for="wp_ada_compliance_focus_styles_false">';
_e('No', 'wp-ada-compliance');
echo '</label> <br />';	
	
echo '</fieldset>';	
	
}

// include link hover effect when adding focus
function  wp_ada_compliance_settings_include_hover() {
$wp_ada_compliance_include_hover = get_option('wp_ada_compliance_include_hover','false');

echo '<fieldset>';
echo '<legend>';
_e('Include outline on links when the mouse hovers over them.', 'wp-ada-compliance');	
echo '</legend>';	
echo '<br />';
	
echo '<input type="radio" name="wp_ada_compliance_include_hover" id="wp_ada_compliance_include_hover" value="true" ';
if($wp_ada_compliance_include_hover == 'true') echo ' checked';
echo '><label for="wp_ada_compliance_include_hover_true">';
_e('Yes', 'wp-ada-compliance');
echo '</label>';	
	
echo '<input type="radio" name="wp_ada_compliance_include_hover" id="wp_ada_compliance_include_hover_false" value="false" ';
if($wp_ada_compliance_include_hover == 'false') echo ' checked';
echo '><label for="wp_ada_compliance_include_hover_false">';
_e('No', 'wp-ada-compliance');
echo '</label> <br />';	
	
echo '</fieldset>';	
	
}
	
// outline color
function  wp_ada_compliance_settings_outline_color() {
$wp_ada_compliance_focus_outline_color = get_option('wp_ada_compliance_outline_color','#5E9ED6');

	echo '<p class="wp-ada-important">';
	echo '<label for="wp_ada_compliance_outline_color">';
_e('Set your own color for the outline displayed on links that are in focus: (i.e...#5E9ED6)', 'wp-ada-compliance');	
echo '</label>';
	echo '<br />';
	echo '<input type="text" size="25" name="wp_ada_compliance_outline_color" id="wp_ada_compliance_outline_color" value="'.esc_attr($wp_ada_compliance_focus_outline_color).'" />';
echo '</p>';
	
}



// strip html from post titles
function  wp_ada_compliance_settings_strip_html_from_title() {

$strip_html_from_title = get_option('wp_ada_compliance_strip_html_from_title','false');

	echo '<fieldset>';
echo '<legend>';
_e('Adding html code such as anchor tags to post titles can result in empty anchors and other unforeseen issues that could confuse screen reader users. This option allows administrators to restrict the html allowed in title values.', 'wp-ada-compliance');	
echo '</legend>';	
echo '<br />';
	
echo '<input type="radio" name="wp_ada_compliance_strip_html_from_title" id="wp_ada_compliance_strip_html_from_title_true" value="true" ';
if($strip_html_from_title == 'true') echo ' checked';
echo '><label for="wp_ada_compliance_strip_html_from_title_true">';
_e('Strip all html tags accept those included in the option below from title values as posts are saved.', 'wp-ada-compliance');
echo '</label> <br />';	
	
echo '<input type="radio" name="wp_ada_compliance_strip_html_from_title" id="wp_ada_compliance_strip_html_from_title_false" value="false" ';
if($strip_html_from_title == 'false') echo ' checked';
echo '><label for="wp_ada_compliance_strip_html_from_title_false">';
_e('Do not strip html tags.', 'wp-ada-compliance');
echo '</label> <br />';	
	
echo '</fieldset>';

}

// html tags to allow in title tags
function  wp_ada_compliance_settings_strip_html_allowed_tags() {
$allowed_tags = get_option('wp_ada_compliance_strip_html_allowed_tags','<br>');
echo '<p>';
	echo '<label for="wp_ada_compliance_strip_html_allowed_tags">';
_e('Enter the html tags that should be allowed in title values: (format: &lt;br&gt;&lt;h1&gt;&lt;h2&gt;)', 'wp-ada-compliance');	
echo '</label><br />';
	echo '<input type="text" size="65" name="wp_ada_compliance_strip_html_allowed_tags" id="wp_ada_compliance_strip_html_allowed_tags" value="'.esc_attr($allowed_tags).'" />';
echo '</p>';
}

// display settings for link titles
/*
function wp_ada_compliance_settings_correct_ambiguous_link_text() {
	// check if option is enabled
$correct_ambiguous_link_text = get_option('wp_ada_compliance_correct_ambiguous_link_text','true');
	
echo '<fieldset>';
echo '<legend>';
_e("Add aria-label attributes to links with ambiguous link text (i.e.. click here, find out more, etc...). The value will be set to the post or page title of the linked page only when it can be detected. External links and those that can not be detected will remain unchanged.", 'wp-ada-compliance');
	echo ' <i class="fas fa-plus-circle adanewitem"> '.__('new setting', 'wp-ada-compliance').' </i>';
echo '</legend>';	
echo '<br />';
	
echo '<input type="radio" name="wp_ada_compliance_correct_ambiguous_link_text" id="wp_ada_compliance_correct_ambiguous_link_text" value="true" ';
if($correct_ambiguous_link_text == 'true') echo ' checked';
echo '><label for="wp_ada_compliance_correct_ambiguous_link_text">';
_e('Yes', 'wp-ada-compliance');
echo '</label> ';	
	
echo '<input type="radio" name="wp_ada_compliance_correct_ambiguous_link_text" id="wp_ada_compliance_link_correct_ambiguous_link_text" value="false" ';
if($correct_ambiguous_link_text == 'false') echo ' checked';
echo '><label for="wp_ada_compliance_correct_ambiguous_link_text">';
_e('No', 'wp-ada-compliance');
echo '</label>';	
echo '</fieldset>';
	
	
}*/

// display settings for converting link title to aria-label
function wp_ada_compliance_settings_convert_link_titles() {
	// check if option is enabled
$link_titles = get_option('wp_ada_compliance_convert_link_titles','true');
	
echo '<fieldset>';
echo '<legend>';
_e("Using the aria-label attribute on links instead of the title attribute results in less confusion to VoiceOver screen reader users. Enable this option to convert title attributes on links to aria-label attributes when no link text is found or when the link includes an image with no alternate text.", 'wp-ada-compliance');
		echo '<span class="adaAllGood">';
_e(' (links with the class no-title-convert will be ignored)','wp-ada-compliance');	
echo '</span>';	
echo '</legend>';	
echo '<br />';
	
echo '<input type="radio" name="wp_ada_compliance_convert_link_titles" id="wp_ada_compliance_convert_link_titles_true" value="true" ';
if($link_titles == 'true') echo ' checked';
echo '><label for="wp_ada_compliance_convert_link_titles_true">';
_e('Yes', 'wp-ada-compliance');
echo '</label> ';	
	
echo '<input type="radio" name="wp_ada_compliance_convert_link_titles" id="wp_ada_compliance_convert_link_titles_false" value="false" ';
if($link_titles == 'false') echo ' checked';
echo '><label for="wp_ada_compliance_convert_link_titles_false">';
_e('No', 'wp-ada-compliance');
echo '</label>';	
echo '</fieldset>';
	
	
}

// display settings for link titles
function  wp_ada_compliance_settings_link_title_tools_function() {

$link_titles = get_option('wp_ada_compliance_link_title_tools','true');
echo '<fieldset>';
echo '<legend>';
_e("The title attribute can be used to provide supplemental information to improve the accessibility of links. The information in the title attribute is shown to visual users as a tool tip when hovering over the object with the mouse and read as supplemental information to screen reader users. The following settings will improve the accessibility of links by allowing title and class attributes to be added to links using the linking tool and without having to switch to text view.", 'wp-ada-compliance');
echo '</legend>';	
echo '<br />';
	echo '<input type="radio" name="wp_ada_compliance_link_title_tools" id="wp_ada_compliance_link_title_tools_true" value="true" ';
if($link_titles == 'true') echo ' checked';
echo '><label for="wp_ada_compliance_link_title_tools_true">';
_e('Add the title and class options to the linking tool.', 'wp-ada-compliance');
echo '</label> <br />';	
    
echo '<input type="radio" name="wp_ada_compliance_link_title_tools" id="wp_ada_compliance_link_title_tools_false" value="false" ';
if($link_titles == 'false') echo ' checked';
echo '><label for="wp_ada_compliance_link_title_tools_false">';
_e('Do not add title or class options to the linking tool.', 'wp-ada-compliance');
echo '</label> <br />';	
echo '</fieldset>';

}

function  wp_ada_compliance_settings_link_titles_font_awesome() {

$link_titles = get_option('wp_ada_compliance_link_titles_font_awesome','true');
echo '<fieldset>';	
echo '<legend>';
_e("Non image icons such as font awesome are frequently used inside links without link text. Either a title or aria-label attribute must be used to provide alternate text. Enable the following option to add aria-label attributes to empty links based on the user defined settings below. 
", 'wp-ada-compliance');	
	echo '<span class="adaAllGood">';
_e(' (links with the class no-title-convert will be ignored)','wp-ada-compliance');	
echo '</span>';
echo '</legend>';	
echo '<br />';	
	
echo '<input type="radio" name="wp_ada_compliance_link_titles_font_awesome" id="wp_ada_compliance_link_titles_font_awesome_yes" value="true" ';
if($link_titles == 'true') echo ' checked';
echo '><label for="wp_ada_compliance_link_titles_font_awesome_yes">';
_e('Correct links with no alternate text by adding aria-label attributes (i.e... font awesome icons)', 'wp-ada-compliance');
echo '</label> <br />';	
	
echo '<input type="radio" name="wp_ada_compliance_link_titles_font_awesome" id="wp_ada_compliance_link_titles_font_awesome_no" value="false" ';
if($link_titles == 'false') echo ' checked';
echo '><label for="wp_ada_compliance_link_titles_font_awesome_no">';
_e('Do not correct links with no alternate text.', 'wp-ada-compliance');
echo '</label>';	
	

echo '</fieldset>';

}


	// user defined font awesome conversion
function  wp_ada_compliance_settings_font_awesome_conversion_text() {
$conversiontext = get_option('wp_ada_compliance_font_awesome_conversion_text','');
echo '<p>';
echo '<label for="wp_ada_compliance_font_awesome_conversion_text">';
_e('Define your own font-awesome conversions by entering a list of icons to convert (example: fa-close=Close). Each item must be placed on a new line.', 'wp-ada-compliance');	
echo '</label><br />';
	echo '<textarea rows="4" cols="75" name="wp_ada_compliance_font_awesome_conversion_text" id="wp_ada_compliance_font_awesome_conversion_text">'.esc_attr($conversiontext).'</textarea>';
echo '</p>';
}


// display settings to remove linking of images to file
function  wp_ada_compliance_settings_starting_H_level() {

$starting_H_level = get_option('wp_ada_compliance_starting_H_level','h2');
echo '<fieldset class="wp-ada-important">';
echo '<legend>';
_e('The page title should always be wrapped in H1 elements and be displayed at the top of each page with the exception of the home page which may have the title of your website inside H1 elements. Most Wordpress themes are designed to place the page title automatically. If your theme does not place the page title and it is instead entered manually using the Wordpress editor this option should be changed to H1.', 'wp-ada-compliance');
echo '</legend>';	
echo '<br />';
_e('Starting heading level in your Wordpress page editor (normally H2): ', 'wp-ada-compliance');	
echo '<br />';	
	echo '<input type="radio" name="wp_ada_compliance_starting_H_level" id="wp_ada_compliance_starting_H_level_h1" value="h1" ';
if($starting_H_level == 'h1') echo ' checked';
echo '><label for="wp_ada_compliance_starting_H_level_h1">';
_e('H1', 'wp-ada-compliance');
echo '</label> ';
	echo '<input type="radio" name="wp_ada_compliance_starting_H_level" id="wp_ada_compliance_starting_H_level_h2" value="h2" ';
if($starting_H_level == 'h2') echo ' checked';
echo '><label for="wp_ada_compliance_starting_H_level_h2">';
_e('H2', 'wp-ada-compliance');
echo '</label> ';	
echo '</fieldset>';

}	
	
function  wp_ada_compliance_settings_remove_linking_images() {

$remove_linking_images = get_option('wp_ada_compliance_remove_linking_images','true');
echo '<fieldset class="wp_ada_advanced">';
echo '<legend>';
_e('By default, WordPress links images to themselves and remembers the users last choice when inserting an image. This is not an accessibility issue unless the image does not include alternate text indicating the content of the linked image but by turning off this behavior and requiring users to make the decision to link to the file, issues can be avoided.', 'wp-ada-compliance');	
echo '</legend>';	
echo '<br />';
	echo '<input type="radio" name="wp_ada_compliance_remove_linking_images" id="wp_ada_compliance_remove_linking_images_true" value="true" ';
if($remove_linking_images == 'true') echo ' checked';
echo '><label for="wp_ada_compliance_remove_linking_images_true">';
_e('Disable automatic linking of image files.', 'wp-ada-compliance');
echo '</label> <br />';
	echo '<input type="radio" name="wp_ada_compliance_remove_linking_images" id="wp_ada_compliance_remove_linking_images_false" value="false" ';
if($remove_linking_images == 'false') echo ' checked';
echo '><label for="wp_ada_compliance_remove_linking_images_false">';
_e('Enable the default Wordpress behavior.', 'wp-ada-compliance');
echo '</label> ';	
echo '</fieldset>';

}

// correct unlinked email addresses
function  wp_ada_compliance_link_email_addresses_settings() {
$link_email_addresses = get_option('wp_ada_compliance_link_email_addresses','true');
	
echo '<legend>';
_e('Correct unlinked email addresses by converting them to mailto: anchors:', 'wp-ada-compliance');	
echo '</legend>';
	echo '<br />';
echo '<input type="radio" name="wp_ada_compliance_link_email_addresses" id="wp_ada_compliance_link_email_addresses_true" value="true" ';
if($link_email_addresses == 'true') echo ' checked';
echo '><label for="wp_ada_compliance_link_email_addresses_true">';
_e('Yes', 'wp-ada-compliance');
echo '</label> ';
echo '<input type="radio" name="wp_ada_compliance_link_email_addresses" id="wp_ada_compliance_link_email_addresses_false" value="false" ';
if($link_email_addresses == 'false') echo ' checked';
echo '><label for="wp_ada_compliance_link_email_addresses_false">';
_e('No', 'wp-ada-compliance');
echo '</label> ';	
echo '</fieldset>';	
	
}

// enable wave evaluation tool
function  wp_ada_compliance_settings_enablewave() {


$enablewave = get_option('wp_ada_compliance_enablewave','true');
echo '<fieldset class="wp_ada_advanced">';
echo '<legend>';
_e('Enable external evaluation tools and validator links (i.e... WAVE Web Accessibility Evaluation Tool and W3C Validator)', 'wp-ada-compliance');	
echo '<br />';
echo '<input type="radio" name="wp_ada_compliance_enablewave" id="wp_ada_compliance_enablewave_true" value="true" ';
if($enablewave == 'true') echo ' checked';
echo '><label for="wp_ada_compliance_enablewave_true">';
_e('Yes', 'wp-ada-compliance');
echo '</label> ';
echo '<input type="radio" name="wp_ada_compliance_enablewave" id="wp_ada_compliance_enablewave_false" value="false" ';
if($enablewave == 'false') echo ' checked';
echo '><label for="wp_ada_compliance_enablewave_false">';
_e('No', 'wp-ada-compliance');
echo '</label> ';	
echo '</fieldset>';

}

// retain settings when plugin is deleted
function  wp_ada_compliance_settings_retain_settings() {

$retain_settings = get_option('wp_ada_compliance_retain_settings','false');
echo '<fieldset class="wp_ada_advanced">';
echo '<legend>';
_e('This option allows you to retain plugin settings when the plugin is deleted.  When permanently removing the plugin this setting should be changed so the database and all associated settings are removed.', 'wp-ada-compliance');	
echo '</legend>';	
echo '<br />';
echo '<input type="radio" name="wp_ada_compliance_retain_settings" id="wp_ada_compliance_retain_settings_true" value="true" ';
if($retain_settings == 'true') echo ' checked';
echo '><label for="wp_ada_compliance_retain_settings_true">';
_e('Retain settings when plugin is deleted.', 'wp-ada-compliance');
echo '</label> <br />';
echo '<input type="radio" name="wp_ada_compliance_retain_settings" id="wp_ada_compliance_retain_settings_false" value="false" ';
if($retain_settings == 'false') echo ' checked';
echo '><label for="wp_ada_compliance_retain_settings_false">';
_e('Remove settings when the plugin is deleted.', 'wp-ada-compliance');
echo '</label> ';	
echo '</fieldset>';

}

// disable font awesome on public pages
function  wp_ada_compliance_disable_fontawesome_public_settings() {

$disable_fontawesome = get_option('wp_ada_compliance_disable_fontawesome_public','false'); 
echo '<fieldset class="wp_ada_advanced">';
echo '<legend>';
_e('If Font Awesome is already being loaded on your public facing website use this option to tell the plugin not to load it again.', 'wp-ada-compliance');	
  
echo '</legend>';	
echo '<br />';
echo '<input type="radio" name="wp_ada_compliance_disable_fontawesome_public" id="wp_ada_compliance_disable_fontawesome_public_true" value="true" ';
if($disable_fontawesome == 'true') echo ' checked';
echo '><label for="wp_ada_compliance_disable_fontawesome_public_true">';
_e('Disable loading of font awesome files on public site.', 'wp-ada-compliance');
echo '</label> <br />';
echo '<input type="radio" name="wp_ada_compliance_disable_fontawesome_public" id="wp_ada_compliance_disable_fontawesome_public_false" value="false" ';
if($disable_fontawesome == 'false') echo ' checked';
echo '><label for="wp_ada_compliance_disable_fontawesome_public_false">';
_e('Enable loading of font awesome files on public site.', 'wp-ada-compliance');
echo '</label> ';	
echo '</fieldset>';

}



// add language attribute to html tag
function  wp_ada_compliance_settings_add_lang_attribute() {


$addlang = get_option('wp_ada_compliance_add_lang_attribute','true');
echo '<fieldset class="wp-ada-important">';
echo '<legend>';
_e('When missing, add language attributes to the html tag. The default language code is English "en". The language code may be changed under the "Miscellaneous" tab.', 'wp-ada-compliance');	
echo '</legend>';	
echo '<br />';
echo '<input type="radio" name="wp_ada_compliance_add_lang_attribute" id="wp_ada_compliance_add_lang_attribute_true" value="true" ';
if($addlang == 'true') echo ' checked';
echo '><label for="wp_ada_compliance_add_lang_attribute_true">';
_e('Yes', 'wp-ada-compliance');
echo '</label> ';
echo '<input type="radio" name="wp_ada_compliance_add_lang_attribute" id="wp_ada_compliance_add_lang_attribute_false" value="false" ';
if($addlang == 'false') echo ' checked';
echo '><label for="wp_ada_compliance_add_lang_attribute_false">';
_e('No', 'wp-ada-compliance');
echo '</label> ';	
echo '</fieldset>';

}

// remove justified text option from tinymce
function  wp_ada_compliance_settings_removejustify() {


$removejustify = get_option('wp_ada_compliance_removejustify','true');
echo '<fieldset class="wp_ada_advanced">';
echo '<legend>';
_e('Many people with cognitive disabilities have trouble with blocks of text that are justified (aligned to both the left and the right margins). Remove the option to justify text from the Wordpress editor.', 'wp-ada-compliance');	
echo '</legend>';	
echo '<br />';
echo '<input type="radio" name="wp_ada_compliance_removejustify" id="wp_ada_compliance_removejustify_true" value="true" ';
if($removejustify == 'true') echo ' checked';
echo '><label for="wp_ada_compliance_removejustify_true">';
_e('Yes', 'wp-ada-compliance');
echo '</label> ';
echo '<input type="radio" name="wp_ada_compliance_removejustify" id="wp_ada_compliance_removejustify_false" value="false" ';
if($removejustify == 'false') echo ' checked';
echo '><label for="wp_ada_compliance_removejustify_false">';
_e('No', 'wp-ada-compliance');
echo '</label> ';	
echo '</fieldset>';
}

// display settings to remove invalid alt text
function  wp_ada_compliance_settings_remove_invalid_img_alt_text() {

$remove_invalid_img_alt_text = get_option('wp_ada_compliance_remove_invalid_img_alt_text','true');

echo '<fieldset class="wp_ada_advanced">';
echo '<legend>';
_e('Remove phrases like "photo of" or "image of" from image alternate text. ', 'wp-ada-compliance');
echo '</legend>';	
echo '<br />';
	echo '<input type="radio" name="wp_ada_compliance_remove_invalid_img_alt_text" id="wp_ada_compliance_remove_invalid_img_alt_text_true" value="true" ';
if($remove_invalid_img_alt_text == 'true') echo ' checked';
echo '><label for="wp_ada_compliance_remove_invalid_img_alt_text_true">';
_e('Yes', 'wp-ada-compliance');
echo '</label> ';
	echo '<input type="radio" name="wp_ada_compliance_remove_invalid_img_alt_text" id="wp_ada_compliance_remove_invalid_img_alt_text_false" value="false" ';
if($remove_invalid_img_alt_text == 'false') echo ' checked';
echo '><label for="wp_ada_compliance_remove_invalid_img_alt_text_false">';
_e('No', 'wp-ada-compliance');
echo '</label> ';	
echo '</fieldset>';
}
// display settings to remove links from images that are linked to self
function  wp_ada_compliance_settings_remove_images_linked_to_self() {

$remove_images_linked_to_self = get_option('wp_ada_compliance_remove_images_linked_to_self','false');

echo '<fieldset class="wp_ada_advanced">';
echo '<legend>';
_e('By default, WordPress links images to themselves when they are inserted into a page. This is not an accessibility issue unless the image does not include alternate text indicating the content of the linked image but since many times images are linked to themselves inadvertently, this option will remove links from images that are linked to themselves. This option does not remove links from a smaller version of an image to a larger version such as when a thumbnail links to a larger size image. Only images that link to the exact same image are affected.', 'wp-ada-compliance');	
echo '</legend>';	
echo '<br />';
	echo '<input type="radio" name="wp_ada_compliance_remove_images_linked_to_self" id="wp_ada_compliance_remove_images_linked_to_self_true" value="true" ';
if($remove_images_linked_to_self == 'true') echo ' checked';
echo '><label for="wp_ada_compliance_remove_images_linked_to_self_true">';
_e('Remove links from images that link to themselves.', 'wp-ada-compliance');
echo '</label> <br />';
	echo '<input type="radio" name="wp_ada_compliance_remove_images_linked_to_self" id="wp_ada_compliance_remove_images_linked_to_self_false" value="false" ';
if($remove_images_linked_to_self == 'false') echo ' checked';
echo '><label for="wp_ada_compliance_remove_images_linked_to_self_false">';
_e('Do not remove links from images that are linked to themselves. ', 'wp-ada-compliance');
echo '</label> ';	
echo '</fieldset>';
}

// display errors settings autorized user list
function  wp_ada_compliance_settings_settingsusers() {

$settingsuser = get_option('wp_ada_compliance_settingsusers','manage_options');

echo '<fieldset>';
echo '<legend>';
_e('Choose the minimum role that can modify plugin settings: ', 'wp-ada-compliance');	
echo '</legend>';	
echo '<br />';
	echo '<input type="radio" name="wp_ada_compliance_settingsusers" id="wp_ada_compliance_settingsusers_editor" value="edit_pages" ';
if($settingsuser == 'edit_pages') echo ' checked';
echo '><label for="wp_ada_compliance_settingsusers_editor">';
_e('Editors', 'wp-ada-compliance');
echo '</label> ';
	echo '<input type="radio" name="wp_ada_compliance_settingsusers" id="wp_ada_compliance_settingsusers_admin" value="manage_options" ';
if($settingsuser == 'manage_options' or $settingsuser == 'update_core') echo ' checked';
echo '><label for="wp_ada_compliance_settingsusers_admin">';
_e('Administrators', 'wp-ada-compliance');
echo '</label> ';	
echo '</fieldset>';

}

	// background color
function  wp_ada_compliance_settings_background_color() {
$background_color = get_option('wp_ada_compliance_background_color','#ffffff');
echo '<p class="wp-ada-important">';
	_e('While checking for a contrast ratio of 4.5:1 between page text and the background color it is assumed that the background is set to white. Change this setting if the content area of your website uses a background color other than white. This setting does not apply to colors set in css files, rather only to text that is colored within the page editor.', 'wp-ada-compliance');
	echo '<br /><label for="wp_ada_compliance_background_color">';
_e('Content area background color:', 'wp-ada-compliance');	
echo '</label><br />';
	echo '<input type="text" size="25" name="wp_ada_compliance_background_color" id="wp_ada_compliance_background_color" value="'.esc_attr($background_color).'" />';
echo '</p>';
}

	// foreground color
function  wp_ada_compliance_settings_foreground_color() {
$foreground_color = get_option('wp_ada_compliance_foreground_color','#000000');
echo '<p class="wp-ada-important">';
	_e('While checking for a contrast ratio of 4.5:1 between page text and the background color it is assumed that the foreground is set to black. Change this setting if the content area of your website uses a foreground color other than black. This setting does not apply to colors set in css files, rather only to text that is colored within the page editor.', 'wp-ada-compliance');
	echo '<br /><label for="wp_ada_compliance_foreground_color">';
_e('Content area foreground color:', 'wp-ada-compliance');	
echo '</label><br />';
	echo '<input type="text" size="25" name="wp_ada_compliance_foreground_color" id="wp_ada_compliance_foreground_color" value="'.esc_attr($foreground_color).'" />';
echo '</p>';
}

// number of errors per page to display
function  wp_ada_compliance_settings_errors_per_page() {
$errors = get_option('wp_ada_compliance_errors_per_page','15');
echo '<p>';
	echo '<label for="wp_ada_compliance_errors_per_page">';
_e('Number of errors to display on report page: ', 'wp-ada-compliance');	
echo '</label>';
	echo '<br />';	
	echo '<input type="text" size="25" name="wp_ada_compliance_errors_per_page" id="wp_ada_compliance_errors_per_page" value="'.esc_attr($errors).'" />';
echo '</p>';
}

// language code
function  wp_ada_compliance_settings_language_code() {
$languagecode = get_option('wp_ada_compliance_language_code','en');
echo '<p class="wp-ada-important">';
	echo '<label for="wp_ada_compliance_language_code">';
_e('Primary language code for the website: ', 'wp-ada-compliance');	
echo '(<a href="https://www.w3schools.com/tags/ref_language_codes.asp">';
_e('Language Code Reference','wp-ada-compliance');
echo'</a>)';
echo '</label><br />';
	echo '<input type="text" size="25" name="wp_ada_compliance_language_code" id="wp_ada_compliance_language_code" value="'.esc_attr($languagecode).'" />';
echo '</p>';
}

	// skip link id
/*
function  wp_ada_compliance_settings_skip_link_id() {
$skip_link_id = get_option('wp_ada_compliance_skip_link_id','');
echo '<p class="wp-ada-important">';
	_e('Skip links are normally found in theme files and are required to allow screen reader users to bypass navigation links and go directly to the main content.', 'wp-ada-compliance');
	echo '<br /><label for="wp_ada_compliance_skip_link_id">';
_e('Enter the id of the element containing your main content and a skip link will be inserted at the top of your pages:', 'wp-ada-compliance');	
echo '</label>';
	echo '<input type="text" size="25" name="wp_ada_compliance_skip_link_id" id="wp_ada_compliance_skip_link_id" value="'.esc_attr($skip_link_id).'" />';
echo '</p>';
}*/

	// add additional skip links 
function  wp_ada_compliance_settings_skip_links() {
    
$skip_links = get_option('wp_ada_compliance_skip_links',array());
if(!is_array($skip_links)) $skip_links = array();
   
echo '<fieldset class="wp-ada-important"><legend>';
        echo '<h2>';
    	_e('Add Missing Skip Links ', 'wp-ada-compliance');
   echo '</h2>';
	_e('Skip links are normally found in theme files and are required to allow screen reader users to bypass navigation links. Each website should have at least one skip link labeled "Skip to main content". Define one or more skip links which will be automatically inserted into your pages. ', 'wp-ada-compliance');
    echo '<span style="font-weight:bold;">';
	_e('The primary skip link "skip to main content" should be entered first. ', 'wp-ada-compliance'); 
    echo '</span>';
        echo '<a href="https://www.alumnionlineservices.com/features/adding-skip-links-to-a-website/">';
    _e('View more detailed instructions for using this setting to add skip links.', 'wp-ada-compliance');
    echo '</a>';
    echo '</legend>';
echo '<br /><label for="wp_ada_compliance_skip_links_text_add" class="wp_ada_label_normal">';
_e('Link Text:', 'wp-ada-compliance');	
echo '</label> ';
echo '<input type="text" name="wp_ada_compliance_skip_links_text[]" id="wp_ada_compliance_skip_links_text_add" value="" />';
echo '<label for="wp_ada_compliance_skip_links_id_add" class="wp_ada_label_normal">';
_e('URL/ID: (i.e... #maincontent )', 'wp-ada-compliance');	
echo '</label> ';
echo '<input type="text" name="wp_ada_compliance_skip_links_id[]" id="wp_ada_compliance_skip_links_id_add" value="" />'; 
echo '<button type="button" class="wp_ada_compliance_skip_links_button" ><i class="fas fa-plus" aria-hidden="true"></i> Add Skip Link</button>';
echo '<span class="adaskip_linksavemessage">';
    _e('Don\'t forget to save your changes', 'wp-ada-compliance');	
echo '</span>';    
echo '</fieldset>';

echo '<fieldset class="wp-ada-important" ><legend style="padding-top: 20px;">';
_e('To remove a skip links,  remove the check mark next to the item in the list.', 'wp-ada-compliance');
echo '</legend>';	
	
 // display existing skip_links
    // move main skip link to top
//$skip_links = array_reverse($skip_links); 
foreach($skip_links as $key => $value){
if($value != ""){
echo '<input type="checkbox" size="65" name="wp_ada_compliance_skip_links[]" id="wp_ada_compliance_skip_links_id'.esc_attr($key).'"" value="'.esc_attr($value).'" checked />';	
echo '<label for="wp_ada_compliance_skip_links_id'.esc_attr($key).'" >'.esc_attr($value).'</label><br />';
}
}
echo '<span id="wp-ada-added-skip_links-field" ></span>';
echo '</fieldset>';	
}

	// add labels to wp forms
function  wp_ada_compliance_setting_add_wpform_labels() {

$wpformlabels = get_option('wp_ada_compliance_add_wpform_labels','true');	
echo '<fieldset>';
echo '<legend>';
_e('Add aria-labels to built in Wordpress comment and search forms.', 'wp-ada-compliance');	
echo '</legend>';
	echo '<br />';
	echo '<input type="radio" name="wp_ada_compliance_add_wpform_labels" id="wp_ada_compliance_add_wpform_labels_true" value="true" ';
if($wpformlabels == 'true') echo ' checked';
echo '><label for="wp_ada_compliance_add_wpform_labels_true">';
_e('Yes', 'wp-ada-compliance');
echo '</label> ';
	echo '<input type="radio" name="wp_ada_compliance_add_wpform_labels" id="wp_ada_compliance_add_wpform_labels_false" value="false" ';
if($wpformlabels == 'false') echo ' checked';
echo '><label for="wp_ada_compliance_add_wpform_labels_false">';
_e('No', 'wp-ada-compliance');
echo '</label> ';	
echo '</fieldset>';
    
}


	// add landmarks
function  wp_ada_compliance_settings_landmarks() {
$landmarks = get_option('wp_ada_compliance_landmarks',array());
if(!is_array($landmarks)) $landmarks = array();	
echo '<fieldset class="wp-ada-important"><legend>';
    echo '<h2>';
    	_e('Add or Correct Missing Landmarks and Labels ', 'wp-ada-compliance');
   echo '</h2>';
	_e('Landmarks provide a way to identify the organization and structure of a web page. The structural information conveyed visually to users should be represented programmatically in the markup using landmark roles. The number and type of landmarks that should be used varies but normally each page will have one header, one footer, one main, one search, and one or more navigation and complementary regions. When multiple regions of the same type exist each should include a unique label. When landmarks do not exist on your website or require unique labeling use this setting to define one or more landmarks which will be automatically inserted into your pages. Enter the role (i.e... navigation, banner, complementary, aside, contentinfo or search), ari-label, element/html tag an ID of the element to be modified in the form fields below and click "Add Landmark". To update a form, nav or search element that does not include an ID attribute enter a parent element and ID instead. ', 'wp-ada-compliance');
echo '<a href="https://www.alumnionlineservices.com/features/correcting-missing-or-incorrectly-labeled-landmarks/">';
    _e('Learn more about ARIA Landmarks and view detailed instructions on how to add or correct landmark labels using this setting.', 'wp-ada-compliance');
    echo '</a>';
    echo '</legend>';
echo '<br /><label for="wp_ada_compliance_landmarks_element_add" class="wp_ada_label_normal">';
_e('Element (i.e... div, nav, form):', 'wp-ada-compliance');	
echo '</label> ';
echo '<input type="text" size="5" name="wp_ada_compliance_landmarks_element[]" id="wp_ada_compliance_landmarks_element_add" value="" />';
echo '<label for="wp_ada_compliance_landmarks_id_add" class="wp_ada_label_normal">';
_e('Element ID:', 'wp-ada-compliance');	
echo '</label> ';
echo '<input type="text" size="5" name="wp_ada_compliance_landmarks_id[]" id="wp_ada_compliance_landmarks_id_add" value="" />'; 
echo '<label for="wp_ada_compliance_landmarks_role_add" class="wp_ada_label_normal">';
_e('Aria Role: ', 'wp-ada-compliance');	
echo '</label> ';
echo '<select name="wp_ada_compliance_landmarks_role[]" id="wp_ada_compliance_landmarks_role_add">
<option value="">role</option>
<option value="banner">banner</option>
<option value="complementary">complementary</option>
<option value="contentinfo">contentinfo</option>
<option value="form">form</option>
<option value="main">main</option>
<option value="navigation">navigation</option>
<option value="region">region</option>
<option value="search">search</option></select>'; 
echo '<label for="wp_ada_compliance_landmarks_label_add" class="wp_ada_label_normal">';
_e('Aria Label:  ', 'wp-ada-compliance');	
echo '</label> ';
echo '<input type="text" size="15" name="wp_ada_compliance_landmarks_label[]" id="wp_ada_compliance_landmarks_label_add" value="" />';     
echo '<button type="button" class="wp_ada_compliance_landmarks_button" ><i class="fas fa-plus" aria-hidden="true"></i> Add Landmark</button>';
echo '<br /><span class="adalandmarksavemessage">';
    _e('Don\'t forget to save your changes', 'wp-ada-compliance');	
echo '</span>';    
echo '</fieldset>';

echo '<fieldset class="wp-ada-important" ><legend style="padding-top: 20px;">';
_e('To remove a landmark,  remove the check mark next to the item in the list.', 'wp-ada-compliance');
echo '</legend>';	
	echo '<div id="wp-ada-added-landmark-field"></div>';
 // display existing landmarks
foreach($landmarks as $key => $value){
if($value != ""){
echo '<input type="checkbox" size="65" name="wp_ada_compliance_landmarks[]" id="wp_ada_compliance_landmarks_id'.esc_attr($key).'"" value="'.esc_attr($value).'" checked />';	
echo '<label for="wp_ada_compliance_landmarks_id'.esc_attr($key).'" >'.esc_attr($value).'</label><br />';
}
}

echo '</fieldset>';	

}

// include link column on full report
function  wp_ada_compliance_settings_report_include_link_column() {

$includeLinkColumn = get_option('wp_ada_compliance_report_include_link_column','false');

echo '<fieldset>';
echo '<legend>';
_e('Display the full URL of the affected page in a column on the full print report.', 'wp-ada-compliance');	
echo '</legend>';
	echo '<br />';
	echo '<input type="radio" name="wp_ada_compliance_report_include_link_column" id="wp_ada_compliance_report_include_link_column_true" value="true" ';
if($includeLinkColumn == 'true') echo ' checked';
echo '><label for="wp_ada_compliance_report_include_link_column_true">';
_e('Yes', 'wp-ada-compliance');
echo '</label> ';
	echo '<input type="radio" name="wp_ada_compliance_report_include_link_column" id="wp_ada_compliance_report_include_link_column_false" value="false" ';
if($includeLinkColumn == 'false') echo ' checked';
echo '><label for="wp_ada_compliance_report_include_link_column_false">';
_e('No', 'wp-ada-compliance');
echo '</label> ';	
echo '</fieldset>';

}

// modify tinymce color pallet
function  wp_ada_compliance_settings_tinymce_color_pallet() {

$tinymce_color_pallet = get_option('wp_ada_compliance_tinymce_color_pallet','true');

echo '<fieldset class="wp_ada_advanced">';
echo '<legend>';
_e('The default Wordpress text color picker, when enabled, includes many colors that when displayed over a white background are not ADA compliant. Enable this option to modify the default color pallet to include some alternative colors and to mark the colors that are not compliant.', 'wp-ada-compliance');	
echo '</legend>';
	echo '<br />';
	echo '<input type="radio" name="wp_ada_compliance_tinymce_color_pallet" id="wp_ada_compliance_tinymce_color_pallet_true" value="true" ';
if($tinymce_color_pallet == 'true') echo ' checked';
echo '><label for="wp_ada_compliance_tinymce_color_pallet_true">';
_e('Yes', 'wp-ada-compliance');
echo '</label> ';
	echo '<input type="radio" name="wp_ada_compliance_tinymce_color_pallet" id="wp_ada_compliance_tinymce_color_pallet_false" value="false" ';
if($tinymce_color_pallet == 'false') echo ' checked';
echo '><label for="wp_ada_compliance_tinymce_color_pallet_false">';
_e('No', 'wp-ada-compliance');
echo '</label> ';	
echo '</fieldset>';

}

// notification email address
function  wp_ada_compliance_settings_notification_email() {
wp_ada_compliance_set_notification_cron();	
$email = get_option('wp_ada_compliance_notification_email','');
echo '<p>';
	echo '<label for="wp_ada_compliance_notification_email">';
_e('Enter a comma seperated list of email addresses to receive email notices when new issues are identified:', 'wp-ada-compliance');	
echo '</label><br />';
	echo '<input type="text" size="65" name="wp_ada_compliance_notification_email" id="wp_ada_compliance_notification_email" value="'.esc_attr($email).'" />';
echo '</p>';
}

// send reminder when issues have not be resolved
function  wp_ada_compliance_settings_notification_send_reminders() {

$send_reminders = get_option('wp_ada_compliance_notification_send_reminders','true');

echo '<fieldset class="wp_ada_advanced">';
echo '<legend>';
_e('Send reminder notifications when unresolved issues exist on your website.', 'wp-ada-compliance');	
echo '</legend>';
	echo '<br />';
	echo '<input type="radio" name="wp_ada_compliance_notification_send_reminders" id="wp_ada_compliance_notification_send_reminders_true" value="true" ';
if($send_reminders == 'true') echo ' checked';
echo '><label for="wp_ada_compliance_notification_send_reminders_true">';
_e('Yes', 'wp-ada-compliance');
echo '</label> ';
	echo '<input type="radio" name="wp_ada_compliance_notification_send_reminders" id="wp_ada_compliance_notification_send_reminders_false" value="false" ';
if($send_reminders == 'false') echo ' checked';
echo '><label for="wp_ada_compliance_notification_send_reminders_false">';
_e('No', 'wp-ada-compliance');
echo '</label> ';	
echo '</fieldset>';

}

	// file size limit
function  wp_ada_compliance_settings_file_size_limit() {
$file_size_limit = get_option('wp_ada_compliance_file_size_limit','25');
	
echo '<p class="wp_ada_advanced">';
	echo '<label for="wp_ada_compliance_file_size_limit">';
_e('Set a file size limit for your website scans. Increasing the file size limit will allow larger files to be scanned. Scanning large files may exceed memory limits and result in scan failures. ', 'wp-ada-compliance');	
echo '</label>';
	echo '<input type="text" size="15" name="wp_ada_compliance_file_size_limit" id="wp_ada_compliance_file_size_limit" value="'.esc_attr($file_size_limit).'" />';
    _e('MB (default 25 MB) ', 'wp-ada-compliance');	
echo '</p>';
}
	
	// Post to scan during full scan 
function  wp_ada_compliance_settings_full_scan_post_count() {
$fullpostcount = get_option('wp_ada_compliance_full_scan_post_count','5');
$totalposts = wp_ada_compliance_count_total_scan_records(1);
	
echo '<p class="wp_ada_advanced">';
	echo '<label for="wp_ada_compliance_full_scan_post_count">';
_e('How many items of each type (posts, terms, widgets etc) should be scanned during each cycle:', 'wp-ada-compliance');	
echo '</label>';
	echo '<input type="text" size="15" name="wp_ada_compliance_full_scan_post_count" id="wp_ada_compliance_full_scan_post_count" value="'.esc_attr($fullpostcount).'" />';
	echo '<span class="adaAllGood"> '.esc_attr($totalposts);
	_e(' total items on your website. ', 'wp-ada-compliance');	
echo '</span></p>';
}

// text to include in read more links
function  wp_ada_compliance_settings_read_more_link_text() {
$readmoretext = get_option('wp_ada_compliance_read_more_link_text',' Read More &#187;');
echo '<p>';
	echo '<label for="wp_ada_compliance_read_more_link_text">';
_e('If modifying read more links set the text to be displayed in your read more links: ', 'wp-ada-compliance');
			echo '<span class="adaAllGood">';
_e(' (Read More &#187;)','wp-ada-compliance');	
echo '</span>';
echo '</label><br />';
	echo '<input type="text" size="65" name="wp_ada_compliance_read_more_link_text" id="wp_ada_compliance_read_more_link_text" value="'.esc_attr($readmoretext).'" />';
echo '</p>';
}

// strip autoplay
function  wp_ada_compliance_settings_strip_autoplay() {

$strip_autoplay = get_option('wp_ada_compliance_strip_autoplay','true');

echo '<fieldset>';
echo '<legend>';
_e('Remove auto play parameters from embedded audio and video content. (to exclude an element, add the class wp-ada-no-convert)', 'wp-ada-compliance');	
	echo '</legend>';
echo '<br />';
echo '<input type="radio" name="wp_ada_compliance_strip_autoplay" id="wp_ada_compliance_strip_autoplay_yes" value="true" ';
if($strip_autoplay == 'true') echo ' checked';
echo '><label for="wp_ada_compliance_strip_autoplay_yes">';
_e('Yes', 'wp-ada-compliance');
echo '</label> ';
echo '<input type="radio" name="wp_ada_compliance_strip_autoplay" id="wp_ada_compliance_strip_autoplay_no" value="false" ';
if($strip_autoplay == 'false') echo ' checked';
echo '><label for="wp_ada_compliance_strip_autoplay_no">';
_e('No', 'wp-ada-compliance');
echo '</label> ';	
echo '</fieldset>';
}

// modify read more links
function  wp_ada_compliance_settings_modify_readmore_links() {

$change_read_more = get_option('wp_ada_compliance_modify_readmore_links','true');

echo '<fieldset>';
echo '<legend>';
_e('Add aria-label attributes with post titles to Wordpress generated read more links.', 'wp-ada-compliance');	
		echo '<span class="adaAllGood">';
_e(' (i.e...aria-label="Read more about such and such.")','wp-ada-compliance');	
echo '</span>';
	echo '</legend>';
echo '<br />';
echo '<input type="radio" name="wp_ada_compliance_modify_readmore_links" id="wp_ada_compliance_modify_readmore_links_yes" value="true" ';
if($change_read_more == 'true') echo ' checked';
echo '><label for="wp_ada_compliance_modify_readmore_links_yes">';
_e('Yes', 'wp-ada-compliance');
echo '</label> ';
echo '<input type="radio" name="wp_ada_compliance_modify_readmore_links" id="wp_ada_compliance_modify_readmore_links_no" value="false" ';
if($change_read_more == 'false') echo ' checked';
echo '><label for="wp_ada_compliance_modify_readmore_links_no">';
_e('No', 'wp-ada-compliance');
echo '</label> ';	
echo '</fieldset>';


}	

// filter embed code to add title attributes
function  wp_ada_compliance_settings_edit_embed_code() {

$edit_embed_code = get_option('wp_ada_compliance_edit_embed_code','true');

echo '<fieldset>';
echo '<legend>';
_e('Add the title attribute to iframe tags that include known audio/video source urls (i.e.. youtube.com, hulu.com, .mp3, .mp4 etc.). This option will also convert urls used as link text in audio and video embed codes to a screen reader friendly equivalent. (i.e.. Video or Audio Player)<br />', 'wp-ada-compliance');	
echo '</legend>';	
echo '<br />';
	echo '<input type="radio" name="wp_ada_compliance_edit_embed_code" id="wp_ada_compliance_edit_embed_code_yes" value="true" ';
if($edit_embed_code == 'true') echo ' checked';
echo '><label for="wp_ada_compliance_edit_embed_code_yes">';
_e('Yes', 'wp-ada-compliance');
echo '</label> ';
echo '<input type="radio" name="wp_ada_compliance_edit_embed_code" id="wp_ada_compliance_edit_embed_code_no" value="false" ';
if($edit_embed_code == 'false') echo ' checked';
echo '><label for="wp_ada_compliance_edit_embed_code_no">';
_e('No', 'wp-ada-compliance');
echo '</label> ';	
echo '</fieldset>';


}	
	
// correct external document links
function  wp_ada_compliance_settings_correct_non_html_links() {

$correct_non_html_links = get_option('wp_ada_compliance_correct_non_html_links','titleonly');

echo '<fieldset class="wp_ada_advanced">';
echo '<legend>';
_e('PDF and other non HTML document types may contain accessibility issues or be opened in an external application creating confusion for users. This option will add a small icon or hover effect to the link. Indicate below how you would like these issues resolved.', 'wp-ada-compliance');
	echo '</legend>';
echo '<br />';
	echo '<input type="radio" name="wp_ada_compliance_correct_non_html_links" id="wp_ada_compliance_correct_non_html_links_iconandtitle" value="iconandtitle" ';
if($correct_non_html_links == 'iconandtitle') echo ' checked';
echo '><label for="wp_ada_compliance_correct_non_html_links_iconandtitle">';
_e('add small icon to the body of the link to indicate the file type', 'wp-ada-compliance');
echo '</label> ';
echo '<br />'; 
	echo '<input type="radio" name="wp_ada_compliance_correct_non_html_links" id="wp_ada_compliance_correct_non_html_links_titleonly" value="titleonly" ';
if($correct_non_html_links == 'titleonly') echo ' checked';
echo '><label for="wp_ada_compliance_correct_non_html_links_titleonly">';
_e('add hover effect to the link to display the file type', 'wp-ada-compliance');
echo '</label> ';
echo '<br />';      
	echo '<input type="radio" name="wp_ada_compliance_correct_non_html_links" id="wp_ada_compliance_correct_non_html_links_addtitle" value="addtitle" ';
if($correct_non_html_links == 'addtitle') echo ' checked';
echo '><label for="wp_ada_compliance_correct_non_html_links_addtitle">';
_e('add title attribute to link to display the file type', 'wp-ada-compliance');
echo '</label> ';
echo '<br />';    
echo '<input type="radio" name="wp_ada_compliance_correct_non_html_links" id="wp_ada_compliance_correct_non_html_links_no" value="false" ';
if($correct_non_html_links == 'false') echo ' checked';
echo '><label for="wp_ada_compliance_correct_non_html_links_no">';
_e('do not filter non html content links', 'wp-ada-compliance');
echo '</label> ';	
echo '</fieldset>';


}


// correct links to in page content
function  wp_ada_compliance_settings_correct_link_to_in_page_content() {

$correct_link_to_in_page_content = get_option('wp_ada_compliance_correct_link_to_in_page_content','titleonly');

echo '<fieldset class="wp_ada_advanced">';
echo '<legend>';
_e('Anchor tags that link to content in the same page can confuse some users and therefore should include a visual indicator. This can be done automatically by adding a small icon or hover effect to the link. Indicate below how you would like these issues resolved.', 'wp-ada-compliance');
	echo '</legend>';
echo '<br />';
	echo '<input type="radio" name="wp_ada_compliance_correct_link_to_in_page_content" id="wp_ada_compliance_correct_link_to_in_page_content_iconandtitle" value="iconandtitle" ';
if($correct_link_to_in_page_content == 'iconandtitle') echo ' checked';
echo '><label for="wp_ada_compliance_correct_link_to_in_page_content_iconandtitle">';
_e('add small icon to the body of the link', 'wp-ada-compliance');
echo '</label> ';
echo '<br />';  
	echo '<input type="radio" name="wp_ada_compliance_correct_link_to_in_page_content" id="wp_ada_compliance_correct_link_to_in_page_content_titleonly" value="titleonly" ';
if($correct_link_to_in_page_content == 'titleonly') echo ' checked';
echo '><label for="wp_ada_compliance_correct_link_to_in_page_content_titleonly">';
_e('add hover effect to the link', 'wp-ada-compliance');
echo '</label> ';
echo '<br />';    
echo '<input type="radio" name="wp_ada_compliance_correct_link_to_in_page_content" id="wp_ada_compliance_correct_link_to_in_page_content_no" value="false" ';
if($correct_link_to_in_page_content == 'false') echo ' checked';
echo '><label for="wp_ada_compliance_correct_link_to_in_page_content_no">';
_e('do not filter links', 'wp-ada-compliance');
echo '</label> ';	
echo '</fieldset>';


}


// chose auto scan options
function  wp_ada_compliance_settings_auto_scan_options() {
wp_ada_compliance_set_auto_scan_cron();
$auto_scan_options = get_option('wp_ada_compliance_auto_scan_options','false');
    
// don't run cron scan if password protected scans using wordpress login are enabled (Apache Basic Authentication Required)
if(wp_ada_compliance_check_pw_protected_login_status() == 2)   {
    $auto_scan_options = 'false';
    echo '<p class="wp-ada-important adaBoldText wp_ada_advanced">';
    _e('Cron scans on password protected websites must use Apache Basic Authentication', 'wp-ada-compliance');
    echo '</p>';
}

echo '<fieldset>';
echo '<legend>';
_e('Select the Wordpress cron frequency for conducting automatic scans of your website: (note Wordpress cron must be configured for this option to work)', 'wp-ada-compliance');	
echo '</legend>';
	echo '<br />';	
echo '<input type="radio" name="wp_ada_compliance_auto_scan_options" id="wp_ada_compliance_auto_scan_options_none" value="false" ';
if($auto_scan_options == 'false') echo ' checked';
echo '><label for="wp_ada_compliance_auto_scan_options_none">';
_e('disable automatic scans', 'wp-ada-compliance');
echo '</label> ';
echo '<br />';
	echo '<input type="radio" name="wp_ada_compliance_auto_scan_options" id="wp_ada_compliance_auto_scan_options_monthly" value="monthly" ';
if($auto_scan_options == 'monthly') echo ' checked';
echo '><label for="wp_ada_compliance_auto_scan_options_monthly">';
_e('monthly', 'wp-ada-compliance');
echo '</label> ';
echo '<br />';	
	echo '<input type="radio" name="wp_ada_compliance_auto_scan_options" id="wp_ada_compliance_auto_scan_options_weekly" value="weekly" ';
if($auto_scan_options == 'weekly') echo ' checked';
echo '><label for="wp_ada_compliance_auto_scan_options_weekly">';
_e('weekly', 'wp-ada-compliance');
echo '</label> ';
echo '<br />';
echo '<input type="radio" name="wp_ada_compliance_auto_scan_options" id="wp_ada_compliance_auto_scan_options_daily" value="daily" ';
if($auto_scan_options == 'daily') echo ' checked';
echo '><label for="wp_ada_compliance_auto_scan_options_daily">';
_e('daily', 'wp-ada-compliance');
echo '</label> ';
echo '<br />';
	echo '<input type="radio" name="wp_ada_compliance_auto_scan_options" id="wp_ada_compliance_auto_scan_options_twicedaily" value="twicedaily" ';
if($auto_scan_options == 'twicedaily') echo ' checked';
echo '><label for="wp_ada_compliance_auto_scan_options_twicedaily">';
_e('twice daily', 'wp-ada-compliance');
echo '</label> ';
echo '<br />';
	echo '<input type="radio" name="wp_ada_compliance_auto_scan_options" id="wp_ada_compliance_auto_scan_options_hourly" value="hourly" ';
if($auto_scan_options == 'hourly') echo ' checked';
echo '><label for="wp_ada_compliance_auto_scan_options_hourly">';
_e('hourly', 'wp-ada-compliance');
echo '</label> ';
	echo '<p>';	
_e('The following settings should be used to quickly get through a website scan and not for everyday use:', 'wp-ada-compliance');
echo '</p>';
	echo '<input type="radio" name="wp_ada_compliance_auto_scan_options" id="wp_ada_compliance_auto_scan_options_wpada30minutes" value="wpada30minutes" ';
if($auto_scan_options == 'wpada30minutes') echo ' checked';
echo '><label for="wp_ada_compliance_auto_scan_options_wpada30minutes">';
_e('every 30 minutes', 'wp-ada-compliance');
echo '</label> ';	
echo '<br />';	
echo '<input type="radio" name="wp_ada_compliance_auto_scan_options" id="wp_ada_compliance_auto_scan_options_wpada15minutes" value="wpada15minutes" ';
if($auto_scan_options == 'wpada15minutes') echo ' checked';
echo '><label for="wp_ada_compliance_auto_scan_options_wpada15minutes">';
_e('every 15 minutes', 'wp-ada-compliance');
echo '</label> ';	
echo '<br />';		
echo '<input type="radio" name="wp_ada_compliance_auto_scan_options" id="wp_ada_compliance_auto_scan_options_wpada5minutes" value="wpada5minutes" ';
if($auto_scan_options == 'wpada5minutes') echo ' checked';
echo '><label for="wp_ada_compliance_auto_scan_options_wpada5minutes">';
_e('every 5 minutes', 'wp-ada-compliance');
echo '</label> ';		
echo '</fieldset>';

}

	// Post to scan during cron scan 
function  wp_ada_compliance_settings_cron_scan_post_count() {
$cronpostcount = get_option('wp_ada_compliance_cron_scan_post_count','5');
$totalposts = wp_ada_compliance_count_total_scan_records(1);
	echo '<p class="adaBoldText wp_ada_advanced">';
_e('Lower this setting if you experience issues running automatic scans using Wordpress cron.', 'wp-ada-compliance');	
echo '</p>';	
	
echo '<p class="wp_ada_advanced">';
	echo '<label for="wp_ada_compliance_cron_scan_post_count">';
_e('How many items of each type (posts, terms, widgets etc) should be scanned each time a scan is executed using Wordpress cron:', 'wp-ada-compliance');	
echo '</label>';
	echo '<input type="text" size="15" name="wp_ada_compliance_cron_scan_post_count" id="wp_ada_compliance_cron_scan_post_count" value="'.esc_attr($cronpostcount).'" />';
	echo '<span class="adaAllGood"> '.esc_attr($totalposts);
	_e(' total items on your website. ', 'wp-ada-compliance');	
echo '</span></p>';
}

// notification frequency
function  wp_ada_compliance_settings_notification_frequency() {

$notification_frequency = get_option('wp_ada_compliance_notification_frequency','daily');

echo '<fieldset>';
echo '<legend>';
_e('Select the frequency to send email notifications:', 'wp-ada-compliance');	
echo '</legend>';
	
echo '<br />';
echo '<input type="radio" name="wp_ada_compliance_notification_frequency" id="wp_ada_compliance_notification_frequency_monthly" value="monthly" ';
if($notification_frequency == 'monthly') echo ' checked';
echo '><label for="wp_ada_compliance_notification_frequency_monthly">';
_e('monthly', 'wp-ada-compliance');
echo '</label> ';
	
echo '<br />';
echo '<input type="radio" name="wp_ada_compliance_notification_frequency" id="wp_ada_compliance_notification_frequency_weekly" value="weekly" ';
if($notification_frequency == 'weekly') echo ' checked';
echo '><label for="wp_ada_compliance_notification_frequency_weekly">';
_e('weekly', 'wp-ada-compliance');
echo '</label> ';	
echo '<br />';	
	echo '<input type="radio" name="wp_ada_compliance_notification_frequency" id="wp_ada_compliance_notification_frequency_daily" value="daily" ';
if($notification_frequency == 'daily') echo ' checked';
echo '><label for="wp_ada_compliance_notification_frequency_daily">';
_e('once per day', 'wp-ada-compliance');
echo '</label> ';
	echo '<br />';
	echo '<input type="radio" name="wp_ada_compliance_notification_frequency" id="wp_ada_compliance_notification_frequency_twicedaily" value="twicedaily" ';
if($notification_frequency == 'twicedaily') echo ' checked';
echo '><label for="wp_ada_compliance_notification_frequency_twicedaily">';
_e('twice daily', 'wp-ada-compliance');
echo '</label>';
echo '<br />';
	
	echo '<input type="radio" name="wp_ada_compliance_notification_frequency" id="wp_ada_compliance_notification_frequency_hourly" value="hourly" ';
if($notification_frequency == 'hourly') echo ' checked';
echo '><label for="wp_ada_compliance_notification_frequency_hourly">';
_e('hourly', 'wp-ada-compliance');
echo '</label> ';		
echo '</fieldset>';

}

// strip target attributes
function  wp_ada_compliance_settings_striptarget() {

$striptarget = get_option('wp_ada_compliance_striptarget','addcsshover');

echo '<fieldset class="wp_ada_advanced">';
echo '<legend>';
_e('Choose how to address links in content that are set to open a new window. (&lt;a href="#" target="_blank"&gt;'.__('Link Text', 'wp-ada-compliance').'&lt;/a&gt; or &lt;a href="link" onclick="window.open(\'#\')" &gt;Link Text&lt;/a&gt;)', 'wp-ada-compliance');
echo '</legend>';	
echo '<br />';

	echo '<input type="radio" name="wp_ada_compliance_striptarget" id="wp_ada_compliance_striptarget_remove" value="remove" ';
if($striptarget == 'remove') echo ' checked';
echo '><label for="wp_ada_compliance_striptarget_remove">';
_e('remove target attribute', 'wp-ada-compliance');
echo '</label> ';
		echo '<br />';
        	echo '<input type="radio" name="wp_ada_compliance_striptarget" id="wp_ada_compliance_striptarget_addtitle" value="addtitle" ';
if($striptarget == 'addtitle') echo ' checked';
echo '><label for="wp_ada_compliance_striptarget_addtitle">';
_e('add title attribute to links to display "opens in a new window" (<a href="#" title="'.__('opens in a new window', 'wp-ada-compliance').'">'.__('Link Text', 'wp-ada-compliance').'</a>)', 'wp-ada-compliance');
echo '</label> ';
		echo '<br />';	
echo '<input type="radio" name="wp_ada_compliance_striptarget" id="wp_ada_compliance_striptarget_addcsshover" value="addcsshover" ';
if($striptarget == 'addcsshover') echo ' checked';
echo '><label for="wp_ada_compliance_striptarget_addcsshover">';
_e('add hover effect to links to display notice "opens in a new window" (<a href="#" class="adaNewWindowInfo"><span class="wp_ada_hidden">'.__('opens in a new window', 'wp-ada-compliance').'</span>'.__('Link Text', 'wp-ada-compliance').'</a>)', 'wp-ada-compliance');
echo '</label> ';
	echo '<br />';	
echo '<input type="radio" name="wp_ada_compliance_striptarget" id="wp_ada_compliance_striptarget_append" value="append" ';
if($striptarget == 'append') echo ' checked';
echo '><label for="wp_ada_compliance_striptarget_append">';
_e('append (opens in a new window) to link text', 'wp-ada-compliance');
echo '</label> ';
	echo '<br />';	
echo '<input type="radio" name="wp_ada_compliance_striptarget" id="wp_ada_compliance_striptarget_addicon" value="addicon" ';
if($striptarget == 'addicon') echo ' checked';
echo '><label for="wp_ada_compliance_striptarget_addicon">';
_e('append a small icon <i class="fas fa-external-link-alt" aria-hidden="true"></i> to link text ', 'wp-ada-compliance');
echo '</label> ';
	echo '<br />';	
	echo '<input type="radio" name="wp_ada_compliance_striptarget" id="wp_ada_compliance_striptarget_false" value="false" ';
if($striptarget == 'false') echo ' checked';
echo '><label for="wp_ada_compliance_striptarget_false">';
_e('do not change', 'wp-ada-compliance');
echo '</label> ';
echo '</fieldset>';

}

// include attachments in check title scan
/*
function  wp_ada_compliance_settings_attachmenttitles() {

$attachmenttitles = get_option('wp_ada_compliance_attachmenttitles','false');

echo '<fieldset class="wp_ada_advanced">';
echo '<legend>';
_e('Include attachments when checking for duplicate or missing titles.', 'wp-ada-compliance');
				echo '<span class="adaAllGood">';
_e(' (Only necessary when your theme presents public facing attachment pages.)','wp-ada-compliance');	
echo '</span>';
echo '</legend>';	
echo '<br />';
	echo '<input type="radio" name="wp_ada_compliance_attachmenttitles" id="wp_ada_compliance_attachmenttitles_yes" value="true" ';
if($attachmenttitles == 'true') echo ' checked';
echo '><label for="wp_ada_compliance_attachmenttitles_yes">';
_e('Yes', 'wp-ada-compliance');
echo '</label> ';
echo '<input type="radio" name="wp_ada_compliance_attachmenttitles" id="wp_ada_compliance_attachmenttitles_no" value="false" ';
if($attachmenttitles == 'false') echo ' checked';
echo '><label for="wp_ada_compliance_attachmenttitles_no">';
_e('No', 'wp-ada-compliance');
echo '</label> ';
echo '</fieldset>';
}*/
// change justified text in content	
function  wp_ada_compliance_settings_changejustifiedtext() {

$changejustifiedtext = get_option('wp_ada_compliance_changejustifiedtext','left');

echo '<fieldset class="wp_ada_advanced">';
echo '<legend>';
_e('Many people with cognitive disabilities have trouble with blocks of text that are justified (aligned to both the left and the right margins). Convert justified text found in content:', 'wp-ada-compliance');
echo '</legend>';	
echo '<br />';	
	echo '<input type="radio" name="wp_ada_compliance_changejustifiedtext" id="wp_ada_compliance_changejustifiedtext_left" value="left" ';
if($changejustifiedtext == 'left') echo ' checked';
echo ' /><label for="wp_ada_compliance_changejustifiedtext_left">';
_e('align left', 'wp-ada-compliance');
echo '</label> ';
	echo '<br />';	
echo '<input type="radio" name="wp_ada_compliance_changejustifiedtext" id="wp_ada_compliance_changejustifiedtext_right" value="right" ';
if($changejustifiedtext == 'right') echo ' checked';
echo ' /><label for="wp_ada_compliance_changejustifiedtext_right">';
_e('align right', 'wp-ada-compliance');
echo '</label> ';
echo '<br />';	
	echo '<input type="radio" name="wp_ada_compliance_changejustifiedtext" id="wp_ada_compliance_changejustifiedtext_default" value="false" ';
if($changejustifiedtext == 'false') echo ' checked';
echo ' /><label for="wp_ada_compliance_changejustifiedtext_default">';
_e('do not change ', 'wp-ada-compliance');
echo '</label> ';
echo '</fieldset>';

}	
	
// display convert font size field
function  wp_ada_compliance_settings_changefontsize() {

$changefontsize = get_option('wp_ada_compliance_changefontsize','percent');

echo '<fieldset class="wp_ada_advanced">';
echo '<legend>';
_e('Convert absolute font sizes found in content to relative units (% or em):', 'wp-ada-compliance');
echo '</legend>';	
echo '<br />';	
	
	echo '<input type="radio" name="wp_ada_compliance_changefontsize" id="wp_ada_compliance_changefontsize_percent" value="percent" ';
if($changefontsize == 'percent') echo ' checked';
echo ' /><label for="wp_ada_compliance_changefontsize_percent">';
_e('%', 'wp-ada-compliance');
echo '</label> ';
	echo '<br />';	
echo '<input type="radio" name="wp_ada_compliance_changefontsize" id="wp_ada_compliance_changefontsize_ems" value="em" ';
if($changefontsize == 'em') echo ' checked';
echo ' /><label for="wp_ada_compliance_changefontsize_ems">';
_e('em', 'wp-ada-compliance');
echo '</label> ';
echo '<br />';	
	echo '<input type="radio" name="wp_ada_compliance_changefontsize" id="wp_ada_compliance_changefontsize_default" value="false" ';
if($changefontsize == 'false') echo ' checked';
echo ' /><label for="wp_ada_compliance_changefontsize_default">';
_e('do not change ', 'wp-ada-compliance');
echo '</label> ';
echo '</fieldset>';


}

// display strip redundant alt
function  wp_ada_compliance_settings_strip_redundant_alt_txt() {

$strip_redundant_alt_txt = get_option('wp_ada_compliance_strip_redundant_alt_txt','true');

echo '<fieldset class="wp_ada_advanced">';
echo '<legend>';
_e('Remove redundant alt text on images with captions, titles on images with alt text and links with title attributes. This includes alt text that is the same as the text included in an adjacent link or caption.', 'wp-ada-compliance');
	echo '</legend>';
echo '<br />';
	echo '<input type="radio" name="wp_ada_compliance_strip_redundant_alt_txt" id="wp_ada_compliance_strip_redundant_alt_txt_yes" value="true" ';
if($strip_redundant_alt_txt == 'true') echo ' checked';
echo '><label for="wp_ada_compliance_strip_redundant_alt_txt_yes">';
_e('Yes', 'wp-ada-compliance');
echo '</label> ';
echo '<input type="radio" name="wp_ada_compliance_strip_redundant_alt_txt" id="wp_ada_compliance_strip_redundant_alt_txt_no" value="false" ';
if($strip_redundant_alt_txt == 'false') echo ' checked';
echo '><label for="wp_ada_compliance_strip_redundant_alt_txt_no">';
_e('No', 'wp-ada-compliance');
echo '</label> ';
echo '</fieldset>';	
}

// scan widgets
function  wp_ada_compliance_settings_scan_widgets() {

$scan_widgets = get_option('wp_ada_compliance_scan_widgets','true');

echo '<fieldset class="wp_ada_advanced">';
echo '<legend>';
_e('Scan widget content:', 'wp-ada-compliance');
	echo '<br />';
echo "<strong>";
_e('Note:', 'wp-ada-compliance');
echo "</strong>";	
_e(' Do to a limitation in the Custom HTML widget this setting should always be enabled.', 'wp-ada-compliance');
echo '</legend>';	
echo '<br />';
	echo '<input type="radio" name="wp_ada_compliance_scan_widgets" id="wp_ada_compliance_scan_widgets_yes" value="true" ';
if($scan_widgets == 'true') echo ' checked';
echo '><label for="wp_ada_compliance_scan_widgets_yes">';
_e('Yes', 'wp-ada-compliance');
echo '</label> ';
echo '<input type="radio" name="wp_ada_compliance_scan_widgets" id="wp_ada_compliance_scan_widgets_no" value="false" ';
if($scan_widgets == 'false') echo ' checked';
echo '><label for="wp_ada_compliance_scan_widgets_no">';
_e('No', 'wp-ada-compliance');
echo '</label> ';
echo '</fieldset>';

	
}


/**********************************************
// get meta keys for selected post id
**********************************************/
function wp_ada_compliance_settings_metafields(){
global $wpdb;

wp_ada_compliance_purge_metafields();
$keystofilter = get_option('wp_ada_compliance_metafields',array('_thumbnail_id'));	

$post_types = get_option('wp_ada_compliance_posttypes',array('page','post'));	
$ignoredkeys = wp_ada_compliance_settings_ignored_keys();
echo '<fieldset class="wp_ada_advanced">';
echo '<legend>';	
_e('Choose the custom fields to be monitored: ', 'wp-ada-compliance');
echo '</legend>';	
	echo '<a href="#" id="selectAllCustomFields">';
_e('Toggle All','wp-ada-compliance');
echo '</a>';
echo '<br />';
echo '<p href="#" class="still_loading" ></p>';		


if(!is_array($post_types) or count($post_types) == 0) {
echo '<p class="adaAllGood">';
	_e('Select post types for scanning or create some custom fields to display custom field options.', 'wp-ada-compliance');
	echo '</p>';
echo '<div id="customfieldlist"></div>';	
return false;	
}
	
$attach_loc = array_search('attachment',$post_types);
unset($post_types["$attach_loc"]); 	
    
if(!is_array($post_types) or count($post_types) == 0) {
return false;	
}    
	
$how_many = count($post_types);
$placeholders = array_fill(0, $how_many, '%s');
$format = implode(', ', $placeholders);	
	
$how_many = count($ignoredkeys);
$placeholders = array_fill(0, $how_many, '%s');
$ignoredformat = implode(', ', $placeholders);
    
$ignoredkeys[] = '_oembed_%';
$ignoredkeys[] = 'jtheme_video_%';
$ignoredkeys[] = '_elementor_%';
$ignoredkeys[] = '_video%';
$ignoredkeys[] = '_oembed_%';
$ignoredkeys[] = '_wp_old_slug';
$ignoredkeys[] = '_cs_replacements';
$ignoredkeys[] = 'enclosure';
$ignoredkeys[] = '_wp_%';
$ignoredkeys[] = '_menu_%'; 
$ignoredkeys[] =  '_fl_%';
$ignoredkeys[] = '_et_%';
    $ignoredkeys[] = '_yoast_%';	
$query = 'SELECT meta_key, meta_value FROM '.$wpdb->prefix.'postmeta inner join '.$wpdb->prefix.'posts on '.$wpdb->prefix.'posts.ID = '.$wpdb->prefix.'postmeta.post_id where post_type in('.$format.') and meta_key not in('.$ignoredformat.') 
and meta_key NOT LIKE %s 
and meta_key NOT LIKE %s
and meta_key NOT LIKE %s
and meta_key NOT LIKE %s
and meta_key NOT LIKE %s
and meta_key NOT LIKE %s
and meta_key NOT LIKE %s
and meta_key NOT LIKE %s
and meta_key NOT LIKE %s
and meta_key NOT LIKE %s
and meta_key NOT LIKE %s
and meta_key NOT LIKE %s
and meta_key NOT LIKE %s
group by meta_key order by meta_id desc limit 1 offset 0';

$list = array_merge($post_types, $ignoredkeys);	

$results = $wpdb->get_results( $wpdb->prepare($query, $list), ARRAY_A );

if($results){	
echo '<div id="customfieldlist" class="wp-ada-important">';
foreach($results as $row){ 
if(substr($row['meta_value'], 0, 6 ) !== "field_"){
	   echo '<p class="ada_post_custom_fields"><label for="wp_ada_compliance_metafields_'.esc_attr($row['meta_key']).'"><input id="wp_ada_compliance_metafields_'.esc_attr($row['meta_key']).'" type="checkbox" name="wp_ada_compliance_metafields[]" class="customfields" value="'.esc_attr($row['meta_key']).'"';
	   if(is_array($keystofilter) and in_array($row['meta_key'], $keystofilter)) echo ' checked="checked"' ;
	   echo ' /> ';
    if($row['meta_key'] =='_thumbnail_id') echo __('Featured Image','wp-ada-compliance');
    else echo esc_attr($row['meta_key']);
    echo '</label></p>';
	$found = 1;
}
}

echo '</div>';
}
	echo '</fieldset>';

}

// filter database content
function  wp_ada_compliance_settings_filter_content() {

$wp_ada_compliance_filter_content = get_option('wp_ada_compliance_filter_content','true');
	
echo '<fieldset >';
echo '<legend>';
_e('Use this option to enable or disable filtering of website content. Additional settings in this section provide fine control over what issues are being filtered on your website. ', 'wp-ada-compliance');
echo '</legend>';	
echo '<br />';
	echo '<input type="radio" name="wp_ada_compliance_filter_content" id="wp_ada_compliance_filter_content_yes" value="true" ';
if($wp_ada_compliance_filter_content == 'true') echo ' checked';
echo '><label for="wp_ada_compliance_filter_content_yes">';
_e('enabled', 'wp-ada-compliance');
echo '</label> ';
echo '<input type="radio" name="wp_ada_compliance_filter_content" id="wp_ada_compliance_filter_content_no" value="false" ';
if($wp_ada_compliance_filter_content == 'false') echo ' checked';
echo '><label for="wp_ada_compliance_filter_content_no">';
_e('disabled', 'wp-ada-compliance');
echo '</label> ';
echo '</fieldset>';

}

// option to exclude paths from html link scans
function  wp_ada_compliance_settings_excluded_link_path() {
    
$excluded_link_path = get_option('wp_ada_compliance_excluded_link_path',array('paged=','/page/')); 
if(!is_array($excluded_link_path)) $excluded_link_path = array();	
// purge excluded paths	
wp_ada_compliance_purge_excluded_paths();
echo '<fieldset>';
echo '<legend>';
_e('To exclude a url path or sections of your website from link crawling and scanning enter a url path below and save your settings. Any url that includes the path will be ignored.', 'wp-ada-compliance');
echo '</legend>';	
echo '<br /><label for="wp_ada_compliance_excluded_link_path_add">';
_e('Path to be excluded: ', 'wp-ada-compliance');	
echo '</label><br />';
echo '<input type="text" size="45" name="wp_ada_compliance_excluded_link_path[]" id="wp_ada_compliance_excluded_link_path_add" value="" />';
echo '<button type="button" class="wp_ada_add_excluded_button" ><i class="fas fa-plus" aria-hidden="true"></i> Add Exclusion</button><br />';
echo '<p class="adasavemessage">';
    _e('Don\'t forget to save your changes. It may take a minute or so to update the link inventory when settings are saved.', 'wp-ada-compliance');	
echo '</p>';    
echo '</fieldset>';

echo '<fieldset><legend>';
_e('To remove an exclusion,  remove the check mark next to the item in the list.', 'wp-ada-compliance');
echo '</legend>';
	echo '<div id="wp-ada-added-field"></div>';
 // display existing exclusions
	foreach($excluded_link_path as $key => $value){
		if($value != ""){
echo '<input type="checkbox" size="45" name="wp_ada_compliance_excluded_link_path[]" id="wp_ada_compliance_excluded_link_path_id'.esc_attr($key).'"" value="'.esc_attr($value).'" checked />';	
echo '<label for="wp_ada_compliance_excluded_link_path_id'.esc_attr($key).'" >'.esc_attr($value).'</label>';
echo '<br />';
		}
	}

echo '</fieldset>';	

}

// option to exclude code blocks from scans
function  wp_ada_compliance_settings_ignore_code_blocks() {
    
$code_block_ids = get_option('wp_ada_compliance_ignore_code_blocks',array());
if(!is_array($code_block_ids)) $code_block_ids = array();	
    
echo '<fieldset>';
echo '<legend>';
_e('To exclude a block of code such as a large menu or slideshow of images from being scanned, include the id of the element that encloses the block of code. For example, if you have a code block that begins with &lt;div id="my-id"&gt; you would enter "my-id" to exclude all code inside this element.', 'wp-ada-compliance');
echo '</legend>';	
echo '<br /><label for="wp_ada_compliance_ignore_code_blocks_add">';
_e('Element ID ', 'wp-ada-compliance');	
echo '</label><br />';
echo '<input type="text" size="45" name="wp_ada_compliance_ignore_code_blocks[]" id="wp_ada_compliance_ignore_code_blocks_add" value="" />';
echo '<button type="button" class="wp_ada_add_excluded_code_blocks_button" ><i class="fas fa-plus" aria-hidden="true"></i> Add Exclusion</button><br />';
echo '<p class="adasavemessage2">';
    _e('Don\'t forget to save your changes.', 'wp-ada-compliance');	
echo '</p>';    
echo '</fieldset>';

echo '<fieldset><legend>';
_e('To remove an exclusion,  remove the check mark next to the item in the list.', 'wp-ada-compliance');
echo '</legend>';
	echo '<div id="wp-ada-added-field-code-blocks"></div>';
 // display existing exclusions
	foreach($code_block_ids as $key => $value){
		if($value != ""){
echo '<input type="checkbox" size="45" name="wp_ada_compliance_ignore_code_blocks[]" id="wp_ada_compliance_ignore_code_blocks_id'.esc_attr($key).'"" value="'.esc_attr($value).'" checked />';	
echo '<label for="wp_ada_compliance_ignore_code_blocks_id'.esc_attr($key).'" >'.esc_attr($value).'</label>';
echo '<br />';
		}
	}

echo '</fieldset>';	

}

// option to exclude pages from content filtering
function  wp_ada_compliance_settings_php_buffering_page_exclusions() {
$exclusions = get_option('wp_ada_compliance_php_buffering_page_exclusions',array());
if(!is_array($exclusions)) $exclusions = array();	
echo '<fieldset>';
echo '<legend>';
_e('To exclude a page or sections of your website from content filtering enter a slug below and save your settings. Any url that includes the slug will be ignored when filtering content.', 'wp-ada-compliance');
echo '</legend>';	
echo '<br /><label for="wp_ada_compliance_php_buffering_page_exclusions_add">';
_e('Slug to be excluded: ', 'wp-ada-compliance');	
echo '</label><br />';
echo '<input type="text" size="55" name="wp_ada_compliance_php_buffering_page_exclusions[]" id="wp_ada_compliance_php_buffering_page_exclusions_add" value="" />';
echo '<button type="button" class="wp_ada_add_excluded_slug_button" ><i class="fas fa-plus" aria-hidden="true"></i> Add Exclusion</button>';
echo '<span class="adasavemessage">';
    _e('Don\'t forget to save your changes', 'wp-ada-compliance');	
echo '</span>';    
echo '</fieldset>';

echo '<fieldset><legend>';
_e('To remove an exclusion,  remove the check mark next to the item in the list.', 'wp-ada-compliance');
echo '</legend>';	
	echo '<div id="wp-ada-added-slug-field"></div>';
 // display existing exclusions
	foreach($exclusions as $key => $value){
		if($value != ""){
		$title = get_the_title((int)$value);
echo '<input type="checkbox" size="65" name="wp_ada_compliance_php_buffering_page_exclusions[]" id="wp_ada_compliance_php_buffering_page_exclusions_id'.esc_attr($key).'"" value="'.esc_attr($value).'" checked />';	
echo '<label for="wp_ada_compliance_php_buffering_page_exclusions_id'.esc_attr($key).'" >'.esc_attr($value).'</label><br />';
		}
	}
echo '</fieldset>';	

}

// display strip tags field
function  wp_ada_compliance_settings_striptags() {

$striptags = get_option('wp_ada_compliance_striptags','true');

echo '<fieldset class="wp_ada_advanced">';
echo '<legend>';
_e('Remove empty tags when found in content: (h1-h5, &lt;a&gt; and &lt;table&gt;)', 'wp-ada-compliance');
echo '</legend>';	
echo '<br />';
	echo '<input type="radio" name="wp_ada_compliance_striptags" id="wp_ada_compliance_striptags_yes" value="true" ';
if($striptags == 'true') echo ' checked';
echo '><label for="wp_ada_compliance_striptags_yes">';
_e('Yes', 'wp-ada-compliance');
echo '</label> ';
echo '<input type="radio" name="wp_ada_compliance_striptags" id="wp_ada_compliance_striptags_no" value="false" ';
if($striptags == 'false') echo ' checked';
echo '><label for="wp_ada_compliance_striptags_no">';
_e('No', 'wp-ada-compliance');
echo '</label> ';
echo '</fieldset>';


}

// display convert font size field
function  wp_ada_compliance_settings_fontsize() {
    if ( ! function_exists( 'is_plugin_active' ) )
     require_once( ABSPATH . '/wp-admin/includes/fl-builder.php' );    
    
$fontsize = get_option('wp_ada_compliance_fontsize_selector','percent');

	if ( !is_plugin_active('tinymce-advanced/tinymce-advanced.php') ) {
	echo '<p class="wp_ada-compliance-recommended-plugins">';
		_e("The ", 'wp-ada-compliance');  
	echo '<a href="https://wordpress.org/plugins/tinymce-advanced/">';
	_e("TinyMCE Advanced plugin ", 'wp-ada-compliance'); 
	echo '</a>';
	_e(" is recommended to allow users to edit tables without switching to text view.", 'wp-ada-compliance'); 
	 echo '</p>';
  };
	
echo '<fieldset class="wp_ada_advanced">';
echo '<legend>';
_e('Convert font size selector to use relative units (% or em), if not present font size selector will be added:', 'wp-ada-compliance');
echo '</legend>';	
echo '<br />';	
	echo '<input type="radio" name="wp_ada_compliance_fontsize_selector" id="wp_ada_compliance_fontsize_selector_percent" value="percent" ';
if($fontsize == 'percent') echo ' checked';
echo '><label for="wp_ada_compliance_fontsize_selector_percent">';
_e('%', 'wp-ada-compliance');
echo '</label> ';
echo '<input type="radio" name="wp_ada_compliance_fontsize_selector" id="wp_ada_compliance_fontsize_selector_ems" value="em" ';
if($fontsize == 'em') echo ' checked';
echo '><label for="wp_ada_compliance_fontsize_selector_ems">';
_e('em', 'wp-ada-compliance');
echo '</label> ';
	echo '<input type="radio" name="wp_ada_compliance_fontsize_selector" id="wp_ada_compliance_fontsize_selector_default" value="default" ';
if($fontsize == 'default') echo ' checked';
echo '><label for="wp_ada_compliance_fontsize_selector_default">';
_e('default', 'wp-ada-compliance');
echo '</label> ';
echo '</fieldset>';


}


/**********************************************
// check ignored field keys
**********************************************/
function wp_ada_compliance_settings_ignored_keys(){

// custom fields to ignore
$adaIgnoredTypes = array();	
$adaIgnoredTypes[] = '_edit_last';
$adaIgnoredTypes[] = '_edit_lock';
$adaIgnoredTypes[] = '_wp_page_template';
$adaIgnoredTypes[] = 'enclosure';
$adaIgnoredTypes[] = '_elementor_data';    
    
    
return $adaIgnoredTypes;
}


// display post types  field
function  wp_ada_compliance_settings_posttypes() {

    
$checked = get_option('wp_ada_compliance_posttypes',array('page','post'));	
   
echo '<fieldset class="wp-ada-important">';
echo '<legend>';	
_e('Choose the post types and post type archives to be monitored:', 'wp-ada-compliance');
echo '</legend>';	
   echo '<label for="wp_ada_compliance_posttypes_attachment"><input id="wp_ada_compliance_posttypes_attachment" type="checkbox" name="wp_ada_compliance_posttypes[]" value="attachment"';
   if(is_array($checked) and in_array('attachment', $checked)) echo ' checked="checked"' ;
   echo ' /> ';
	_e('attachments - media library images and attachment pages with issues', 'wp-ada-compliance'); 
echo '	   </label><br>';
//global $wpdb;

// post types to ignore
$ignore_these_post_types = array();	
$ignore_these_post_types[] = 'acf-field';
$ignore_these_post_types[] = 'acf-field-group';	
$ignore_these_post_types[] = 'accordions';	
$ignore_these_post_types[] = 'component';	
$ignore_these_post_types[] = 'nav_menu_item';
$ignore_these_post_types[] = 'oembed_cache';
$ignore_these_post_types[] = 'wp_block';	

$post_type_list = array();
	// set default post types
$post_type_list[] = "post";
$post_type_list[] = "page";
    
$get_cpt_args = array(
    'public'   => true,
    '_builtin' => false
);
$post_types = get_post_types( $get_cpt_args, 'object' );
// changed from database check for post types to get_post_type, remove after next schedule release
//$results = $wpdb->get_results("SELECT distinct(post_type) FROM ".$wpdb->prefix."posts", ARRAY_A);	
	foreach($post_types as $key => $value){ 
	if(!in_array($key, $post_type_list )) $post_type_list[] = $key;
}
    // changed from database check for post types to get_post_type, remove after next schedule release
/*if($results){
foreach($results as $row){ 
	if(!in_array($row['post_type'], $post_type_list )) $post_type_list[] = $row['post_type'];
}
}*/
foreach ( $post_type_list as $post_type ) {
	if(post_type_supports( $post_type, 'editor' ) and !in_array($post_type, $ignore_these_post_types)){	
		
	   echo '<p class="ada_setting_options"><label for="wp_ada_compliance_posttypes_'.esc_attr($post_type).'"><input id="wp_ada_compliance_posttypes_'.esc_attr($post_type).'" type="checkbox" class="posttypeselector" name="wp_ada_compliance_posttypes[]" value="'.esc_attr($post_type).'"';
	   if(is_array($checked) and in_array($post_type, $checked)) echo ' checked="checked"' ;
	   echo ' /> '.esc_attr($post_type).'</label></p>';
	}
   }
echo '</fieldset>';
	

}

// display terms field
function  wp_ada_compliance_settings_terms() {
    
echo '<fieldset class="wp-ada-important">';
echo '<legend>';	
	_e('Choose the term or category content to be monitored:', 'wp-ada-compliance');
echo '</legend>';	
echo '<br />';

global $wpdb;

// terms to ignore
	$adaIgnoredTypes = array();
$adaIgnoredTypes[] = 'nav_menu';

$checked = get_option('wp_ada_compliance_terms',array('category'));

$term_list = array();
// set default term list
$term_list[] = 'category';

$table = $wpdb->prefix.'term_taxonomy';

$results = $wpdb->get_results("SELECT distinct(taxonomy) FROM $table", ARRAY_A);	
	
if($results){
foreach($results as $row){ 
	if(!in_array($row['taxonomy'], $term_list) and taxonomy_exists($row['taxonomy'])) $term_list[] = $row['taxonomy'];
}
}

foreach ( $term_list as $term ) {
if(!in_array($term, $adaIgnoredTypes)){
  echo '<p class="ada_setting_options"><label for="wp_ada_compliance_terms_'.esc_attr($term).'"><input id="wp_ada_compliance_terms_'.esc_attr($term).'" type="checkbox" name="wp_ada_compliance_terms[]" value="'.esc_attr($term).'"';
   if(is_array($checked) and in_array($term, $checked)) echo ' checked="checked"' ;
   echo ' /> '.esc_attr($term).'</label></p>';
}

}
echo '</fieldset>';
	
}
	
/************************************************
display ignored files
*************************************************/
function wp_ada_compliance_settings_ignored_files() {
    
//removed ignored post options when no longer in link table    
wp_ada_compliance_update_ignore_settings();  
    
echo '<fieldset>';
echo '<legend style="font-weight:bold;">';
_e('The following content is not being checked for issues. Uncheck items to remove them from the ignored list.', 'wp-ada-compliance');	
echo '</legend>';
	
$ignoredPosts = get_option('wp_ada_compliance_posts_to_ignore',array());	
$count = 1;
if(isset($ignoredPosts) and is_array($ignoredPosts) and count($ignoredPosts) > 0){	
foreach($ignoredPosts as $key => $value){	

if($count > 2) echo '<p class="wp-ada-hide-ignore">';
else echo '<p>';
	
echo '<input type="checkbox" name="wp_ada_compliance_posts_to_ignore[]" id="wp_ada_compliance_posts_to_ignore_'.esc_attr($key).'" value="'.esc_attr($value).'" checked="checked" >';	
	$parts = explode('|',$value);
	echo '<label for="wp_ada_compliance_posts_to_ignore_'.esc_attr($key).'">';
    
	if($parts[1] == 0) echo esc_attr($parts[2]);
    elseif($parts[0] == 'widget'){
        echo __('WIdget #','wp-ada-compliance').esc_attr($parts[1]);
    }
	elseif($parts[0] == 'term'){
		$term = get_term($parts[1], '',  ARRAY_A);
		if(is_array($term)) echo esc_attr($term['name']);
	}
    elseif($parts[0] == 'pdf' or $parts[0] == 'link' or $parts[0] == 'iframe' or $parts[0] == 'css' or $parts[2] == 'AuthorPage'){
      esc_url(wp_ada_compliance_link_get_link($parts[1]));  
    }
	else {
		echo esc_attr(get_the_title($parts[1]));
	}
	echo ' ('.esc_attr($parts[0]).')';
	echo '</label></p>';
	$count++;
}
} else {
	echo '<p>';
		_e('No content is being ignored.', 'wp-ada-compliance');
		echo '</p>';
	   }
echo '</fieldset>';	
}	


/************************************************
define scan rules
*************************************************/
function wp_ada_compliance_settings_scan_rule() {
global $wp_ada_compliance_def;

// update ignore rules
//wp_ada_compliance_update_scan_rule_ignore_options();
	// set default options
	wp_ada_compliance_set_scan_rule_options();
	
$scanoptions = get_option('wp_ada_compliance_scan_rules', array());
$ignore_rules = get_option('wp_ada_compliance_ignore_scan_rules', array());	
   echo ' <p class="wp-ada-help-title"> '.__('Scan Rules:', 'wp-ada-compliance').' </p>';     
echo '<fieldset>';
echo '<legend style="font-weight:bold;">';
_e('Choose the issues to look for while scanning content on your website.', 'wp-ada-compliance');	
echo '</legend>';
echo '<div class="adaReferenceReport">';
   echo '<p class="wp-ada-compliance-rule-selector">';
     _e('Select: ', 'wp-ada-compliance');
    echo '<a href="#" id="selectAllRules" aria-label="';
     _e('Select All', 'wp-ada-compliance');
    echo '">';
    _e('ALL', 'wp-ada-compliance');
    echo '</a>';
  
                echo ' | ';
        echo '<a href="#" id="unselectAllRules" aria-label="';
     _e('Unselect All', 'wp-ada-compliance');
    echo '">';
    _e('Unselect ALL', 'wp-ada-compliance');
    echo '</a>';
  
                echo ' | ';
        echo '<a href="#" id="selectAllARules" aria-label="';
     _e('Select All Level A Rules', 'wp-ada-compliance');
    echo '">';
    _e('Level A', 'wp-ada-compliance');
    echo '</a>';
        echo ' | ';
        echo '<a href="#" id="selectAllAARules" aria-label="';
     _e('Select All Level AA Rules', 'wp-ada-compliance');
    echo '">';
    _e('Level AA', 'wp-ada-compliance');
    echo '</a>';
       /*     echo ' | ';
        echo '<a href="#" id="selectAllAAARules" aria-label="';
     _e('Select All Level AAA Rules', 'wp-ada-compliance');
    echo '">';
    _e('Level AAA', 'wp-ada-compliance');
    echo '</a>';*/
                echo ' | ';
        echo '<a href="#" id="selectAllWarningRules" aria-label="';
     _e('Select Only Warnings', 'wp-ada-compliance');
    echo '">';
    _e('Warnings', 'wp-ada-compliance');
    echo '</a>';
                    echo ' | ';
        echo '<a href="#" id="selectAllAlertRules" aria-label="';
     _e('Select Only Alerts', 'wp-ada-compliance');
    echo '">';
    _e('Alerts', 'wp-ada-compliance');
    echo '</a>';
    echo '</p>';
echo '<p class="wp_ada_error_key">';
    		
		echo '<i class="fas fa-exclamation-circle" aria-hidden="true"></i> ';
		_e('ALERTS - issues that MAY BE corrected to improve web accessibility, enhance a user\'s experience or avoid the possibility of inaccessible content inadvertently being introduced into a website.','wp-ada-compliance');	
				echo '<br /><br />';
		echo '<i class="fas fa-ban" aria-hidden="true"></i> ';
		_e('WARNINGS - issues that MUST BE corrected to ensure compliance with Section 508 or WCAG 2.1 LEVEL A/AA Web Accessibility Standards and ensure content is accessible to users with disabilities. ','wp-ada-compliance');	

		echo '</p>';
   
if(is_array($wp_ada_compliance_def))
foreach ($wp_ada_compliance_def as $rows => $row){	
echo '<div class="adaReference">';	
echo '<input type="checkbox" class="wp_ada_scan_rules';
    if(strstr($row['Reference'], __('Level AA)','wp-ada-compliance'))) echo ' AARules';
    elseif(strstr($row['Reference'], __('Level A)','wp-ada-compliance'))) echo ' ARules';
    elseif(strstr($row['Reference'], __('Level AAA)','wp-ada-compliance'))) echo ' AAARules';
    if(strstr($row['DisplayError'], __('WARNING','wp-ada-compliance'))) echo ' WarningRules';
    if(strstr($row['DisplayError'], __('ALERT','wp-ada-compliance'))) echo ' AlertRules';
   
    echo '" name="wp_ada_compliance_scan_rules[]" id="wp_ada_compliance_scan_rules_'.esc_attr($rows).'" value="'.esc_attr($rows).'"';
if(!in_array($rows,$ignore_rules)) echo ' checked="checked"';
echo '>';	
	echo '<label for="wp_ada_compliance_scan_rules_'.esc_attr($rows).'">';
	if(strstr($row['DisplayError'], __('WARNING','wp-ada-compliance'))) echo '<i class="fas fa-ban" aria-hidden="true"></i>';
		elseif(strstr($row['DisplayError'], __('ALERT','wp-ada-compliance'))) echo '<i class="fas fa-exclamation-circle" aria-hidden="true"></i>';
   
	if(isset($row['Settings']) and $row['Settings'] != "") echo esc_html($row['Settings']);
	else echo esc_html($row['StoredError']);
	if($row['Reference'] != "") echo ' <a href="'.esc_url($row['ReferenceURL']).'" target="_blank" class="adaNewWindowInfo">'.esc_attr($row['Reference']).' <i class="fas fa-external-link-alt" aria-hidden="true"><span class="wp_ada_hidden">'.__('opens in a new window', 'wp-ada-compliance').'</span></i></a>';
	echo '</label>';
	echo '</div>';	
}
echo '</div>';
	echo '</fieldset>';

}

/**********************************************
CREATE MENU LINKS AND PAGES
**********************************************/
function wp_ada_compliance_admin_menu() {
	$settingsuser = get_option('wp_ada_compliance_settingsusers','manage_options');
	
	if($settingsuser == "") $settingsuser =	'manage_options';
   
	if(current_user_can('edit_pages')){ 
	// web accessibility heading link
	add_menu_page( __('WP ADA Compliance Report', 'wp-ada-compliance'), __('Web Accessibility','wp-ada-compliance'), 'edit_pages', 'ada_compliance/compliancereport.php', 'wp_ada_compliance_report_page', 'dashicons-media-document', 10 );
	
	// submenu links
	// error report link
	add_submenu_page('ada_compliance/compliancereport.php', __('Error Report', 'wp-ada-compliance'), __('Error Report','wp-ada-compliance'), 'edit_pages', 'ada_compliance/compliancereport.php', 'wp_ada_compliance_report_page' );
	
		// issue reference link
	add_submenu_page('ada_compliance/compliancereport.php', __('ADA Compliance Guidelines Reference', 'wp-ada-compliance'), __('Error References','wp-ada-compliance'), 'edit_pages', 'ada_compliance/compliancereferencereport.php', 'wp_ada_compliance_referencereport_page' );
		
			// issue reference manual link
	add_submenu_page('ada_compliance/compliancereport.php', __('ADA Compliance Guidelines Reference Manual Checks', 'wp-ada-compliance'), __('Manual Checks','wp-ada-compliance'), 'edit_pages', 'ada_compliance/compliancereferencereport.php&manual_checks', 'wp_ada_compliance_referencereport_page' );	
	
		//  settings link
	add_submenu_page('ada_compliance/compliancereport.php', __('Settings', 'wp-ada-compliance'), __('Settings','wp-ada-compliance'), esc_attr($settingsuser), 'wp-ada-compliance-admin', 'wp_ada_compliance_options_page' );	
	
	// send report page (hidden from menu)
	add_submenu_page(null, __('Send Report', 'wp-ada-compliance'), __('Send Report','wp-ada-compliance'), 'edit_pages', 'ada_compliance/send-report.php', 'wp_ada_compliance_send_report' );
		
			// print report page (hidden from menu)
	add_submenu_page(null, __('Print Report', 'wp-ada-compliance'), __('Print Report','wp-ada-compliance'), 'edit_pages', 'ada_compliance/print-report.php', 'wp_ada_compliance_print_report' );
	
	
	// export report page (hidden from menu)
	add_submenu_page(null, __('Export Report', 'wp-ada-compliance'), __('Export Report','wp-ada-compliance'), 'edit_pages', 'ada_compliance/export-report.php', 'wp_ada_compliance_export_report' );
        
        	// link report 
	add_submenu_page('ada_compliance/compliancereport.php', __('Link Inventory', 'wp-ada-compliance'), __('Link Inventory','wp-ada-compliance'), esc_attr($settingsuser), 'ada_compliance/links.php', 'wp_ada_compliance_link_report' );

	}
}
// webaim validation link and other external links
function wp_ada_compliance_add_external_link_admin_submenu() {
    global $submenu;
	
     $permalink = get_site_url().'/wp-admin/upload.php?mode=list&attachment-filter&m=0&accessibility-filter=viewall&attachment-filter=post_mime_type%3Aimage&filter_action=Filter';
    $submenu['ada_compliance/compliancereport.php'][] = array( __('Image Accessibility Issues','wp-ada-compliance'), 'edit_pages',  esc_url($permalink) );
    
	$enablewave = get_option('wp_ada_compliance_enablewave','true');
	
	if($enablewave == 'true'){
    $permalink = esc_url_raw('http://wave.webaim.org/report#/'.get_site_url()); 
    $submenu['ada_compliance/compliancereport.php'][] = array( __('Evaluate with WAVE','wp-ada-compliance'), 'edit_pages', esc_url($permalink) );
	}
	
	$permalink = 'https://www.access-board.gov/guidelines-and-standards/communications-and-it/about-the-ict-refresh/final-regulatory-impact-analysis#_Toc377046563';
    $submenu['ada_compliance/compliancereport.php'][] = array( __('Section 508 Reference','wp-ada-compliance'), 'edit_pages',  esc_url($permalink) );
	
	$permalink = 'https://www.w3.org/WAI/WCAG21/quickref/';
    $submenu['ada_compliance/compliancereport.php'][] = array( __('WCAG 2.1 Reference','wp-ada-compliance'), 'edit_pages',  esc_url($permalink) );
	
    $permalink = 'https://www.alumnionlineservices.com/docs/getting-started/will-the-wp-ada-compliance-plugin-make-my-website-completely-compliant/';
    $submenu['ada_compliance/compliancereport.php'][] = array( __('About this Plugin','wp-ada-compliance'), 'edit_pages',  esc_url($permalink) );

    
		$permalink = 'https://www.alumnionlineservices.com/docs/';
    $submenu['ada_compliance/compliancereport.php'][] = array( __('HELP','wp-ada-compliance'), 'edit_pages',  esc_url($permalink) );
    	
}
 
/************************************************************
// add network settings link to menu
**********************************************************/
function  wp_ada_compliance_admin_network_page() {
add_options_page(__('Web Accessibility Settings', 'wp-ada-compliance'), __('Web Accessibility Settings', 'wp-ada-compliance'),  'manage_options', 'wp-ada-compliance-network', 'wp_ada_compliance_network_options_page');
}
/************************************************************
// display the network options page
**********************************************************/
function  wp_ada_compliance_network_options_page() {

// process settings update	
if(isset($_POST['Submit']))	{
	
// process copysettings
if(isset($_POST['copysettings']) and is_multisite())	{
wp_ada_compliance_copy_settings();	

echo '<p class="notice notice-success is-dismissible">';
_e('Settings Saved', 'wp-ada-compliance');
	echo '</p>';
}else{
echo '<p class="notice notice-error is-dismissible">';
_e('You must check the box to confirm.', 'wp-ada-compliance');
	echo '</p>';	
}
}
$blog_title = get_bloginfo( 'name' );	
echo '<div class="wp-ada-compliance-network-settings">';
echo '<h1>';
_e('Web Accessibility Network Settings', 'wp-ada-compliance');	
echo '</h1>';
echo '<form action="" method="post" id="ada_compliance_options">';

echo '<p><label><input type="checkbox" name="copysettings" value="1" /> '.__('Copy settings from SITE ONE: ', 'wp-ada-compliance').'<strong>'.strtoupper($blog_title).'</strong>'.__(' to all other sites on the multi-site network.', 'wp-ada-compliance').'</label>';
	
echo '<input name="Submit" type="submit" value="';
_e('COPY SETTINGS', 'wp-ada-compliance');
echo '" /></p>
</form></div>';
}

/**********************************************
copy settings
**********************************************/
function wp_ada_compliance_copy_settings() {
	global $wpdb;
	
	$idtocopy = get_main_site_id();
	$exclude = array();
	$exclude[] = 'wp_ada_compliance_version';
	$exclude[] = 'wp_ada_compliance_posts_to_ignore';
	$exclude[] = 'wp_ada_compliance_php_buffering_page_exclusions';
	$exclude[] = 'wp_ada_compliance_license_key';
	$exclude[] = 'wp_ada_compliance_full_scan_completed';
    $exclude[] = 'wp_ada_compliance_posttypes';
    $exclude[] = 'wp_ada_compliance_terms';
    $exclude[] = 'wp_ada_compliance_excluded_link_path';
    $exclude[] = 'wp_ada_compliance_php_buffering_page_exclusions';

	
	foreach ( wp_load_alloptions() as $option => $value ) {
	if ( strpos( $option, 'wp_ada_compliance_' ) === 0 
		and !strstr( $option, 'wp_ada_compliance_pdf_') 
		and !strstr( $option, 'wp_ada_compliance_basic_')) {
		$options[$option] = $value;  
	} 
	}
	// Get all blogs in the network and set the options
        $blog_ids = $wpdb->get_col( "SELECT blog_id FROM $wpdb->blogs" );
		
        foreach ( $blog_ids as $blog_id ) {
		if(get_main_site_id() != $blog_id){
            switch_to_blog( $blog_id );
			foreach ( $options as $key => $value ) {
				if(!in_array($key,$exclude)) {
					if(is_serialized($value)) $value = unserialize($value);
					update_option($key, $value);
				}
			}
			
	// schedule scans
	wp_ada_compliance_set_auto_scan_cron();
			
	// schedule notifications
	$emailnotifications = get_option('wp_ada_compliance_notification_email','');
	$notification_frequency = get_option('wp_ada_compliance_notification_frequency','daily');
	if ($emailnotifications != "") {
	wp_clear_scheduled_hook('wp_ada_compliance_email_notification_hook');
	wp_schedule_event(time(), $notification_frequency, 'wp_ada_compliance_email_notification_hook');
	}
			
			restore_current_blog();
		}
}
}

/**********************************************
create network menu
**********************************************/
function wp_ada_compliance_network_menu() {
// web accessibility heading link
	add_menu_page( __('WP ADA Compliance Report', 'wp-ada-compliance'), __('Web Accessibility','wp-ada-compliance'), 'edit_pages', 'wp_ada_compliance/networksettings.php', 'wp_ada_compliance_network_options_page', 'dashicons-admin-generic', 10 );	
}

/************************************************************
// add settings link to menu
**********************************************************/
function  wp_ada_compliance_admin_add_page() {
$settingsuser = get_option('wp_ada_compliance_settingsusers','manage_options');	
add_options_page(__('Web Accessibility Settings', 'wp-ada-compliance'), __('Web Accessibility Settings', 'wp-ada-compliance'),  esc_attr($settingsuser), 'wp-ada-compliance-admin', 'wp_ada_compliance_options_page');
		
}
/************************************************************
// display the admin options page
**********************************************************/
function  wp_ada_compliance_options_page() {
	
    
	// reset data
	  if (isset($_GET[ 'purge' ])) {

		wp_ada_compliance_purge();
		  
		  wp_ada_compliance_admin_notices();
		 $_SERVER['REQUEST_URI'] = str_replace('&purge=1', '', $_SERVER['REQUEST_URI']);
          
              echo '<p class="notice notice-success">'; 
               _e('Report data was purged', 'wp-ada-compliance');
          echo '</p>';
	  }
	
		// reset settings
	  if (isset($_GET[ 'reset_settings' ])) {
		  wp_ada_compliance_reset_options();
	    $_SERVER['REQUEST_URI'] = str_replace('&reset_settings=1', '', $_SERVER['REQUEST_URI']);
          
                  echo '<p class="notice notice-success">'; 
               _e('Settings were reset to default', 'wp-ada-compliance');
          echo '</p>';
 		} 
	
	echo '<div class="wp-ada-compliance-settings-page">';
	echo  '<p>';
	echo '<a href="'.esc_url(get_site_url()).'/wp-admin/admin.php?page=ada_compliance/compliancereport.php" class="btnwpada btnwpada-primary"><i class="fas fa-file-alt" aria-hidden="true"></i> ';
	_e('View Report', 'wp-ada-compliance');
	echo '</a> ';
	// reset data
	echo '<a href="'.esc_url(get_site_url()).'/wp-admin/admin.php?page=wp-ada-compliance-admin&purge=1" onclick="return confirm(\'';
	_e('Are you sure you want to reset all error data?', 'wp-ada-compliance');
	echo '\')" onkeypress="return confirm(\'';
	_e('Are you sure you want to reset all error data?', 'wp-ada-compliance');
	echo '\')" class="btnwpada btnwpada-primary"><i class="fas fa-eraser" aria-hidden="true"></i> ';
	_e('Reset Report Data', 'wp-ada-compliance');
	echo '</a> ';
	// reset options
	echo '<a href="'.esc_url(get_site_url()).'/wp-admin/admin.php?page=wp-ada-compliance-admin&reset_settings=1" onclick="return confirm(\'';
	_e('Are you sure you want to reset plugin settings?', 'wp-ada-compliance');
	echo '\')" onkeypress="return confirm(\'';
	_e('Are you sure you want to reset plugin settings?', 'wp-ada-compliance');
	echo '\')" class="btnwpada btnwpada-primary"><i class="fas fa-cog" aria-hidden="true"></i> ';
	_e('Reset Settings', 'wp-ada-compliance');
	echo '</a> ';
	
	 echo '<a href="'.esc_url(get_site_url()).'/wp-admin/admin.php?page=ada_compliance/links.php" class="btnwpada btnwpada-primary">
    <i class="fas fa-link"></i> ';
    _e('Link Inventory','wp-ada-compliance');
    echo '</a>';

	echo ' <a href="#wp_ada_compliance_license" class="btnwpada btnwpada-primary wp_ada_compliance_license" aria-label="'.__('Show License Key Field','wp-ada-compliance').'"><i class="fas fa-key" aria-hidden="true"></i> '.__('License Key','wp-ada-compliance').'</a>';
	
    echo ' <a href="https://www.alumnionlineservices.com/docs/" class="btnwpada btnwpada-primary"><i class="fas fa-question-circle"></i> '.__('Help','wp-ada-compliance').'</a>';

	       
	echo '</p>';
	
	// display server issues
	wp_ada_compliance_check_server_requirements();
	
	// display license key
		$licensecode = get_option('wp_ada_compliance_license_key', "");
	echo '<div id="wp_ada_compliance_license" ';
	if($licensecode != "" and !isset($_REQUEST['wp_ada_compliance_license_key'])) echo 'style="display:none;"';
	echo '>';
    wp_ada_compliance_license_management_page();
	 echo '</div>';

echo '
<div>
<form action="options.php" method="post" id="ada_compliance_options">';

settings_fields('wp_ada_compliance_options');
wp_ada_compliance_do_settings_sections_tabs('wp_ada_compliance');

 echo '<input id="adasettsingsave" name="Submit" type="submit" value="';
_e('Save Changes', 'wp-ada-compliance');
   // echo '<input type="Submit" id="adasettsingsave" value="Save Changes" />';
echo '" />
</form></div>';
echo '<a id="adascrollbutton" aria-label="Top"><i class="fas fa-chevron-up"></i></a>';	
echo '</div>';

    // hide advanced options
/*$hide_advanced_options = get_option('wp_ada_compliance_hide_advanced_options','true');	
   if($hide_advanced_options == 'true') {
    echo '<style>.wp_ada_advanced{display:none;}</style>';   
   }  */  
}

/*****************************************************************
validate license
****************************************************************/
function wp_ada_compliance_make_validation_call($action, $license_key, $domaincheck = 0){
    global $wp_ada_compliance_make_script_host_url;

	// set default value
$activateanyway = 0;

// define version (first version number dated one year or more from current release)
$wp_ada_compliance_audit_plugin_version = '2.3.13';

// This is the secret key for API authentication. You configured it in the settings menu of the license manager plugin.
if(!defined('WP_ADA_LICENSE_SECRET_KEY'))	
define('WP_ADA_LICENSE_SECRET_KEY', '5a1db966ac33a9.44089185'); 
	
// This is the URL where API query request will be sent to. This should be the URL of the site where you have installed the main license manager plugin. Get this value from the integration help page.
if(!defined('WP_ADA_LICENSE_VALIDATION_URL'))		
define('WP_ADA_LICENSE_VALIDATION_URL', $wp_ada_compliance_make_script_host_url); 

// This is a value that will be recorded in the license manager data so you can identify licenses for this item/product.
if(!defined('WP_ADA_COMPLIANCE_CHECK'))		
define('WP_ADA_COMPLIANCE_CHECK', 'WP ADA Compliance Check'); 

// API query parameters
$api_params = array(
	'slm_action' => esc_attr($action),
	'secret_key' => WP_ADA_LICENSE_SECRET_KEY,
	'license_key' => esc_attr($license_key),
	'registered_domain' => esc_attr($_SERVER['SERVER_NAME']),
	'item_reference' => urlencode(WP_ADA_COMPLIANCE_CHECK),
);	

// allow staging and local server installs for testing without taking an allotted domain 
if(strstr($_SERVER['SERVER_NAME'],'127.0.0.1') or strstr($_SERVER['SERVER_NAME'],'localhost') or strstr($_SERVER['SERVER_NAME'],'staging.')) {
	$activateanyway = 1;
	if($action == 'slm_check') return 1; // return if installing on a test site
} 

// only check for non test server installations
if($activateanyway != 1){
  // Send query to the license manager server
	$query = add_query_arg($api_params, WP_ADA_LICENSE_VALIDATION_URL);
	$args = array('timeout'     => 10,'redirection' => 10,'sslverify'   => false,'user-agent' => 'WP ADA COMPLIANCE CRAWLER');
	$response = wp_remote_get($query, $args);
    
    // activate if server is down and error response is returned.
	$responsecode = wp_remote_retrieve_response_code( $response);
	// Check for error in the response
	if (is_wp_error($response)){
		$message = __('Unexpected Error! The query returned with an error.','wp-ada-compliance');
	}
   if($responsecode !='200') {
       $license_key = $license_key.'-MANUAL';
       
   }

	// License data.
	$license_data = json_decode(wp_remote_retrieve_body($response));
} // end check for test server install

		// make sure the correct product license is being validated first
        if($action == 'slm_check') {
           
            // check if domain has been removed from the license 
            // ADDED TO ALLOW REMOVAL OF DOMAINS FROM LICENSE AND AUTOMATICALLY DISABLE SOFTWARE
            // IF PROBLEMS OCCUR COMMENT OUT THE FOLLOWING
           if(isset($license_data) and $domaincheck == 1){
            $licensefound = 0; 
        
           foreach($license_data->registered_domains as $key => $value){
              
              foreach($value as $key2 => $value2){
              if($_SERVER['SERVER_NAME'] == $value2) $licensefound = 1;
              }
           }
           // failed domain check deactivate
            if($licensefound ==  0) return 0;
           }// END DOMAIN CHECK
          
		  // set license expiration date
		  if(isset($license_data) and isset($license_data->date_expiry) and $license_data->date_expiry != '') {  
			update_option('wp_ada_compliance_license_expire_date',sanitize_text_field($license_data->date_expiry));
			} 
 		
		 //  echo strtotime($license_data->date_expiry).' '.strtotime(get_option('wp_ada_compliance_license_expire_date')).' '.strtotime('-1 year');
		   // if installed version is greater than the authorized version and license is expired deactivate
		   if(get_option('wp_ada_compliance_license_expire_date','') !='' and get_option('wp_ada_compliance_version','') !=''){
			if (version_compare(get_option('wp_ada_compliance_version',''), $wp_ada_compliance_audit_plugin_version,'>')
			and strtotime(get_option('wp_ada_compliance_license_expire_date')) < strtotime('-1 year')) {
		   return 0;
			}
		 }
        
            // check if license is valid
	    if(isset($license_data->product_ref) 
		   and $license_data->product_ref == WP_ADA_COMPLIANCE_CHECK  
            and $license_data->status != 'blocked' and $license_data->status != 'expired' 
		   or(str_replace('-MANUAL', '', preg_match('/[[:alnum:]]{13}/',$license_key))
	   		and (strstr($license_key,'-MANUAL'))) 
	  ){
   
	    return 1;
        }
	    else return 0;
	}
	
	// if already activated on current domain process activation manually
	if(isset($license_data) and strstr($license_data->message," License key already in use on ")) $activateanyway = 1;

	if(((isset($license_data) and (isset($license_data->error_code) and $license_data->error_code == '40')) or $activateanyway == 1) and $action == "slm_activate"){ //validation successfull but domain already registered
		$message = '<p class="adaAllGood adaBoldText">';
		$message .= __('License key activated','wp-ada-compliance'); 
		$message .= '</p>';
	
		//Save the license key in the options table
		update_option('wp_ada_compliance_license_key', $license_key); 
		update_option('wp_ada_compliance_license_status_check',0);
               
	}
	elseif(isset($license_data) and $license_data->result == 'success'){//Success was returned for the license activation 
		
		$message = '<p class="adaAllGood adaBoldText">';
		$message .=  esc_html(sanitize_text_field($license_data->message));
		$message .= '</p>';
		if($action == "slm_activate"){	
		//Save the license key in the options table
		update_option('wp_ada_compliance_license_key', $license_key); 
		update_option('wp_ada_compliance_license_status_check',0);
  
		} elseif($action == "slm_deactivate"){
		//remove license key from options
		update_option('wp_ada_compliance_license_key', ''); 
		update_option('wp_ada_compliance_license_status_check',1);
        
		}
		if($action == 'slm_check') return 0;
	}
	else{
		//Show error to the user. Probably entered incorrect license key.
		$message = '<p class="adaRedText">';
		if(!isset($license_data) or $license_data->result == "") {
           
            //server can't be reached so save key
            if($action == "slm_activate"){	
            //Save the license key in the options table
            update_option('wp_ada_compliance_license_key', $license_key); 
            update_option('wp_ada_compliance_license_status_check',0);
            } elseif($action == "slm_deactivate"){
            //remove license key from options
            update_option('wp_ada_compliance_license_key', ''); 
            update_option('wp_ada_compliance_license_status_check',1);
            }
            
			//$message .= __('Unexpected Error! Your host may be blocking our validation server: ','wp-ada-compliance');
			//$message .= WP_ADA_LICENSE_VALIDATION_URL;
		} 
	 	else {
			$message .=  esc_html(sanitize_text_field($license_data->message));
		if(strstr($license_data->message,'Reached maximum allowable domains.'))
		  $message .= __(' If you are moving the plugin to a new website, deactivate the license key from the old website before attempting to activate it on a new website.','wp-ada-compliance');
		}
		$message .= '</p>';
		
		if($action == 'slm_check') return 0;
	}
	// process manual activation
	if($action == "slm_activate" 
	   and str_replace('-MANUAL', '', preg_match('/[[:alnum:]]{13}/',$license_key))
	   and (strstr($license_key,'-MANUAL')) 
	  ){
		$message = '<p class="adaAllGood adaBoldText">';
		$message .= __('Manual activation was processed','wp-ada-compliance');
		update_option('wp_ada_compliance_license_key', str_replace('-MANUAL', '',$license_key)); 
		$message .= '</p>';
	}
	elseif($action == "slm_deactivate" 
	   and str_replace('-MANUAL', '', preg_match('/[[:alnum:]]{13}/',$license_key))
	   and strstr($license_key,'-MANUAL') 
	  ){
			$message = '<p class="adaAllGood adaBoldText">';
		$message .= __('Manual deactivation was processed','wp-ada-compliance');
		update_option('wp_ada_compliance_license_key', ''); 
		update_option('wp_ada_compliance_license_status_check',1);
		$message .= '</p>';
	}

	return $message;
}

/****************************************************************
enforce license
****************************************************************/
function wp_ada_compliance_validateLicenseKey($domaincheck = 0){
global $wp_ada_compliance_make_script_host_url;

    
$licensecode = get_option('wp_ada_compliance_license_key', ""); 
$response_code = wp_ada_compliance_remote_retrieve_response_code($wp_ada_compliance_make_script_host_url.'?item_reference=1');	

    
if($response_code !='200'){
    if($response_code =='403') {
        $nextdate = wp_ada_compliance_get_next_staggered_date(1);
        update_option('wp_ada_compliance_license_check_date',$nextdate);
    }
    return 1;
}
elseif($licensecode == "") return 0; 
elseif(wp_ada_compliance_make_validation_call('slm_check', $licensecode, $domaincheck)) return 1;

return 0;

} 
/******************************************************************
get resonse code from server
****************************************************************/    
function wp_ada_compliance_remote_retrieve_response_code($url){
$url = esc_url_raw($url); 
$args = array('timeout'     => 10,'redirection' => 10,'sslverify'   => false,'user-agent' => 'WP ADA COMPLIANCE CRAWLER');
$response = wp_remote_get($url, $args);	
return wp_remote_retrieve_response_code( $response);	
}
/********************************************
// validate license key
*********************************************/
function wp_ada_compliance_license_management_page() {
    
    if(isset($_REQUEST['wp_ada_compliance_license_key']) and !preg_match("/^([[:alnum:]])+$/i",$_REQUEST['wp_ada_compliance_license_key'])){
        $message = '<p class="adaRedText">';
			$message .= __('License key is not alpha numeric.','wp-ada-compliance');
			$message .= '</p>';
    }else{
    /*** License activate button was clicked ***/
    if (isset($_REQUEST['activate_license'])) {
        $license_key = sanitize_text_field($_REQUEST['wp_ada_compliance_license_key']);
 		if(wp_ada_compliance_make_validation_call('slm_check', $license_key))
		$message = wp_ada_compliance_make_validation_call('slm_activate', $license_key);
		else {
			$message = '<p class="adaRedText">';
			$message .= __('License is no longer active or invalid for this product.','wp-ada-compliance');
			$message .= '</p>';
		}

    }

    /*** License activate button was clicked ***/
    if (isset($_REQUEST['deactivate_license']) ) {
        $license_key = $_REQUEST['wp_ada_compliance_license_key'];
        
		$message = wp_ada_compliance_make_validation_call('slm_deactivate', $license_key);
    }
    }

  
$licensecode = get_option('wp_ada_compliance_license_key', "");

?>
<form action="" method="post">
	<?php if(isset($message))  echo $message; ?>
	    <h2><?php _e('License Key','wp-ada-compliance'); ?></h2> 
	   <p><?php _e('Please enter the license key for this product to activate it.','wp-ada-compliance'); ?></p>
      <p class="activationfield wp-ada-important"> <label for="wp_ada_compliance_license_key"><?php _e('License Key','wp-ada-compliance'); ?></label>
             <input class="regular-text <?php if($licensecode== "") echo 'ada_compliance_missing_license'; ?>" type="password" id="wp_ada_compliance_license_key" name="wp_ada_compliance_license_key" placeholder="<?php _e('LICENSE KEY REQUIRED','wp-ada-compliance'); ?>"  value="<?php echo esc_attr($licensecode); ?>" autocomplete="on">
      
            <input type="submit" name="activate_license" value="<?php _e('Activate','wp-ada-compliance'); ?>" class="button-primary" />
            <input type="submit" name="deactivate_license" value="<?php _e('Deactivate','wp-ada-compliance'); ?>" class="button" />
        </p>
    </form>
    <?php
    
}
/*****************************************************
// set cron frequency for notifications
****************************************************/
function wp_ada_compliance_set_notification_cron() {
$notification_email = get_option('wp_ada_compliance_notification_email','');	
$notification_frequency = get_option('wp_ada_compliance_notification_frequency','daily');
$current_schedule = wp_get_schedule('wp_ada_compliance_email_notification_hook' ); 
if ($notification_email == ""){
// clear cron on uninstall	
wp_clear_scheduled_hook('wp_ada_compliance_email_notification_hook');		
}
elseif ($current_schedule !=  $notification_frequency) {
	wp_clear_scheduled_hook('wp_ada_compliance_email_notification_hook');	
  	wp_schedule_event( time(), $notification_frequency, 'wp_ada_compliance_email_notification_hook' );
}
}/*****************************************************
// set cron frequency for cron scans
****************************************************/
function wp_ada_compliance_set_auto_scan_cron() {
$auto_scan_options = get_option('wp_ada_compliance_auto_scan_options','false');
wp_clear_scheduled_hook('wp_ada_compliance_auto_scan_cron_hook');
	
if ($auto_scan_options != "false"){
  	wp_schedule_event( time()+(60*5), $auto_scan_options, 'wp_ada_compliance_auto_scan_cron_hook' );	
}

}
/********************************************************
check data in meta field to deteremine if it should be filtered
********************************************************/
function wp_ada_compliance_check_meta_value($key){
global $wpdb;

$query = 'SELECT meta_value FROM '.$wpdb->prefix.'postmeta where meta_key = %s and meta_value != %s limit 1';

$metakey_list = array();	
$results = $wpdb->get_results( $wpdb->prepare($query, $key, ''), ARRAY_A );

if($results){
foreach($results as $row){ 
	if(wp_ada_compliance_ignored_content($row['meta_value'])) return 1;
}
}else return 1;

return 0;
}
/***********************************************************
change default roll to edit settings
***********************************************************/
function wp_ada_compliance_set_role(){
$settingsuser = get_option('wp_ada_compliance_settingsusers','manage_options');	

if($settingsuser == "") return	'manage_options';
	
return	$settingsuser;
}

// display errors that are being automatically filtered
/*
function  wp_ada_compliance_settings_report_filtered_errors() {

$report_filtered_errors = get_option('wp_ada_compliance_report_filtered_errors','false');

echo '<fieldset class="wp_ada_advanced">';
echo '<legend>';
_e('Include issues that are being filtered/corrected automatically in the error report: ', 'wp-ada-compliance');
	echo '</legend>';
echo '<br />';
	echo '<input type="radio" name="wp_ada_compliance_report_filtered_errors" id="wp_ada_compliance_report_filtered_errors_yes" value="true" ';
if($report_filtered_errors == 'true') echo ' checked';
echo '><label for="wp_ada_compliance_report_filtered_errors_yes">';
_e('Yes - during scans and while editing content', 'wp-ada-compliance');
echo '</label> ';
	echo '<br />';
	echo '<input type="radio" name="wp_ada_compliance_report_filtered_errors" id="wp_ada_compliance_report_filtered_errors_scanonly" value="scanonly" ';
if($report_filtered_errors == 'scanonly') echo ' checked';
echo '><label for="wp_ada_compliance_report_filtered_errors_scanonly">';
_e('Yes - only during scans and not while editing content', 'wp-ada-compliance');
echo '</label> ';
	echo '<br />';
echo '<input type="radio" name="wp_ada_compliance_report_filtered_errors" id="wp_ada_compliance_report_filtered_errors_no" value="false" ';
if($report_filtered_errors == 'false') echo ' checked';
echo '><label for="wp_ada_compliance_report_filtered_errors_no">';
_e('No', 'wp-ada-compliance');
echo '</label> ';	
echo '</fieldset>';


}*/
/***********************************************************
register endpoints to dynamically update report page
***********************************************************/

add_action( 'rest_api_init', function () {
    
// run link inventory
register_rest_route( 'wp_ada_compliance/v1', '/linkinventory', array(
    'methods' => 'GET',
    'callback' => 'wp_ada_compliance_inventory_links_rest',
	'permission_callback' => function () {
			return current_user_can( 'edit_pages' );
		}
  ));
 
// register endpoint to get more custom fields on settings page
register_rest_route( 'wp_ada_compliance/v1', '/getcustomfields', array(
    'methods' => 'GET',
    'callback' => 'wp_ada_compliance_get_more_metafields_rest',
	'permission_callback' => function () {
return current_user_can('edit_pages');  
		}
  ));    
    
// register endpoint update post types on settings page
register_rest_route( 'wp_ada_compliance/v1', '/removeposttypes', array(
'methods' => 'GET',
'callback' => 'wp_ada_compliance_update_post_types_rest',
'permission_callback' => function () {
    return current_user_can('edit_pages');  
}
));     

// register endpoint to scan a document using jquery 
  register_rest_route( 'wp_ada_compliance/v1', '/startscan', array(
    'methods' => 'GET',
    'callback' => 'wp_ada_compliance_rest_start_scan',
	  'permission_callback' => function () {
			return current_user_can( 'edit_pages' );
		}

  ) );
} );


// register endpoint to rescan a document 
add_action( 'rest_api_init', function () {
  register_rest_route( 'wp_ada_compliance/v1', '/rescan', array(
    'methods' => 'GET',
    'callback' => 'wp_ada_compliance_rest_start_single_scan',
	  'permission_callback' => function () {
			return current_user_can( 'edit_pages' );
		}

  ) );

// register endpoint to update report upon return
  register_rest_route( 'wp_ada_compliance/v1', '/refreshreport', array(
    'methods' => 'GET',
    'callback' => 'wp_ada_compliance_refresh_report_page',
	  'permission_callback' => function () {
			return current_user_can( 'edit_pages' );
		}

  ) );


// register endpoints to update ignore status
  register_rest_route( 'wp_ada_compliance/v1', '/ignore', array(
    'methods' => 'GET',
    'callback' => 'wp_ada_compliance_ignore',
	  'permission_callback' => function () {
			return current_user_can( 'edit_pages' );
		}

  ) );
    

    
} );


// ignore documents
function wp_ada_compliance_ignore(){
	
	check_ajax_referer('wp_rest', '_wpnonce');
    
    wp_ada_compliance_validate_form_values();
	
	// ignore errors
	if(isset($_GET[ 'wpadaignore' ])){
	 
    $values = explode('_',sanitize_text_field($_GET[ 'wpadaignore' ])); 
    $values[1] = (int)$values[1];
    $values[2] = (int)$values[2];
        
	if($values[2] == 0) $setting = 1;
	if($values[2] == 1) $setting = 0;
        
    if(count($values) == 4 and $values[3] == 'period') $period = 1;
     else $period = '';   
	
	wp_ada_compliance_jquery_ignore_error($values[1], $setting, $period);
		
	
	return $values[1];
	}
	
	// ignore duplicate errors
	if(isset($_GET[ 'wpadaignoreall' ])){
	 $values = explode('-',sanitize_text_field($_GET[ 'wpadaignoreall' ]));   
        if($_GET[ 'wpadaignoreall' ] != ''){
    $values[1] = (int)$values[1];
	
	$current_ignre = wp_ada_compliance_ignore_status_check((int)$values[1]);
	if($current_ignre == 0) $setting = 1;
	if($current_ignre == 1) $setting = 0;
	
	wp_ada_compliance_jquery_ignore_all_error($values[1], $setting, $values[2]);
	
	
	return $values[2].'-'.$values[3];
        }
        return '';
	}
    
    //ignore related
    if(isset($_GET[ 'wpadaignorerelated' ])){
       $values = explode('_',sanitize_text_field($_GET[ 'wpadaignorerelated' ]));
    
    $values[1] = (int)$values[1];
    $values[2] = (int)$values[2];
	
	if($values[2] == 0) $setting = 1;
	if($values[2] == 1) $setting = 0;
	
	wp_ada_compliance_jquery_ignore_related_errors($values[1], $setting);
	
	return $values[1];  
    }
	
	// ignore files
	if(isset($_GET[ 'wpadaignorefile' ])){
	 $values = explode('|',sanitize_text_field($_GET[ 'wpadaignorefile' ]));
    if(count($values) != 5) return;
    $values[1] = (int)$values[1];
    $values[4] = (int)$values[4];
	
	wp_ada_compliance_ignore_post($values[1], $values[2], $values[3], $values[4]);
		
        // remove ignored posts errors
	    wp_ada_compliance_purge_ignored_content();		
		
	return $values[1].$values[2];
	}
	
	if ( isset( $_GET[ 'wpadaignorerule' ] )) {
        if($_GET[ 'wpadaignorerule' ] != ''){
		
		$values = explode('|',sanitize_text_field($_GET[ 'wpadaignorerule' ])); 
		
		wp_ada_compliance_ignore_scan_rule($values[2]);
		
			// remove ignored rule errors
	    wp_ada_compliance_purge_rules();
		
		return $values[2];
        } else return '';

	}	

}
/************************************************************
do tabbed sections
**************************************************************/

/** Replace the call to 'do_settings_sections()' with a call to this function */
function wp_ada_compliance_do_settings_sections_tabs($page){

    global $wp_settings_sections, $wp_settings_fields;

    if(!isset($wp_settings_sections[$page])) :
        return;
    endif;

    echo '<div id="abb-tabs">';
    echo '<ul>';

    foreach((array)$wp_settings_sections[$page] as $section) :

        if(!isset($section['title']))
            continue;

        printf('<li><a href="#%1$s">%2$s</a></li>',
            $section['id'],     /** %1$s - The ID of the tab */
            $section['title']   /** %2$s - The Title of the section */
        );

    endforeach;
    echo '</ul>';

    foreach((array)$wp_settings_sections[$page] as $section) :

        printf('<div id="%1$s">',
            $section['id']      /** %1$s - The ID of the tab */
        );

        if(!isset($section['title']))
            continue;

        if($section['callback'])
            call_user_func($section['callback'], $section);

        if(!isset($wp_settings_fields) || !isset($wp_settings_fields[$page]) || !isset($wp_settings_fields[$page][$section['id']]))
            continue;

        echo '<div class="form-table">';
        wp_ada_compliance_do_settings_fields($page, $section['id']);
        echo '</div>';

        echo '</div>';

    endforeach;
	
    echo '</div>';

}
/**********************************************************
display wordpress settinsg without table
***********************************************************/
function wp_ada_compliance_do_settings_fields( $page, $section ) {
    global $wp_settings_fields;
 
    if ( ! isset( $wp_settings_fields[ $page ][ $section ] ) ) {
        return;
    }
    $count = 0;
    $wp_ada_class = 'wp_ada_white';
    foreach ( (array) $wp_settings_fields[ $page ][ $section ] as $field ) {
        $class = '';
 
        if ( ! empty( $field['args']['class'] ) ) {
            $class = ' class="' . esc_attr( $field['args']['class'] ) .$wp_ada_class. '"';
        }else  $class = ' class="'.$wp_ada_class. '"';
 
        echo "<div{$class}>";
        
        call_user_func( $field['callback'], $field['args'] );
  
        if($count == 1){
            $count = 0;
            $wp_ada_class = 'wp_ada_white';  
        }else{
                $count++;
           $wp_ada_class = 'wp_ada_grey';
        }
        echo '</div>';
    }
}
/************************************************************************************************
 * Add a settings link to Plugins screen.
**********************************************************/
function wp_ada_compliance_plugin_action_links( $links ) {
	global $wp_ada_compliance_plugin_basename;
	$link = sprintf(
		'<a href="%s" >%s</a>',
		esc_url( admin_url( 'admin.php?page=wp-ada-compliance-admin' ) ),
		esc_html__( 'Settings', 'wp-ada-compliance' )
	);


	array_unshift( $links, $link );


	return $links;
}
add_filter( 'plugin_action_links_' . $wp_ada_compliance_plugin_basename, 'wp_ada_compliance_plugin_action_links' );

/**************************************************************
get mopre custom fields
*************************************************************/
function wp_ada_compliance_get_more_metafields_rest() {
global $wpdb;
    
check_ajax_referer('wp_rest', '_wpnonce');    
	
$keystofilter = get_option('wp_ada_compliance_metafields',array('_thumbnail_id'));
if(!is_array($keystofilter)) $keystofilter = array();	
	
$post_types = get_option('wp_ada_compliance_posttypes',array('page','post'));	
	
$ignoredkeys = wp_ada_compliance_settings_ignored_keys();
	
if(!is_array($post_types)) return false;
	
$attach_loc = array_search('attachment',$post_types);
unset($post_types["$attach_loc"]); 	
    
if(!is_array($post_types) or count($post_types) == 0) {
return false;	
}
	
$how_many = count($post_types);
$placeholders = array_fill(0, $how_many, '%s');
$format = implode(', ', $placeholders);	
	
$how_many = count($ignoredkeys);
$placeholders = array_fill(0, $how_many, '%s');
$ignoredformat = implode(', ', $placeholders);
    
$ignoredkeys[] = '_oembed_%';
$ignoredkeys[] = 'jtheme_video_%';
$ignoredkeys[] = '_elementor_%';
$ignoredkeys[] = '_video%';
$ignoredkeys[] = '_oembed_%';
$ignoredkeys[] = '_wp_old_slug';
$ignoredkeys[] = '_cs_replacements';
$ignoredkeys[] = 'enclosure';
$ignoredkeys[] = '_wp_%';
$ignoredkeys[] = '_menu_%'; 
$ignoredkeys[] =  '_fl_%';
$ignoredkeys[] = '_et_%';
    $ignoredkeys[] = '_yoast_%';
    
$query = 'SELECT meta_key, meta_value FROM '.$wpdb->prefix.'postmeta inner join '.$wpdb->prefix.'posts on '.$wpdb->prefix.'posts.ID = '.$wpdb->prefix.'postmeta.post_id where post_type in('.$format.') and meta_key not in('.$ignoredformat.') 
and meta_key NOT LIKE %s 
and meta_key NOT LIKE %s
and meta_key NOT LIKE %s
and meta_key NOT LIKE %s
and meta_key NOT LIKE %s
and meta_key NOT LIKE %s
and meta_key NOT LIKE %s
and meta_key NOT LIKE %s
and meta_key NOT LIKE %s
and meta_key NOT LIKE %s
and meta_key NOT LIKE %s
and meta_key NOT LIKE %s
and meta_key NOT LIKE %s
group by meta_key order by meta_id desc ';

$list = array_merge($post_types, $ignoredkeys);	

$results = $wpdb->get_results( $wpdb->prepare($query, $list), ARRAY_A );
$fields = '';
if($results){	
foreach($results as $row){ 
if(substr($row['meta_value'], 0, 6 ) !== "field_"){    
$fields .= '<p class="ada_post_custom_fields"><label for="wp_ada_compliance_metafields_'.esc_attr($row['meta_key']).'"><input id="wp_ada_compliance_metafields_'.esc_attr($row['meta_key']).'" type="checkbox" name="wp_ada_compliance_metafields[]" class="customfields" value="'.esc_attr($row['meta_key']).'"';

if(is_array($keystofilter) and in_array($row['meta_key'], $keystofilter)) $fields .= ' checked="checked"' ;
$fields .= ' /> ';
    if($row['meta_key'] =='_thumbnail_id') $fields .= __('Featured Image','wp-ada-compliance');
    else $fields .= esc_attr($row['meta_key']);
  $fields .= '</label></p>';
}
}
}
    return $fields;
}


/*************************************************
update post type list on settings using rest
***********************************************/
function wp_ada_compliance_update_post_types_rest(){
    
    check_ajax_referer('wp_rest', '_wpnonce'); 
    
   if(isset($_GET['post_type']) and isset($_GET['wpadaremove'])){

	$allposttypes = get_option('wp_ada_compliance_posttypes',array('page','post'));
	
	if(!is_array($allposttypes)) $allposttypes = array();
	
    wp_ada_compliance_validate_form_values(); 
    
	$posttype = sanitize_text_field($_GET['post_type']);
	
	if ($_GET['wpadaremove'] == 2){
	$key = array_search($posttype, $allposttypes);
    unset($allposttypes[$key]);
	//echo 'remove';
	}
	elseif(!in_array($posttype,$allposttypes)){
	$allposttypes[] = $posttype;
	//	echo 'add';
	}

	update_option( 'wp_ada_compliance_posttypes', $allposttypes);	
} 
}
?>