<?php 
/*
Plugin - WP ADA Compliance Check
functions to support misc features
*/
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;

/******************************	
check if string ends with a value
*******************************/
function wp_ada_compliance_endsWith($string, $endString) 
{ 
    $len = strlen($endString); 
    if ($len == 0) { 
        return true; 
    } 
    return (substr($string, -$len) === $endString); 
} 

/**************************************************
check deep scan support
**************************************************/
function wp_ada_compliance_check_deep_scan_support($url='', $scantype = ''){
$response_code = '';
    $filesize = '';
    
if($url == '')	$url = esc_url(get_site_url());   
    
// get args from login routine
$args = wp_ada_compliance_process_login($url);
    
$response = wp_remote_get($url, $args);	


if ( is_array( $response ) ) {
$header = $response['headers']; // array of http header lines
    

if($header['content-type'] == "") return;
elseif($scantype == 'pdf' and !strstr($header['content-type'],'application/pdf')){
 return;   
}
elseif($scantype != 'pdf' and !strstr($header['content-type'],'text/html') and !strstr($header['content-type'],'text/css')) {
return;
} 
else $filesize = $header['content-length'];	

$sizelimit = get_option('wp_ada_compliance_file_size_limit','25'); // 25 mb
if($filesize > ($sizelimit*1048576)) {
$response_code = 'FILE SIZE LIMIT EXCEEDED'; 
}
}
else return;

if($response_code != 'FILE SIZE LIMIT EXCEEDED')
$response_code = wp_remote_retrieve_response_code($response);

if($response_code == '200' or stristr($url,'gthjyduudk') or stristr($url,'010000000000000000000000000000'))	{
	
$content = wp_remote_retrieve_body($response);

if(is_wp_error($content)){
	//echo $content->get_error_message();
	//unsupported
	$_SESSION['wp_failure_on_deep_scan'] = __('One or more failures occured while trying to retrieve the content for a deep scan. Deep scan may not be supported on your website or your host may be blocking CURL commands. Error: ', 'wp-ada-compliance').sanitize_text_field($content->get_error_message());
	return 0;		
}
//supported
elseif($url != "") {

	return $content;
}
else return 1;
}
else {
    $filesize = sanitize_text_field($filesize);  
    $response_code = sanitize_text_field($response_code);
    wp_ada_compliance_update_link_status($url, $response_code, $filesize);
    return '';
}
}

/*******************************************************
check if url is valid
********************************************************/
function wp_ada_compliance_check_for_valid_url($url){
        
// get args from login routine
$args = wp_ada_compliance_process_login($url);
    
$response = wp_remote_get($url, $args);	

if ( is_array( $response ) ) {
$response_code = wp_remote_retrieve_response_code($response);
if($response_code == '200') return 1;
}
    
    return 0;
}
/*************************************************************
get the inner html of a DOM element
*************************************************************
function wp_ada_compliance_GETinnerHTML(\DOMElement $element)
{
    $doc = $element->ownerDocument;

    $html = '';

    foreach ($element->childNodes as $node) {
        $html .= $doc->saveHTML($node);
    }

    return $html;
}
/**************************************************
clear simpledom memory
**************************************************
function wp_ada_compliance_clean_all(&$items,$leave = ''){
    foreach($items as $id => $item){
        if($leave && ((!is_array($leave) && $id == $leave) || (is_array($leave) && in_array($id,$leave)))) continue;
        if($id != 'GLOBALS'){
            if(is_object($item) && ((get_class($item) == 'simple_html_dom') || (get_class($item) == 'simple_html_dom_node'))){
                $items[$id]->clear();
                unset($items[$id]);
            }else if(is_array($item)){
                $first = array_shift($item);
                if(is_object($first) && ((get_class($first) == 'simple_html_dom') || (get_class($first) == 'simple_html_dom_node'))){
                    unset($items[$id]);
                }
                unset($first);
            }
        }
    }
}

/**************************************************
count total records
**************************************************/
function wp_ada_compliance_count_total_scan_records(){

		// count number of records	and display message
		//$totalposts = wp_ada_compliance_count_post_records();
	
		// get total widgets
		 $totalwidgets = wp_ada_compliance_count_widget_records();
		
		// get total terms
		//$totalterms = wp_ada_compliance_count_term_records();

		// get theme page total
		//$totalthemes = wp_ada_compliance_count_theme_pages();
    
        		// get html total
		 $totalhtml = wp_ada_compliance_count_html_files();
		
		// total records to return for settings count
		//$totalrecords = ($totalhtml+$totalposts+$totalterms+$totalthemes+$totalwidgets);
    if($totalhtml == 0) $totalrecords = 0; 
    else $totalrecords = ($totalhtml+$totalwidgets);
	
	return  $totalrecords;
}
/**********************************************
// count html links
**********************************************/
function wp_ada_compliance_count_html_files(){
  global $wpdb;
    
    $query = 'SELECT id FROM '.$wpdb->prefix.'wp_ada_compliance_links where ignre = %d';

$wpdb->get_results( $wpdb->prepare($query, 0), ARRAY_A );

$rowcount = $wpdb->num_rows;
    
return $rowcount;
}

/**********************************************
// count widget records
**********************************************/
function wp_ada_compliance_count_widget_records(){

$scan_widgets = get_option('wp_ada_compliance_scan_widgets','true');
if($scan_widgets == 'false') return 0;	
	
$text_widgets = get_option( 'widget_text' );
$html_widgets = get_option( 'widget_custom_html' );	
	
if((isset($text_widgets) and is_array($text_widgets)) and (isset($html_widgets) and is_array($html_widgets)) )
$widgets = array_merge($text_widgets, $html_widgets);
elseif((isset($text_widgets) and is_array($text_widgets)))	$widgets = $text_widgets;
elseif((isset($html_widgets) and is_array($html_widgets))) $widgets = $html_widgets;

	if(is_array($widgets)) return sizeof($widgets);
	else return 0;

}
/**********************************************
// count theme pages
**********************************************/
function wp_ada_compliance_count_theme_pages(){
$theme_scan_items = get_option('wp_ada_compliance_scan_themes',array('Blog Home',"404 Page","Search Page"));
	if(is_array($theme_scan_items)) return count ($theme_scan_items);
	else return 0;
}
/**********************************************
// count term records
**********************************************/
function wp_ada_compliance_count_term_records(){
global $wpdb;
// get post types to be scanned
$terms = get_option('wp_ada_compliance_terms',array('category'));	

if(!is_array($terms)) return 0;

$how_many = count($terms);
$placeholders = array_fill(0, $how_many, '%s');
$format = implode(', ', $placeholders);
	
$query = 'SELECT * FROM '.$wpdb->prefix.'term_taxonomy inner join '.$wpdb->prefix.'terms ON  '.$wpdb->prefix.'term_taxonomy.term_id = '.$wpdb->prefix.'terms.term_id where taxonomy IN('.$format.')';

$wpdb->get_results( $wpdb->prepare( $query, $terms ), ARRAY_A );

$rowcount = $wpdb->num_rows;
	
return $rowcount;
}

/**********************************************
// count post records
**********************************************/
function wp_ada_compliance_count_post_records(){
global $wpdb;
// get post types to be scanned
$posttypes = get_option('wp_ada_compliance_posttypes',array('page','post'));

if(!is_array($posttypes)) return 0;

$how_many = count($posttypes);
$placeholders = array_fill(0, $how_many, '%s');
$format = implode(', ', $placeholders);

array_unshift($posttypes,"trash");
	array_unshift($posttypes,"auto-draft");
	array_unshift($posttypes,"draft");
	array_unshift($posttypes,"private");
	array_unshift($posttypes,"tao_sc_publish");
    array_unshift($posttypes,"cus_sc_publish");
array_unshift($posttypes,"revision");	
	
$query = 'SELECT * FROM '.$wpdb->prefix.'posts where post_type != %s and post_status NOT IN(%s, %s,%s, %s,%s,%s) and post_type IN('.$format.')';

$wpdb->get_results( $wpdb->prepare( $query, $posttypes ), ARRAY_A );

$rowcount = $wpdb->num_rows;
	
return $rowcount;
}

/*****************************************
// convert memory limit to bytes
*******************************************/
function wp_ada_compliance_return_bytes($val) {
    $val = trim($val);
    $last = strtolower($val[strlen($val)-1]);
    $val = (int)$val;
    switch($last) {
        // The 'G' modifier is available since PHP 5.1.0
         case 'g':
            $val *= 1024;
        case 'm':
           $val *= 1024;
        case 'k':
            $val *= 1024;
    }
    return $val;
}

/**************************************************
// handle errors during scans
**************************************************/
function wp_ada_compliance_fatalErrorHandler() {
# Getting last error
$error = error_get_last();
# Checking if last error is a fatal error
 if(isset($error['type']) and $error['type'] === E_ERROR) {
	$_SESSION['wp_failure_on_deep_scan'] = __('Scan was stopped do to a fatal error. Please note, some hosts are known to severely throttle resource usage which can result in scan failures (500 errors). Here is some additional information that may help you troubleshoot the problem. ERROR: ','wp-ada-compliance').$error['message'];	
	header('Location: '.esc_url_raw(get_site_url()).'/wp-admin/admin.php?page=ada_compliance%2Fcompliancereport.php');
	die();
    }
}
/**************************************************
// set max execution time and memory limit
**************************************************/
function wp_ada_compliance_set_php_ini_Settings($restart = 0) {
    
    if($restart == '1'){
        set_time_limit(300);
    }
    
    // set required php settings	
	if(ini_get('max_execution_time') < 300){
	ini_set('max_execution_time', 600); 
	}
    
    // pdf scans require more memory
    $scan_external_sources = get_option('wp_ada_compliance_scan_external_sources',array('iframe','linked')); 
    if(!is_array($scan_external_sources)) $scan_external_sources = array();
    if(wp_ada_compliance_return_bytes(ini_get('memory_limit')) < 734003200 and in_array('pdf',$scan_external_sources)) { 
        ini_set('memory_limit', '700M');
    }
    else if(wp_ada_compliance_return_bytes(ini_get('memory_limit')) < 536870912){
	ini_set('memory_limit', '512M');	
    }
}

?>