<?php
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;

/*********************************************
IMPORT RESOURCES
*******************************************/

// add simple dom support (need to over ride max file size, if clashes with another install of simple dom there the max file size will be dependednt upon that installation)
if(!defined('MAX_FILE_SIZE')) define('MAX_FILE_SIZE', 6000000);
if(!class_exists ('simple_html_dom'))
include_once(plugin_dir_path( __FILE__ ).'res/simplehtmldom/simple_html_dom.php');

// add other files
include(plugin_dir_path( __FILE__ ).'res/installation.php');
include(plugin_dir_path( __FILE__ ).'res/login_routine.php');
include(plugin_dir_path( __FILE__ ).'res/compliance_descriptions.php');
include(plugin_dir_path( __FILE__ ).'res/compliance_manual.php');
include(plugin_dir_path( __FILE__ ).'res/shared_functions.php'); 
include(plugin_dir_path( __FILE__ ).'res/dashboard.php');
include(plugin_dir_path( __FILE__ ).'res/settings.php'); 
include(plugin_dir_path( __FILE__ ).'res/errors.php'); 
include(plugin_dir_path( __FILE__ ).'res/notices.php');  
include(plugin_dir_path( __FILE__ ).'res/purgedata.php');
include(plugin_dir_path( __FILE__ ).'res/security.php');
include(plugin_dir_path( __FILE__ ).'res/wpsettings.php');
include(plugin_dir_path( __FILE__ ).'res/content_filters.php'); 
foreach ($wp_ada_compliance_def as $rows => $row){	
if(file_exists(plugin_dir_path( __FILE__ ).'res/rules/'.$rows.'.php'))
	include(plugin_dir_path( __FILE__ ).'res/rules/'.$rows.'.php'); 
}
include(plugin_dir_path( __FILE__ ).'res/content_validation.php'); 
include(plugin_dir_path( __FILE__ ).'res/reports.php'); 
include(plugin_dir_path( __FILE__ ).'res/sendmail.php');
include(plugin_dir_path( __FILE__ ).'res/content_external.php'); 
include(plugin_dir_path( __FILE__ ).'res/content_themes.php'); 
include(plugin_dir_path( __FILE__ ).'res/content_archives.php');
include(plugin_dir_path( __FILE__ ).'res/content_terms.php'); 
include(plugin_dir_path( __FILE__ ).'res/content_posts.php'); 
include(plugin_dir_path( __FILE__ ).'res/content_widgets.php'); 
include(plugin_dir_path( __FILE__ ).'res/vendor/persist-admin-notices-dismissal/persist-admin-notices-dismissal.php');
include(plugin_dir_path( __FILE__ ).'res/block-editor.php');
include(plugin_dir_path( __FILE__ ).'res/elementor_editor.php'); 
include(plugin_dir_path( __FILE__ ).'res/beaverbuilder_editor.php'); 
include(plugin_dir_path( __FILE__ ).'res/access_widget.php');


//deactivate basic version
add_action( 'admin_init', 'wp_ada_compliance_deactivate_basic_plugin' ); 

// backup for daily cron to check for updates and license
add_action( 'admin_init', 'wp_ada_compliance_daily_cron' ); 

// import admin css files and scripts
add_action( 'admin_enqueue_scripts', 'wp_ada_compliance_admin_scripts' ); 

// import public css files and scripts
add_action( 'wp_enqueue_scripts', 'wp_ada_compliance_public_scripts',99 ); 

// import public css files and scripts
add_action( 'wp_enqueue_scripts', 'wp_ada_compliance_optional_public_scripts',99 ); 

// add report link to publish meta box
//add_action('post_submitbox_misc_actions','wp_ada_compliance_add_publish_meta_options'); // works only in classic editor only
add_action( 'add_meta_boxes', 'wp_ada_compliance_report_meta_box' ); // works in gutenburg and classic editor

// create admin settings
add_action('admin_init', 'wp_ada_compliance_admin_init'); 

// monitor and process actions
add_action( 'wp_loaded', 'wp_ada_compliance_preprocessing' ); 

// deepscan on save
$wp_ada_compliance_deep_scan_on_editor = get_option('wp_ada_compliance_deep_scan_on_editor','true');
if($wp_ada_compliance_deep_scan_on_editor == 'true') {
add_filter( 'save_post', 'wp_ada_compliance_scan_ada_compliance_post_recheck_deep_scan', 100, 2 );
    add_filter( 'edit_attachment', 'wp_ada_compliance_scan_ada_compliance_post_recheck_deep_scan', 100, 2 );
    add_filter( 'edited_term', 'wp_ada_compliance_terms_recheck_deep_scan', 100, 3 ); 
}elseif($wp_ada_compliance_deep_scan_on_editor == 'false'){
    add_filter( 'edited_term', 'validate_ada_term_compliance', 100, 3 ); 
    add_filter( 'edit_attachment', 'wp_ada_compliance_validate_ada_post_compliance', 100, 2 );
   add_filter( 'save_post', 'wp_ada_compliance_validate_ada_post_compliance', 100, 3 );
}

if($wp_ada_compliance_deep_scan_on_editor != 'disabled'){
// validate pdf files upon uplod or save
add_filter( 'edit_attachment', 'wp_ada_compliance_validate_pdf_upload', 100, 2 ); 
    
// validate pdf files upon uplod or save
add_filter( 'add_attachment', 'wp_ada_compliance_validate_pdf_upload', 100, 2 );        
}

// add admin page to menu
add_action('admin_menu', 'wp_ada_compliance_admin_add_page'); 

// add network settings page
add_action('network_admin_menu','wp_ada_compliance_admin_network_page');
add_action('network_admin_menu','wp_ada_compliance_network_menu');

// add admin submenu links to menu
add_action( 'admin_menu', 'wp_ada_compliance_admin_menu' ); 

// add additional links to menu
add_action('admin_menu', 'wp_ada_compliance_add_external_link_admin_submenu'); 

// enforce content filter settings	

$wp_ada_compliance_filter_content = get_option('wp_ada_compliance_filter_content','true'); 
if($wp_ada_compliance_filter_content == 'true') {

// if not on admin side
if(!wp_ada_compliance_check_is_admin()){	

// filter content when displayed to correct theme
if(function_exists('finfo_open') and function_exists('ob_start') and function_exists('ob_end_flush')) {     
// filter unlinked anchors        
add_action('after_setup_theme', 'wp_ada_compliance_buffer_start', 99, 4);
add_action('shutdown', 'wp_ada_compliance_buffer_end', 99, 4);
}

// replace ambiguous anchor text in audio and video shortcode
add_filter( 'wp_video_shortcode', 'wp_ada_compliance_video_handler', 10, 5 ); 
add_filter( 'wp_audio_shortcode', 'wp_ada_compliance_audio_handler', 10, 5 ); 

// filters to remove titles from links 
//add_filter( 'wp_nav_menu', 'wp_ada_compliance_remove_title_attributes' );
//add_filter( 'wp_page_menu', 'wp_ada_compliance_remove_title_attributes' );
		
// modify read more links	
add_filter( 'the_content_more_link', 'wp_ada_compliance_modify_read_more_link', 99, 2 ); 
	
// modify read more links in excerpts	
add_filter('excerpt_more', 'wp_ada_compliance_new_excerpt_more', 99, 2); 	
	
} // end admin side check

// strip html from title before saving
add_filter( 'wp_insert_post_data', 'wp_ada_compliance_strip_html_from_title_when_saving', 99, 2 ); 	
	
// add title/aria-label field to tinymce
add_action( 'wp_enqueue_editor', 'wp_ada_compliance_add_aria_label_to_links', 20 ); 
	
// add format block to tinymce editor to apply classes
add_filter( 'tiny_mce_before_init', 'wp_ada_compliance_custom_styles',99,4); 	
	
// add title to iframe created from oembed
//add_filter('embed_oembed_html', 'wp_ada_compliance_embed_handler_html',99, 4); 		
	
} // end enforce filtering settings

// remove default image link from media library insert tool
add_action('admin_init', 'wp_ada_compliance_imagelink_setup', 10);
add_action( 'admin_head-post.php', 'wp_ada_compliance_reset_image_insert_settings' );
add_action( 'admin_head-post-new.php', 'wp_ada_compliance_reset_image_insert_settings' );

// make notices dismissable
add_action( 'admin_init', array( 'PAnD', 'init' ) ); 

// display messages / admin notices
add_action( 'admin_notices', 'wp_ada_compliance_admin_notices' ); 

//display shopping cart notice
add_action( 'admin_notices', 'wp_ada_compliance_plugin_admin_notice_shopping_cart' );

// modify tiny mce font size options
add_filter( 'tiny_mce_before_init', 'wp_ada_compliance_mce_text_sizes', 99, 4); 

// add format selector and font size option 
add_filter('mce_buttons_2', 'wp_ada_compliance_wp_editor_modify_tinymce', 99, 4); 

// remove tinymce options (justify)
add_filter('mce_buttons', 'wp_ada_compliance_wp_editor_modify_mce_buttons', 5000, 4);
add_filter('mce_buttons_2', 'wp_ada_compliance_wp_editor_modify_mce_buttons', 5000, 4);

// custom colors in tinymce
add_filter('tiny_mce_before_init', 'wp_ada_compliance_tinymce_color_options');

// custom colors in gutenberg
add_action( 'after_setup_theme', 'wp_ada_compliance_gutenberg_color_palette' );

// custom font sizes
add_action( 'after_setup_theme', 'wp_ada_compliance_gutenberg_text_sizes' );

// add editor styles to tiny mce
add_filter('mce_css', 'wp_ada_compliance_add_styles_to_editor');  

// check version and update update database as required
add_action('plugins_loaded', 'wp_ada_compliance_check_version'); 

// hook to process email notifications
add_action( 'wp_ada_compliance_email_notification_hook', 'wp_ada_compliance_send_email_notifications' ); 

// these dont work consistently so I changed to update on page load
// if email changes, update cron settings
//add_action( 'update_option_wp_ada_compliance_notification_email', 'wp_ada_compliance_set_notification_cron', 10, 2 ); 

// if frequency changes, update cron settings
//add_action( 'update_option_wp_ada_compliance_notification_frequency', 'wp_ada_compliance_set_notification_cron', 10, 2 ); 

// auto scan option changes, update cron settings
//add_action( 'update_option_wp_ada_compliance_auto_scan_options', 'wp_ada_compliance_set_auto_scan_cron', 10, 2 ); 

 // if scan rules change, update ignore settings
add_action( 'update_option_wp_ada_compliance_ignore_scan_rules', 'wp_ada_compliance_set_scan_rule_options', 10, 2 );

// purge if ignore rule changed
add_action( 'update_option_wp_ada_compliance_scan_rules', 'wp_ada_compliance_purge_rules', 10, 2 ); 

 // if widget settings are updated purge records
add_action( 'update_option_wp_ada_compliance_scan_widgets', 'wp_ada_compliance_purge_widgets', 10, 2 );

 // if auto correct tracking is turned off purge records
add_action( 'update_option_wp_ada_compliance_report_filtered_errors', 'wp_ada_compliance_purge_autocorrect_errors', 10, 2 );

// if scan excerpts is updated purge records
add_action( 'update_option_wp_ada_compliance_scan_excerpts', 'wp_ada_compliance_purge_excerpts', 10, 2 ); 

// purge excluded file paths
add_action( 'update_option_wp_ada_compliance_excluded_link_path', 'wp_ada_compliance_purge_excluded_paths', 10, 2 ); 

// purge external domains
add_action( 'update_option_wp_ada_compliance_scan_external_domains', 'wp_ada_compliance_purge_external_domains', 10, 2 ); 

// purge deep scan records
//add_action( 'update_option_wp_ada_compliance_deep_scan', 'wp_ada_compliance_purge_deep_scan_records', 10, 2 ); 

// purge external sources
add_action( 'update_option_wp_ada_compliance_scan_external_sources', 'wp_ada_compliance_purge_external_src', 10, 2 ); 

// purge ignored posts
add_action( 'update_option_wp_ada_compliance_posts_to_ignore', 'wp_ada_compliance_purge_ignored_content', 10, 2 ); 

// purge post type records not monitored
add_action( 'update_option_wp_ada_compliance_posttypes', 'wp_ada_compliance_purge_post_types', 10, 2 ); 

// purge term records not monitored
add_action( 'update_option_wp_ada_compliance_terms', 'wp_ada_compliance_purge_terms', 10, 2 ); 

// purge theme records not monitored
add_action( 'update_option_wp_ada_compliance_scan_themes', 'wp_ada_compliance_purge_theme_scan_item', 10, 2 ); 

// start auto scan
add_action( 'wp_ada_compliance_auto_scan_cron_hook', 'wp_ada_compliance_start_scan', 10, 2 ); 

// daily cron for license check
add_action( 'wp_ada_compliance_daily_cron_hook', 'wp_ada_compliance_daily_cron', 10, 2 ); 

// add new cron intervals
add_filter( 'cron_schedules', 'wp_ada_compliance_cron_intervals'); 

 // add dashboard widget with stats
add_action('wp_dashboard_setup', 'wp_ada_compliance_dashboard_widgets');

// set capability for settings page
add_filter( "option_page_capability_wp_ada_compliance_options", 'wp_ada_compliance_set_role' ); 

// add admin body class for jquery and iframe
add_filter( 'admin_body_class','wp_ada_compliance_add_body_classes' );

// delete error and link records when attachment is deleted
add_action( 'delete_attachment', 'wp_ada_compliance_purge_trashed_attachment_links', 10, 1 );

// delete error and link records when term is deleted
add_action( 'delete_term', 'wp_ada_compliance_remove_deleted_terms', 10, 4 );

// delete erorr and link records when status changes to draft or trash
add_action(  'transition_post_status',  'wp_ada_compliance_delete_draft_posts', 10, 3 );

// delete error when post is permanently deleted
add_filter( 'pre_delete_post', 'wp_ada_compliance_delete_post', 10, 3 ); 

// add scan link to post and page list
add_filter('post_row_actions', 'wp_ada_compliance_add_post_editor_link', 99, 2);
add_filter('page_row_actions', 'wp_ada_compliance_add_post_editor_link', 10, 2);
add_filter('media_row_actions', 'wp_ada_compliance_add_post_editor_link', 10, 2);

// set wordpress option when importing content to disable scans during import
add_action('import_start', 'wp_ada_compliance_start_import'); 
add_action('import_end', 'wp_ada_compliance_end_import'); 


// hide web accessibility widget on login page
//add_action('login_head', 'wp_ada_compliance_hide_accessibility_widget_on_login');
/*function wp_ada_compliance_hide_accessibility_widget_on_login() {
echo '<style>
 .wp-ada-compliance-accessibility-widget{
  display:none;   
 }
</style>';
}*/



/************************************************
manage requests and start processes
************************************************/
function wp_ada_compliance_preprocessing() {    
        if(isset($_SERVER['HTTP_USER_AGENT']) and $_SERVER['HTTP_USER_AGENT'] == 'WP ADA COMPLIANCE CRAWLER' ){
                    // disable wordpress redirects of changed urls
         remove_action('template_redirect', 'redirect_canonical');
    }
    
	// load thick box and max execution adjustments
	if(is_admin() 
	   and (strstr($_SERVER['REQUEST_URI'],'admin.php?page=ada_compliance') or
		   strstr($_SERVER['REQUEST_URI'],'admin.php?page=wp-ada-compliance-admin') or
	  		strstr($_SERVER['REQUEST_URI'],'/wp-admin/post.php') or
            strstr($_SERVER['REQUEST_URI'],'edit-tags.php') or
	   		strstr($_SERVER['REQUEST_URI'],'/wp-admin/term.php'))
		   ){
    
        // ensure import monitoring is disabled
        wp_ada_compliance_end_import(); 
		
// set required php settings	
wp_ada_compliance_set_php_ini_Settings();        
	
            // start sessions to display messages
    if ( !session_id() ) session_start();   
        
        	// include thick box
	add_thickbox();	

	}
	
	if(is_admin() and strstr($_SERVER['REQUEST_URI'],'admin.php?page=ada_compliance')){

		// check demo mode
	if(isset($_GET['startscan'])){
		
	if(wp_ada_compliance_checkdemo_date()) {
	$_SESSION['my_ada_notices'] = __('Invalid License Key Found!','wp-ada-compliance');	
	$_SESSION['my_ada_notices'] .= '<a href="'.esc_url(get_site_url()).'/wp-admin/admin.php?page=wp-ada-compliance-admin" class="adaEnableFullVersion">';
	$_SESSION['my_ada_notices'] .= __(' Please enter a valid license key to unlock the WP ADA Compliance plugin','wp-ada-compliance');
	$_SESSION['my_ada_notices'] .= '</a>';
		return false;
	}
	}
	// ignore error
   
	elseif ( isset( $_GET[ 'wpada_ignore' ] ) ) {
		if(isset( $_GET[ 'errorcode' ] )){ 
        wp_ada_compliance_validate_form_values();     
			$errorcode = sanitize_text_field($_GET[ 'errorcode' ]);
		}
		else $errorcode = '';
		$wpada_ignore = (int)$_GET[ 'wpada_ignore' ];
       if(isset( $_GET[ 'period' ] )){  
           $ignore_period = (int)$_GET[ 'period' ];
       } else $ignore_period = '';
	
		wp_ada_compliance_ignore_error($wpada_ignore, $errorcode,$ignore_period);
	}
		
	// ignore rules
	elseif ( isset( $_GET[ 'wpada_ignore_rule' ] ) ) {
        wp_ada_compliance_validate_form_values();  
	// secure rules
	$settingsuser = get_option('wp_ada_compliance_settingsusers','manage_options');
		if (current_user_can($settingsuser) ){    
		$wpada_ignore_rule = sanitize_text_field($_GET[ 'wpada_ignore_rule' ]);
		wp_ada_compliance_ignore_scan_rule($wpada_ignore_rule);
            
			// remove ignored rule errors
	    wp_ada_compliance_purge_rules();	
            
		$_SESSION['my_ada_important_notices'] = __('The selected rule is now being ignored.','wp-ada-compliance');
		}
	}
		
	// ignore post
	elseif ( isset( $_GET[ 'wpada_ignore_post' ] ) ) {
        $error = wp_ada_compliance_validate_form_values();  
        if(isset($_GET[ 'scantype' ]) and isset($_GET[ 'posttype' ]) and $_GET[ 'posttype' ] != ''){
		$wpada_ignore_post = (int)($_GET[ 'wpada_ignore_post' ]);
		$scantype = sanitize_text_field($_GET[ 'scantype' ]);
	    $posttype = sanitize_text_field($_GET[ 'posttype' ]);	
		$externalsrcid = (int)$_GET[ 'id' ];	
		wp_ada_compliance_ignore_post($wpada_ignore_post, $scantype, $posttype,$externalsrcid);
        
        wp_ada_compliance_set_ignore_flag($externalsrcid, 1);
        
		$_SESSION['my_ada_important_notices'] = __('The selected item has been removed from all future scans.','wp-ada-compliance');
        }
	}

	// start scan of single post
	if ( isset($_GET[ 'scansingle' ]) and isset($_GET['postid']) and isset($_GET['type'])) {

	
	wp_ada_compliance_start_single_scan();
	}
	// start scan of content
	if ( isset($_GET[ 'startscan' ]) and !isset($_GET['cpage'])) {
	wp_ada_compliance_start_scan();
	}	
	}

}
/************************************************
manual or autoscan scan 
************************************************/
//rest full scan
function wp_ada_compliance_rest_start_scan() {
	
	if(wp_ada_compliance_checkdemo_date()) {
	return 'complete';		
	}
		
	check_ajax_referer('wp_rest', '_wpnonce');
    
	// set required php settings	
    wp_ada_compliance_set_php_ini_Settings();	
    
	 wp_ada_compliance_start_scan(1); 
}
//start full scan
function wp_ada_compliance_start_scan($rest=0) {

    
	// clear error message
if(!isset($_SESSION['my_ada_notices'])) $_SESSION['my_ada_notices'] = "";	
    
    update_option('wp_ada_compliance_rescan_required','false');
	   
	   // check if monitoring resource usage
		//$throttle_resources= get_option('wp_ada_compliance_throttle_resources','false');
		//if($throttle_resources=='true'){
		// register shutdown to handle errors
      //  if($rest == 0)
		register_shutdown_function('wp_ada_compliance_fatalErrorHandler');	
       // else register_shutdown_function('wp_ada_compliance_rest_fatalErrorHandler');	
		//track execution time
		//global $wp_ada_execution_time_start;
		//$wp_ada_execution_time_start = microtime(true);
		//}		

   
    
		if (defined( 'DOING_CRON' )) {
		// check for maintenance mode before continuing
        $scan_in_progress = get_option( 'wp_ada_compliance_scan_inprogress', 'false');     
		if ( file_exists( ABSPATH . '.maintenance' ) || wp_installing() || $scan_in_progress == 'true' ) {
		
            return 1;
		}	
			
		$auto_scan_options = get_option('wp_ada_compliance_auto_scan_options','false');
		if($auto_scan_options == 'false')  return 1;
         
     // don't run cron scan if password protected scans using wordpress login are enabled (Apache Basic Authentication Required)
        if(wp_ada_compliance_check_pw_protected_login_status() == 2)   return 1;  
		}
	
       // inventory links
     if((defined( 'DOING_CRON' ) and wp_ada_compliance_check_complete_status() == 0) 
		or(isset($_GET[ 'startscan' ]) and (!isset($_GET[ 'scanmore' ]) 
         or (isset($_GET[ 'scanmore' ]) and $_GET[ 'scanmore' ] == 0)))) {
         
         // enforce dont crawl
        if(isset($_GET['crawl'])){
          
            update_option( 'wp_ada_compliance_crawl_status', (int)$_GET['crawl']);
        }
        
         
         // inventory website links
		 wp_ada_compliance_inventory_links();
        
         // set flag to track scanned content
         wp_ada_compliance_set_scan_flag(); 
       
             
         // if crawling links
         $crawl_status = get_option('wp_ada_compliance_crawl_status','1');
         if($crawl_status == 1){
             
          // mark html and css links for removal when no longer found
          wp_ada_compliance_set_locate_flag();
        
          // mark link for removal when no longer valid
		  // wp_ada_compliance_set_link_purge_flag();
         }
          }
      
    	// how many to scan each run	
		if ( !defined( 'DOING_CRON' )) {
        update_option( 'wp_ada_compliance_scan_inprogress', 'true');
                    
            
		$total_posts_to_scan_each_run = get_option('wp_ada_compliance_full_scan_post_count','5');
        }
		elseif($auto_scan_options != 'false') 
		$total_posts_to_scan_each_run = get_option('wp_ada_compliance_cron_scan_post_count','5');
		else $total_posts_to_scan_each_run = 1;
    
        // reset time out to support large files
       //wp_ada_compliance_set_php_ini_Settings(1);
		
		// scan post content 
		wp_ada_compliance_scan_ada_compliance_post_deep_scan($total_posts_to_scan_each_run);
		
		// scan term content
		scan_ada_compliance_terms_deep_scan($total_posts_to_scan_each_run);
    
    // reset time out to support large files
    //wp_ada_compliance_set_php_ini_Settings(1);
    
    // scan html files
   wp_ada_compliance_scan_ada_compliance_html_deep_scan($total_posts_to_scan_each_run);
    
       // reset time out to support large files
    //wp_ada_compliance_set_php_ini_Settings(1);
    
        // scan pdf files
   wp_ada_compliance_scan_ada_compliance_pdf_deep_scan($total_posts_to_scan_each_run);
       
	// scan theme files
		wp_ada_compliance_theme_validation($total_posts_to_scan_each_run);
    
    		// scan css files	
		wp_ada_compliance_validate_css($total_posts_to_scan_each_run);		
    
    // scan post archives
		wp_ada_compliance_post_archive_validation($total_posts_to_scan_each_run);
	
		// scan is complete, scan everything else	
       if(wp_ada_compliance_check_complete_status()==0){	
           
        // scan widget content    
		wp_ada_compliance_scan_widget_text();
           
           // process location notes
           wp_ada_compliance_process_location_notes(); 
			
		   // purge links
		 wp_ada_compliance_purge_links();
 
		update_option( 'wp_ada_compliance_full_scan_completed', 'true');	 
    
     // if rest call display status
      if($rest == 1)  echo 'complete'; 
    }
    
    if ( !defined( 'DOING_CRON' )) 
	update_option( 'wp_ada_compliance_scan_inprogress', 'false'); 
}
/************************************************
rest single scan
************************************************/
function wp_ada_compliance_rest_start_single_scan() {
	
	check_ajax_referer('wp_rest', '_wpnonce');
	
	if(isset($_GET['wpadarescan'])){
		
	 $values = explode('|',sanitize_text_field($_GET['wpadarescan'])); 
	 	
	$_GET['type'] = $values[0];	
	$_GET['errorid'] = $values[1];
	$_GET['postid'] = $values[2];	
	$_GET['taxonomy'] = $values[3];	
       $_GET['scansingle'] = 1;	
			
	 wp_ada_compliance_start_single_scan(); 
	
					// clear error message
	if(isset($_SESSION['my_ada_notices'])) $_SESSION['my_ada_notices'] = "";
	}
}

/************************************************
manual single scan
************************************************/
function wp_ada_compliance_start_single_scan() {

		register_shutdown_function('wp_ada_compliance_fatalErrorHandler');	
    
            // set required php settings	
wp_ada_compliance_set_php_ini_Settings(); 

	// enforce post type check
	$post_types = get_option('wp_ada_compliance_posttypes',array('page','post'));
   
	if(!in_array($_GET['type'],$post_types) and $_GET['type'] != 'widget' and $_GET['type'] != 'theme' and $_GET['type'] != 'css' and $_GET['type'] != 'term' and $_GET['type'] != 'link' and $_GET['type'] != 'iframe' and $_GET['type'] != 'pdf') {

        return 0;

	}
	
	if(!isset($_GET['type']) or !isset($_GET['postid'])) return 0;
	
	$postid = (int)$_GET['postid'];
	
	if(isset($_GET['errorid'])){
	$id = (int)$_GET['errorid'];
		$_GET['errorid'] = '';
	}
	else $id= '';
	
	if($_GET['type'] == 'theme'){		
		
       if( wp_ada_compliance_theme_archive_error_check($id)) // scan post archives
           wp_ada_compliance_post_archive_validation('', $postid);   
       
        else  // scan themes
		wp_ada_compliance_theme_validation('', $postid);
	
	}
	elseif($_GET['type'] == 'css'){
    
		wp_ada_compliance_validate_css('', $postid);
	}
	elseif($_GET['type'] == 'term' and isset($_GET['taxonomy'])){
		$taxonomy = sanitize_text_field($_GET['taxonomy']);

		wp_ada_compliance_terms_recheck_deep_scan($postid, $taxonomy);

	}
	elseif($_GET['type'] == 'widget'){
		$_GET['postid'] = '';
		$_GET['searchtitle'] = '';
		wp_ada_compliance_scan_widget_text();	
	}
    elseif($_GET['type'] == 'link' or $_GET['type'] == 'iframe'){
     wp_ada_compliance_scan_ada_compliance_html_deep_scan('',$postid);   
    }
       elseif($_GET['type'] == 'pdf'){
      
     wp_ada_compliance_scan_ada_compliance_pdf_deep_scan('',$postid);   
    }
	else{ 

        // deep scan
       wp_ada_compliance_scan_ada_compliance_post_recheck_deep_scan($postid);
	

        
	}
	// clear error message if not scanning on save	
if(!isset($_GET['wpadarescan'])){	
if(isset($_GET['startscan']) or isset($_GET['scansingle']) or !array_key_exists('scantype',$postinfo)) 
	$_SESSION['my_ada_notices'] = "";
}
}

/******************************************
// include css and scripts for admin features
****************************************/
function wp_ada_compliance_admin_scripts() {

    
if(wp_ada_compliance_check_is_admin() and !strstr($_SERVER['REQUEST_URI'],'theme-editor.php') and !strstr($_SERVER['REQUEST_URI'],'plugin-editor.php') and !strstr($_SERVER['REQUEST_URI'],'site-health.php') 
   and !strstr($_SERVER['REQUEST_URI'],'admin-ajax.php')){
    
  
wp_register_style( 'wp-ada-compliance-styles',  plugin_dir_url( __FILE__ ) .  'styles.css', array(), filemtime( plugin_dir_path( __FILE__ ) .  'styles.css' ) );	
wp_enqueue_style( 'wp-ada-compliance-styles' );	
 
// font awesome  
wp_register_script( 'wp-ada-compliance-fontawesome-scripts',  '//kit.fontawesome.com/6afc8f9e49.js', array('jquery'), '', true);
wp_enqueue_script( 'wp-ada-compliance-fontawesome-scripts' );	   
    
if(isset($_GET['wp_ada_display_error'])){
wp_enqueue_style( 'plugin-styles', plugin_dir_url( __FILE__ ) .  'editor-styles.css', array(), filemtime( plugin_dir_path( __FILE__ ) .  'editor-styles.css' ), true);		
}
    
// add color picker and file selector	to settings page
if(is_admin() and strstr($_SERVER['REQUEST_URI'],'admin.php?page=wp-ada-compliance-admin')){     
wp_enqueue_style( 'wp-color-picker' );	
wp_enqueue_media();
}
    
// add date picker to report screen      
if(is_admin() and strstr($_SERVER['REQUEST_URI'],'admin.php?page=ada_compliance')){    
wp_enqueue_style('jquery-ui-datepicker');   
wp_enqueue_script('jquery-ui-datepicker');    
}    
    
/* tabs for admin page */
 wp_enqueue_script( 'jquery-ui-tabs' );	
	
// scripts to use jquery to ignore		
wp_register_script( 'wp-ada-compliance-ignore-script',  plugin_dir_url( __FILE__ ) .  'res/scripts.js', array('wp-color-picker','jquery'), filemtime( plugin_dir_path( __FILE__ ) .  'res/scripts.js' ) );
wp_enqueue_script( 'wp-ada-compliance-ignore-script' );
	
wp_localize_script( 'wp-ada-compliance-ignore-script', 'wpadacomplianceVariables',array(
    'scanstartedmessage' =>'<i class="fas fa-toggle-off"></i> '.__('Please be patient while the process completes. Leave this window open and turn off your computers automatic sleep settings to avoid interruption.','wp-ada-compliance'),
    'bookmarkmessage' => __('To save a search, press CTRL-D on your keyboard to bookmark the url for easy access.','wp-ada-compliance'),
	'showsummary' =>'<i class="fas fa-toggle-off"></i> '.__('Show Summary','wp-ada-compliance'),
	'hidesummary' =>'<i class="fas fa-toggle-on"></i> '.__('Hide Summary','wp-ada-compliance'),
	'working' => '<span class="adaworking">&nbsp;</span> '.__( 'Please wait while the report is being refreshed' ,'wp-ada-compliance'),
	'refresh' => '<i class="far fa-check-circle" aria-hidden="true"></i> '.__('The report data has been refreshed.' ,'wp-ada-compliance'),
    	'rechecking' => '<i class="far fa-check-circle" aria-hidden="true"></i> '.__('Scan is complete, results are displayed in the report below.' ,'wp-ada-compliance'),
    	'scanning' => '<span class="adaworking">&nbsp;</span> '.__( 'Scan in Progress...' ,'wp-ada-compliance'),
    'inventory' => '<span class="adaworking">&nbsp;</span> <span class="adaRedText">'.__( 'Please wait while the link inventory is updated.' ,'wp-ada-compliance').'</span>',
        	'cancellingscan' => '<span class="adaworking">&nbsp;</span> '.__( 'Cancelling Scan...' ,'wp-ada-compliance'),
        	'scancomplete' => '<i class="far fa-check-circle" aria-hidden="true"></i> '.__( 'Scan Complete' ,'wp-ada-compliance'),
'scancompletecompare' => __( 'Scan Complete' ,'wp-ada-compliance'),    
 	'cancelled' => '<i class="fas fa-info-circle" aria-hidden="true"></i> '.__( 'Scan Cancelled' ,'wp-ada-compliance'),    
	'processtime' => '<br /><i class="far fa-clock" aria-hidden="true"></i>'.__(' Run Time: ' ,'wp-ada-compliance'),    
		'processminute' => __(' Minute ' ,'wp-ada-compliance'),
			'processminutes' => __(' Minutes ' ,'wp-ada-compliance'), 
			'processhours' => __(' Hours ' ,'wp-ada-compliance'), 
    'processhour' => __(' Hour ' ,'wp-ada-compliance'), 
 	'fatalerror' => '<i class="fas fa-exclamation-circle" aria-hidden="true"></i> '.__( 'Scan was stopped do to a fatal error. Some hosts are known to severely throttle resource usage which can result in 503 or 508 errors. Here is some additional information that may help you troubleshoot the problem: ERROR: ' ,'wp-ada-compliance'), 
    'continue' => '<br />'.__( 'Click continue to begin the scan where it was interrupted.' ,'wp-ada-compliance'), 
		'confirmignoreerror' => __('By continuing this issue will be ignored.','wp-ada-compliance'),
	'confirmignoreerrorall' => __('By continuing this issue and all duplicates of it will be ignored.','wp-ada-compliance'),
		'ignorefileconfirm' => __( 'By continuing this item will be removed from the results and all future scans. You may re-enable scans of this item under plugin settings.' ,'wp-ada-compliance'),
    	'ignorerule' => '<i class="fas fa-info-circle" aria-hidden="true"></i> '.__('The selected rule is now being ignored. You may re-enable this rule under plugin settings.','wp-ada-compliance'),
		'ignoreruleconfirm' => __('By continuing this error will be removed from the results and all future scans. You may re-enable this scan rule under plugin settings.','wp-ada-compliance'),
    		'ignoreerror' => '<i class="far fa-check-circle" aria-hidden="true"></i> '.__( 'The selected item is now being ignored.' ,'wp-ada-compliance'),
    		'ignorestatus' => '<i class="far fa-check-circle" aria-hidden="true"></i> '.__( 'The ignore status has been updated.' ,'wp-ada-compliance'),
		'unignoreerror' => '<i class="fas fa-info-circle" aria-hidden="true"></i> '.__( 'The selected item has been removed from the ignore list.' ,'wp-ada-compliance'),
	'ignoreduplicates' => __( 'Duplicates' ,'wp-ada-compliance'),
    'ignorefile' => '<i class="fas fa-info-circle" aria-hidden="true"></i> '.__( 'The selected document has been removed from all future scans.' ,'wp-ada-compliance'),
      'defaultimage' => __( 'default image' ,'wp-ada-compliance'),
	 'resturl' => esc_url_raw(get_rest_url()),
	'nonce' => wp_create_nonce( 'wp_rest' ) 
	));		
  
}

}
/******************************************
// include public css and scripts
****************************************/
function wp_ada_compliance_public_scripts() {
// external scripts
wp_register_style( 'wp-ada-compliance-styles',  plugin_dir_url( __FILE__ ) .  'styles.css', array(), filemtime( plugin_dir_path( __FILE__ ) .  'styles.css' ) );	
wp_enqueue_style( 'wp-ada-compliance-styles' );	

// get options
$use_accessibility_shortcode = get_option('wp_ada_compliance_use_accessibility_widget_shortcode','false');
$use_accessibility_widget = get_option('wp_ada_compliance_use_accessibility_widget','false');
$disable_fontawesome = get_option('wp_ada_compliance_disable_fontawesome_public','false');    

// font awesome      
if($disable_fontawesome == 'false' and ($use_accessibility_shortcode == 'true' or $use_accessibility_widget != 'false')) { 
wp_register_script( 'wp-ada-compliance-fontawesome-scripts',  '//kit.fontawesome.com/6afc8f9e49.js', array('jquery'), '', true);
wp_enqueue_script( 'wp-ada-compliance-fontawesome-scripts' );	   
}	
    
 // widget scripts  
if($use_accessibility_widget != 'false' or $use_accessibility_shortcode == 'true') {   
    
wp_register_script( 'wp-ada-compliance-adawidget-scripts',  plugin_dir_url( __FILE__ ) .  'res/access_widget.js', array('jquery'), filemtime( plugin_dir_path( __FILE__ ).'res/access_widget.js'), true);	
	wp_localize_script( 'wp-ada-compliance-adawidget-scripts', 'wpadaVariables', array(
		'show' => __( 'show' ,'wp-ada-compliance'),
		'hide' => __( 'hide' ,'wp-ada-compliance'),
        'option' => get_option('wp_ada_compliance_accessibility_widget_placement','bottom'),
	) );
        // need to add check for beaver builder and return if not
 if ((class_exists( 'FLBuilderModel' ) and !FLBuilderModel::is_builder_active()) or !class_exists( 'FLBuilderModel' )) {
    wp_enqueue_script( 'wp-ada-compliance-adawidget-scripts' );
  }
	
    
wp_register_style( 'wp-ada-compliance-adawidget-styles',  plugin_dir_url( __FILE__ ) .  'res/access_widget.css', array(), filemtime( plugin_dir_path( __FILE__ ) .  'res/access_widget.css' ) );	
wp_enqueue_style( 'wp-ada-compliance-adawidget-styles' );
    
$accessibility_widget_primary_color = get_option('wp_ada_compliance_accessibility_widget_primary_color','');	
$accessibility_widget_secondary_color = get_option('wp_ada_compliance_accessibility_widget_secondary_color','');
    $accessibility_widget_placement = get_option('wp_ada_compliance_accessibility_widget_placement','bottom');	
$add_inline_styles = '';		
if($accessibility_widget_primary_color != '' and $accessibility_widget_secondary_color != '')  {		
		
//All the user input CSS settings as set in the plugin settings
$add_inline_styles = '
.wp-ada-compliance-accessibility-widget-protectedby{
background-color:'.$accessibility_widget_primary_color.' !important; 
color:'.$accessibility_widget_secondary_color.' !important;
}
.wp-ada-compliance-accessibility-widget-protectedby a{
color:'.$accessibility_widget_secondary_color.' !important;
}
.wp-ada-compliance-accessibility-widget-content h2{
background-color:'.$accessibility_widget_primary_color.' !important; 
color:'.$accessibility_widget_secondary_color.' !important;
}
.wp-ada-compliance-accessibility-widget-close{
color:'.$accessibility_widget_secondary_color.' !important;
}
.wp-ada-compliance-accessibility-widget-content button, .wp-ada-compliance-accessibility-widget-content .wp-ada-compliance-accessibility-widget-report, .wp-ada-compliance-accessibility-widget .wp-ada-compliance-toolbtn .fa, .wp-ada-compliance-accessibility-widget .wp-ada-compliance-toolbtn .fas, .wp-ada-compliance-accessibility-widget .wp-ada-compliance-toolbtn .far{
color:'.$accessibility_widget_secondary_color.' !important;
}
.wp-ada-compliance-accessibility-widget-toolbar{
background-color:'.$accessibility_widget_primary_color.' !important; 
color:'.$accessibility_widget_secondary_color.' !important;
}
.wp-ada-compliance-accessibility-widget-toolbar .fa, .wp-ada-compliance-accessibility-widget-toolbar .far, .wp-ada-compliance-accessibility-widget-toolbar .fas{
color:'.$accessibility_widget_secondary_color.';
}
.wp-ada-compliance-accessibility-widget-toolbar a, .wp-ada-compliance-accessibility-widget-toolbar a:hover{
background-color:'.$accessibility_widget_primary_color.' !important; 
color:'.$accessibility_widget_secondary_color.' !important;
}
a.wp-ada-compliance-accessibility-widget-button{
color:'.$accessibility_widget_primary_color.' !important;

}
a.wp-ada-compliance-accessibility-widget-button:hover, a.wp-ada-compliance-accessibility-widget-button:active, a.wp-ada-compliance-accessibility-widget-button:focus{
color:'.$accessibility_widget_primary_color.' !important;
}
 .wp-ada-compliance-accessibility-widget-hide{
 background-color:'.$accessibility_widget_primary_color.' !important; 
 color:'.$accessibility_widget_secondary_color.' !important;
  border:1px solid '.$accessibility_widget_secondary_color.' !important; 
 }

  .wp-ada-compliance-accessibility-widget-content button:hover,  .wp-ada-compliance-accessibility-widget-content button:active,  .wp-ada-compliance-accessibility-widget-content button:focus{
  color:'.$accessibility_widget_secondary_color.' !important; 
  
 }
.wp-ada-compliance-accessibility-widget .fa-universal-access{
 background-color:'.$accessibility_widget_secondary_color.' !important; 
 }
 .wp-ada-compliance-accessibility-widget-content{
 border:1px solid '.$accessibility_widget_secondary_color.' !important;
 }
';
}
if($accessibility_widget_placement == 'top'){
    $add_inline_styles .= '
    .wp-ada-compliance-accessibility-widget-hide{
    top: 12px;
    }
    .wp-ada-compliance-accessibility-widget-content{
    top: 65px;
    right: 80px;
    }
    .wp-ada-compliance-accessibility-widget {
    top: 25px;
    }
    ';}
   else if($accessibility_widget_placement == 'left'){
    $add_inline_styles .= '
    .wp-ada-compliance-accessibility-widget-hide{
    left: 65px;
    }
    .wp-ada-compliance-accessibility-widget-content{
    bottom: 80px;
     left: 20px;
    }
    .wp-ada-compliance-accessibility-widget {
     bottom: 95px;
     left: 20px;
    }
@media only screen and (max-width: 470px){
.wp-ada-compliance-accessibility-widget-content{
  bottom: 0px;
}
}
    ';}
    else{
    $add_inline_styles .= '
    .wp-ada-compliance-accessibility-widget {
      bottom: 65px;
      }
    .wp-ada-compliance-accessibility-widget-content{
    bottom: 40px;
     right: 80px;
    }
  @media only screen and (max-width: 470px){
     .wp-ada-compliance-accessibility-widget {
      bottom: 95px;
      }
.wp-ada-compliance-accessibility-widget-content{
  bottom: 0px;
}
}
    ';
      }

    
$add_inline_styles .= '.wp-ada-bigcursor *{cursor: url('.plugin_dir_url( __FILE__ ).'res/cursor.png), url('.plugin_dir_url( __FILE__ ).'res/cursor.cur), auto !important;}';

//Add the above custom CSS via wp_add_inline_style
wp_add_inline_style( 'wp-ada-compliance-adawidget-styles', $add_inline_styles ); //Pass the variable into the main style sheet ID
}	
}

/******************************************
// include public css based on options
****************************************/
function wp_ada_compliance_optional_public_scripts() {
	
$wp_ada_compliance_focus_styles = get_option('wp_ada_compliance_focus_styles','true');	
$wp_ada_compliance_focus_outline_color = get_option('wp_ada_compliance_outline_color','#5E9ED6');
$wp_ada_compliance_focus_include_hover = get_option('wp_ada_compliance_include_hover','false');		
if($wp_ada_compliance_focus_styles == 'false') return;	
	
wp_register_style( 'wp-ada-compliance-focus-styles',  plugin_dir_url( __FILE__ ) .  'public-styles.css', array(), filemtime( plugin_dir_path( __FILE__ ) .  'public-styles.css' ) );	
wp_enqueue_style( 'wp-ada-compliance-focus-styles' );	
	
// allow user to set outline color	
if($wp_ada_compliance_focus_outline_color != ''){
	
$stylestoadd ='a:active, a:focus,';
if($wp_ada_compliance_focus_include_hover == 'true') $stylestoadd .= 'a:hover, ';
$stylestoadd .= '
button:focus, button:active, 
input:focus, input:active,
textarea:focus, textarea:active,
area:focus, area:active,
select:focus, select:active,  
iframe:focus, iframe:active, 
details:focus, details:active, 
.wp-ada-elementor-tab-title:focus, .wp-ada-elementor-tab-title:active{
   outline: 2px solid '.esc_attr($wp_ada_compliance_focus_outline_color).' !important;
    outline: 5px auto -webkit-browser-ring-color !important;
}';	

wp_add_inline_style( 'wp-ada-compliance-focus-styles', $stylestoadd );	
}
}
/******************************************
// remove startscan from paginate links
****************************************/
add_filter( 'paginate_links', 'wp_ada_compliance_remove_query_args');
function wp_ada_compliance_remove_query_args( $link ){
      
$link = filter_input( INPUT_GET, 'scansingle' )  ? remove_query_arg( 'scansingle', $link ): $link;
$link = filter_input( INPUT_GET, 'startscan' )  ? remove_query_arg( 'startscan', $link ): $link;      
    
    return $link;
}

/******************************************
// add admin body class for jquery and iframe
****************************************/
function wp_ada_compliance_add_body_classes( $classes ) {

if(is_admin() and strstr($_SERVER['REQUEST_URI'],'admin.php?page=ada_compliance/compliancereport.php') and strstr($_SERVER['REQUEST_URI'],'iframe=1')){	
	$classes .= ' wpadaIframe ';
}
	
    return $classes;
     
}


/**********************************************************
// TINYMCE SETTINGS
*********************************************************/

/**********************************************************
// over ride tinymce font size drop down settings to use % 
*********************************************************/
function wp_ada_compliance_mce_text_sizes( $initArray ){
	$setting = get_option('wp_ada_compliance_fontsize_selector','percent');	
	
	if($setting == "default") return $initArray;
		
	elseif($setting == 'percent')
        $initArray['fontsize_formats'] = "60% 70% 80% 90% 100% 110% 120% 130% 140% 150% 160% 170% 180% 190% 200%";
		
    elseif($setting == 'em') 
		$initArray['fontsize_formats'] = "0.6em 0.7em 0.8em 0.9em 1.0em 1.1em 1.2em 1.3em 1.4em 1.5em 1.6em 1.7em 1.8em 1.9em 2em";	
        return $initArray;
    }

/******************************************
// modify tinymce editor to add styles
****************************************/
function wp_ada_compliance_add_styles_to_editor($url) {
     if ( !empty($url) )
        $url .= ',';
 
    // Retrieves the plugin directory URL and adds editor stylesheet
    // Change the path here if using different directories
   $url .= trailingslashit( plugin_dir_url(__FILE__) ) . '/editor-styles.css';
 
    return $url;
}


/*****************************************************************************
 * Add title and class fields to link tool
 * ****************************************************************************/
function wp_ada_compliance_add_aria_label_to_links() {
$link_titles = get_option('wp_ada_compliance_link_title_tools','true');
	if($link_titles == "false") return 1;	
	
	$label = "Title";	
	// add title and class fields based on settings
	wp_enqueue_script( 'wplinkTitle', plugins_url( '/res/wplink.min.js', __FILE__ ), array( 'wplink' ), '1.3', true );
	wp_localize_script( 'wplinkTitle', 'wpLinkTitleL10n', array(
		'titleLabel' => __( esc_attr($label) ,'wp-ada-compliance'),
		'classLabel' => __( 'Class' ,'wp-ada-compliance'),
	) );
	
}
/******************************************
add custom styles to the WordPress editor
******************************************/
function wp_ada_compliance_custom_styles( $init_array ) { 

 $presentation_tables = get_option('wp_ada_compliance_presentation_tables','true');

	if($presentation_tables == 'false') return $init_array;

	// Merge old & new styles
   $init_array['style_formats_merge'] = true;
	
    $new_formats = array(  
		//'title'	=> __( 'Accessibility', 'wp-ada-compliance' ),
		//		'items'	=> array(
        // These are the custom styles
        /*array(  
            'title' => __( 'Presentation Image', 'wp-ada-compliance' ), 
            'classes' => 'role-presentation',
            'wrapper' => false,
			'selector' => 'img',
        ),  */
		array(  
            'title' => __( 'Presentation Table', 'wp-ada-compliance' ), 
            'classes' => 'role-presentation',
            'wrapper' => false,
			'selector' => 'table',
        ),  
      // ),  
    );  
	
	/* Check if custom "style_formats" is enabled */
    if( isset( $init_array['style_formats'] ) ){
 
        /* Get old style_format config */
        $old_formats = json_decode( $init_array['style_formats'] );
 
        /* Merge it with our own */
        $new_formats = array_merge( $new_formats, $old_formats );
    }

	
    // Insert the array, JSON ENCODED, into 'style_formats'
   	$init_array['style_formats'] = json_encode(  $new_formats );   
    
    return $init_array;  
  
}
/**********************************************************
// modify tiny mce
*********************************************************/
// add font size selector and style selector
function wp_ada_compliance_wp_editor_modify_tinymce( $buttons ) {
     $fontsize_setting = get_option('wp_ada_compliance_fontsize_selector','percent');	
	 $presentation_tables = get_option('wp_ada_compliance_presentation_tables','true');
		
	if($presentation_tables == 'false' and $fontsize_setting == "default" and $add_table_editor == 'false') return $buttons;
	
	array_shift( $buttons );

	if($fontsize_setting != 'default' and !in_array('fontsizeselect', $buttons)) array_unshift( $buttons, 'fontsizeselect');
    if($presentation_tables != 'false' and !in_array('styleselect', $buttons))  array_unshift( $buttons, 'styleselect');
	      
	return $buttons;
} 
// modify buttons in tiny mce
function wp_ada_compliance_wp_editor_modify_mce_buttons( $buttons ) {
    
	$removejustify = get_option('wp_ada_compliance_removejustify','true');

	if($removejustify != 'false'){
		 if ( ( $key = array_search( 'alignjustify', $buttons ) ) !== false )
		unset( $buttons[$key] );
		}
       
	   return $buttons;
} 

/**********************************************************
// Add font sizes to Guttenberg Editor
********************************************************/
function wp_ada_compliance_gutenberg_text_sizes(){
$setting = get_option('wp_ada_compliance_fontsize_selector','percent');	
	
if($setting == "default") return;

if($setting == "em"){	
add_theme_support( 'editor-font-sizes', array(
    array(
        'name' => __( 'smaller', 'wp-ada-compliance' ),
        'shortName' => __( 'S', 'wp-ada-compliance' ),
        'size' => 14,
        'slug' => 'wpada small em'
    ),
    array(
        'name' => __( 'regular', 'wp-ada-compliance' ),
        'shortName' => __( 'M', 'wp-ada-compliance' ),
        'size' => 16,
        'slug' => 'wpada regular em'
    ),
    array(
        'name' => __( 'large', 'wp-ada-compliance' ),
        'shortName' => __( 'L', 'wp-ada-compliance' ),
        'size' => 25,
        'slug' => 'wpada large em'
    ),
    array(
        'name' => __( 'larger', 'wp-ada-compliance' ),
        'shortName' => __( 'XL', 'wp-ada-compliance' ),
        'size' => 32,
        'slug' => 'wpada larger em'
    ),
	array(
        'name' => __( 'largest', 'wp-ada-compliance' ),
        'shortName' => __( 'XXL', 'wp-ada-compliance' ),
        'size' => 37,
        'slug' => 'wpada largest em'
    )
) );
}

if($setting == "percent"){	
add_theme_support( 'editor-font-sizes', array(
    array(
        'name' => __( 'smaller', 'wp-ada-compliance' ),
        'shortName' => __( 'S', 'wp-ada-compliance' ),
        'size' => 14,
        'slug' => 'wpada small percent'
    ),
    array(
        'name' => __( 'regular', 'wp-ada-compliance' ),
        'shortName' => __( 'M', 'wp-ada-compliance' ),
        'size' => 16,
        'slug' => 'wpada regular percent'
    ),
    array(
        'name' => __( 'large', 'wp-ada-compliance' ),
        'shortName' => __( 'L', 'wp-ada-compliance' ),
        'size' => 25,
        'slug' => 'wpada large percent'
    ),
    array(
        'name' => __( 'larger', 'wp-ada-compliance' ),
        'shortName' => __( 'XL', 'wp-ada-compliance' ),
        'size' => 32,
        'slug' => 'wpada larger percent'
    ),
	array(
        'name' => __( 'largest', 'wp-ada-compliance' ),
        'shortName' => __( 'XXL', 'wp-ada-compliance' ),
        'size' => 37,
        'slug' => 'wpada largest percent'
    )
) );
}
}

/**********************************************************
// Add Color Palette to Guttenberg Editor
********************************************************/
function wp_ada_compliance_gutenberg_color_palette() {
  $tinymce_color_pallet = get_option('wp_ada_compliance_tinymce_color_pallet','true');
	if($tinymce_color_pallet == 'true'){	
	add_theme_support(
		'editor-color-palette', array(
			array(
				'name'  => esc_html__( 'Black', 'wp-ada-compliance' ),
				'slug' => 'WPADA Black',
				'color' => '#000000',
			),
			array(
				'name'  => esc_html__( 'Red', 'wp-ada-compliance' ),
				'slug' => 'WPADA Red',
				'color' => '#cf2e2e',
			),
			array(
				'name'  => esc_html__( 'Burnt orange', 'wp-ada-compliance' ),
				'slug' => 'WPADA Burnt orange',
				'color' => '#BD4F00',
			),
			array(
				'name'  => esc_html__( 'Dark azure', 'wp-ada-compliance' ),
				'slug' => 'WPADA Dark azurer',
				'color' => '#003366',
			),
			array(
				'name'  => esc_html__( 'Navy Blue', 'wp-ada-compliance' ),
				'slug' => 'WPADA Navy Blue',
				'color' => '#000080',
			),
					array(
				'name'  => esc_html__( 'Green', 'wp-ada-compliance' ),
				'slug' => 'WPADA Green',
				'color' => '#006600',
			),	
			array(
				'name'  => esc_html__( 'Sky Blue', 'wp-ada-compliance' ),
				'slug' => 'WPADA Sky Blue',
				'color' => '#007E9E',
			),
			array(
				'name'  => esc_html__( 'Dark Purple', 'wp-ada-compliance' ),
				'slug' => 'WPADA Dark Purple',
				'color' => '#610061',
			),
			array(
				'name'  => esc_html__( 'Purple', 'wp-ada-compliance' ),
				'slug' => 'WPADA Purple',
				'color' => '#800080',
			),
			array(
				'name'  => esc_html__( 'Gray', 'wp-ada-compliance' ),
				'slug' => 'WPADA Gray',
				'color' => '#757575',
			),
			array(
				'name'  => esc_html__( 'Dark gray', 'wp-ada-compliance' ),
				'slug' => 'WPADA Dark gray',
				'color' => '#313131',
			)
		)
	);
	}
}

/**********************************************************
// Customize the TinyMCE Color Palette
********************************************************/
function wp_ada_compliance_tinymce_color_options($options) {
    
   $tinymce_color_pallet = get_option('wp_ada_compliance_tinymce_color_pallet','true');
	if($tinymce_color_pallet == 'true'){	
	$custom_colours =  array(
	'000000', __( 'Black', 'wp-ada-compliance' ),
    '333300', __( 'Dark olive', 'wp-ada-compliance' ),
    '003300', __( 'Dark green', 'wp-ada-compliance' ),
    '003366', __( 'Dark azure', 'wp-ada-compliance' ),
    '000080', __( 'Navy Blue', 'wp-ada-compliance' ),
    '333399', __( 'Indigo', 'wp-ada-compliance' ),
    '333333', __( 'Very dark gray', 'wp-ada-compliance' ),
    '800000', __( 'Maroon', 'wp-ada-compliance' ),
    'FF6600', __( 'Orange (DO NOT USE OVER LIGHT BACKGROUND OR AS A BACKGROUND FOR LIGHT COLORED TEXT)', 'wp-ada-compliance' ),
	'BD4F00', __( 'Burnt Orange', 'wp-ada-compliance' ),
    '666600', __( 'Olive', 'wp-ada-compliance' ),
    '006600', __( 'Green', 'wp-ada-compliance' ),
    '008080', __( 'Teal', 'wp-ada-compliance' ),
    '0000FF', __( 'Blue', 'wp-ada-compliance' ),
    '666699', __( 'Grayish blue', 'wp-ada-compliance' ),
    '757575', __( 'Gray', 'wp-ada-compliance' ),
    'C70000', __( 'Red', 'wp-ada-compliance' ),
    'FF9900', __( 'Amber (DO NOT USE OVER LIGHT BACKGROUND OR AS A BACKGROUND FOR LIGHT COLORED TEXT)', 'wp-ada-compliance' ),
    '99CC00', __( 'Yellow green (DO NOT USE OVER LIGHT BACKGROUND OR AS A BACKGROUND FOR LIGHT COLORED TEXT)', 'wp-ada-compliance' ),
    '339966', __( 'Sea green (DO NOT USE OVER LIGHT BACKGROUND OR AS A BACKGROUND FOR LIGHT COLORED TEXT)', 'wp-ada-compliance' ),
    '33CCCC',  __( 'Turquoise (DO NOT USE OVER LIGHT BACKGROUND OR AS A BACKGROUND FOR LIGHT COLORED TEXT)', 'wp-ada-compliance' ),
    '3366FF', __( 'Royal blue', 'wp-ada-compliance' ),
    '800080', __( 'Purple', 'wp-ada-compliance' ),
	'610061', __( 'Dark Purple', 'wp-ada-compliance' ),
    '999999', __( 'Medium gray (DO NOT USE OVER LIGHT BACKGROUND OR AS A BACKGROUND FOR LIGHT COLORED TEXT)', 'wp-ada-compliance' ),
    'FF00FF', __( 'Magenta (DO NOT USE OVER LIGHT BACKGROUND OR AS A BACKGROUND FOR LIGHT COLORED TEXT)', 'wp-ada-compliance' ),
    'FFCC00', __( 'Gold (DO NOT USE OVER LIGHT BACKGROUND OR AS A BACKGROUND FOR LIGHT COLORED TEXT)', 'wp-ada-compliance' ),
    'FFFF00', __( 'Yellow (DO NOT USE OVER LIGHT BACKGROUND OR AS A BACKGROUND FOR LIGHT COLORED TEXT)', 'wp-ada-compliance' ),
    '00FF00', __( 'Lime (DO NOT USE OVER LIGHT BACKGROUND OR AS A BACKGROUND FOR LIGHT COLORED TEXT)', 'wp-ada-compliance' ),
    '00FFFF', __( 'Aqua (DO NOT USE OVER LIGHT BACKGROUND OR AS A BACKGROUND FOR LIGHT COLORED TEXT)', 'wp-ada-compliance' ),
    '00CCFF', __( 'Sky blue (DO NOT USE OVER LIGHT BACKGROUND OR AS A BACKGROUND FOR LIGHT COLORED TEXT)', 'wp-ada-compliance' ),
	'007E9E', __( 'Sky blue Alternate', 'wp-ada-compliance' ),
    '993366', __( 'Red violet', 'wp-ada-compliance' ),
    'FFFFFF', __( 'White (DO NOT USE OVER LIGHT BACKGROUND OR AS A BACKGROUND FOR LIGHT COLORED TEXT)', 'wp-ada-compliance' ),
    'FF99CC', __( 'Pink (DO NOT USE OVER LIGHT BACKGROUND OR AS A BACKGROUND FOR LIGHT COLORED TEXT)', 'wp-ada-compliance' ),
    'FFCC99', __( 'Peach (DO NOT USE OVER LIGHT BACKGROUND OR AS A BACKGROUND FOR LIGHT COLORED TEXT)', 'wp-ada-compliance' ),
    'FFFF99', __( 'Light yellow (DO NOT USE OVER LIGHT BACKGROUND OR AS A BACKGROUND FOR LIGHT COLORED TEXT)', 'wp-ada-compliance' ),
    'CCFFCC', __( 'Pale green (DO NOT USE OVER LIGHT BACKGROUND OR AS A BACKGROUND FOR LIGHT COLORED TEXT)', 'wp-ada-compliance' ),
    'CCFFFF', __( 'Pale cyan (DO NOT USE OVER LIGHT BACKGROUND OR AS A BACKGROUND FOR LIGHT COLORED TEXT)', 'wp-ada-compliance' ), 
    '99CCFF', __( 'Light sky blue (DO NOT USE OVER LIGHT BACKGROUND OR AS A BACKGROUND FOR LIGHT COLORED TEXT)', 'wp-ada-compliance' ),
    'CC99FF', __( 'Plum (DO NOT USE OVER LIGHT BACKGROUND OR AS A BACKGROUND FOR LIGHT COLORED TEXT)', 'wp-ada-compliance' )
	);
    $options['textcolor_map'] = json_encode($custom_colours);
	}

    return $options;
}
/************************************************
add links to post/page list edit.php
***********************************************/
function wp_ada_compliance_add_post_editor_link($actions, $post){
if ( !current_user_can( "edit_pages" ) ) return $actions;
	
$post_types = get_option('wp_ada_compliance_posttypes',array('page','post'));	
    
if(!in_array($post->post_type,$post_types)) return $actions;
	
$title = __('Scan for Web Accessibility Issues','wp-ada-compliance');	
$actions['scanpost'] = '<a href="'.esc_url(get_site_url()).'/wp-admin/admin.php?page=ada_compliance%2Fcompliancereport.php&scansingle=1&postid=' . esc_attr($post->ID) . '&view=1&searchtitle=' . esc_attr($post->ID) . '&deepscan=1&type=' . esc_attr($post->post_type) . '" title="'.esc_attr($title).'" >'.__('Check For Issues', 'wp-ada-compliance').'</a>';
    
$enablewave = get_option('wp_ada_compliance_enablewave','true');
if($enablewave == 'true'){
$actions['evaluatewavepost'] = '<a href="http://wave.webaim.org/report#/'.esc_url(site_url()).'/?p='.esc_attr($post->ID).'">'.__('Evaluate with Wave','wp-ada-compliance').'</a>';
  
    // if html validation plugin not installed
if(!array_key_exists('htmlvalidate',$actions))    
$actions['w3cvalidatepost'] = '<a href="https://validator.w3.org/nu/?doc='.esc_url(site_url()).'/?p='.esc_attr($post->ID).'">'.__('Validate HTML','wp-ada-compliance').'</a>';    
}
    
return $actions;
}

/************************************************
remove default image link from media library insert tool
***********************************************/
function wp_ada_compliance_imagelink_setup() {
	 $removelinking = get_option('wp_ada_compliance_remove_linking_images','true');
	
	if( $removelinking){
    $image_set = get_option( 'image_default_link_type' );
     
    if ($image_set !== 'none') {
        update_option('image_default_link_type', 'none');
    }
	}
}
function wp_ada_compliance_reset_image_insert_settings() {
	 $removelinking = get_option('wp_ada_compliance_remove_linking_images','true');
	
	if( $removelinking){
  ?>
    <script>
      if ( typeof setUserSetting !== 'undefined' ) {
       // setUserSetting( 'align', 'none' ); // none || left || center || right
       // setUserSetting( 'imgsize', 'medium' ); // thumbnail || medium || large || full
        setUserSetting( 'urlbutton', 'none' ); // none || file || post
      }
    </script>
  <?php
	}
}


//check if is_admin or rest api for new editor
function wp_ada_compliance_check_is_admin($ignore_is_admin = 0) {
	
// don't filter customize screen
if(isset($_SERVER['HTTP_REFERER']) and stristr($_SERVER['HTTP_REFERER'],'/wp-admin/customize.php')) return 1;
	
// don't filter admin pages	
if($ignore_is_admin == 0 and function_exists('is_admin') and is_admin()) return 1;	
  
	$prefix = rest_get_url_prefix( );
        if (defined('REST_REQUEST') && REST_REQUEST // (#1)
            || isset($_GET['rest_route']) // (#2)
                && strpos( trim( $_GET['rest_route'], '\\/' ), $prefix , 0 ) === 0)
            return true;

        // (#3)
        $rest_url = wp_parse_url( site_url( $prefix ) );
        $current_url = wp_parse_url( add_query_arg( array( ) ) );
        return strpos( $current_url['path'], $rest_url['path'], 0 ) === 0;
	
}
/***************************************
support for various editors ie guttenberg, elementor, beaver builder
*****************************************/
// register endpoints to update button 
add_action( 'rest_api_init', function () {
  register_rest_route( 'wp_ada_compliance/v1', '/errorstatus/(?P<id>\d+)', array(
    'methods' => 'GET',
    'callback' => 'wp_ada_compliance_update_report_button',
	  'permission_callback' => function () {
			return current_user_can( 'edit_pages' );
		}
  ));
// endpopint to update error notice	
register_rest_route( 'wp_ada_compliance/v1', '/displaynotice/(?P<id>\d+)', array(
    'methods' => 'GET',
    'callback' => 'wp_ada_compliance_admin_notices_editor',
	'permission_callback' => function () {
			return current_user_can( 'edit_pages' );
		}
  ));
} );

// update button
function wp_ada_compliance_update_report_button($data) {  

check_ajax_referer('wp_rest', '_wpnonce');
	
$post = get_post((int)$data['id']);
if(get_post_mime_type($post->ID) == 'application/pdf'){
$posttype = 'pdf';
} else $posttype = $post->post_type;
$notice = '';
if(wp_ada_compliance_reported_errors_check($post,  1)){
    $button =  '<a href="'.esc_url(get_site_url()).'/wp-admin/admin.php?page=ada_compliance/compliancereport.php&view=1&errorid='.esc_attr($post->ID).'&type='.esc_attr($posttype).'&iframe=1&TB_iframe=true&width=900&height=550" class="thickbox btnwpada btnwpada-warning adareportlink">';
	$button .= __('Accessibility Report','wp-ada-compliance');
	$button .= '</a>';
	}  
	else{
	 $button =  '<i class="fas fa-thumbs-up btnwpada" style="font-size: 200%; background-color: #005700; color: #fff; width: 100px; padding: 5px;" aria-hidden="true" title="'.__('No Issues','wp-ada-compliance').'"></i>';	
	}
	
	return $button;
}

// display error notice
function wp_ada_compliance_admin_notices_editor($data) {  
    $wp_ada_compliance_deep_scan_on_editor = get_option('wp_ada_compliance_deep_scan_on_editor','true');
	if($wp_ada_compliance_deep_scan_on_editor == 'disabled') return '';
check_ajax_referer('wp_rest', '_wpnonce');
	
$post = get_post((int)$data['id']);
    
if(get_post_mime_type($post->ID) == 'application/pdf'){
$posttype = 'pdf';
} else $posttype = $post->post_type;
$notice = '';
if(wp_ada_compliance_reported_errors_check($post, 2)){
   $notice .= __('This page has one or more web accessibility problems. View the ','wp-ada-compliance');
	$notice .=  '<a href="'.esc_url(get_site_url()).'/wp-admin/admin.php?page=ada_compliance/compliancereport.php&view=1&errorid='.esc_attr($post->ID).'&type='.esc_attr($posttype).'&iframe=1&TB_iframe=true&width=900&height=550" class="thickbox adareportlink">';
	$notice .= __('Accessibility Report','wp-ada-compliance');
	$notice .= '</a>';
	} 
	return $notice;
}

/**************************************************************************************
// add image alt lookup button
****************************************************************************************/
add_filter('attachment_fields_to_edit', 'wp_ada_compliance_text_add_alt_text_field', 10, 2);
function wp_ada_compliance_text_add_alt_text_field($form_fields, $attachment){
   
    if ($attachment->post_mime_type == 'application/pdf' and wp_ada_compliance_attachment_reported_errors_check($attachment->ID)) {
   $notice = '<span style="color: #C71F22; font-weight: bold;">';
        $notice .= __('This document is not accessible to screen reader users. Use Adobe Acrobat Pro or other suitable PDF creation software to indentify and correct issues in this document before using it on your website.','wp-ada-compliance');
$notice .= '</span>';
          $form_fields["adastatus"] = array(
            "label" =>  __('ADA Notice','wp-ada-compliance'),
            "input" => "html",
            "html" => $notice,
       );
}


return $form_fields;
}
?>