<?php
/*

Plugin Name: WP ADA Compliance Check

Description: Comply with SECTION 508 and WC3/WCAG Web Accessibility Standards. This easy to use plugin evaluates pages for the most common issues as they are published. Run a complete scan of your website pages, posts and custom post types to identify issues. Review accessibility reports and easily correct issues.  

Version: 3.1.4.2

  Plugin URI: https://www.alumnionlineservices.com/php-scripts/wp-ada-compliance-check/

  Author: AlumniOnline Web Services LLC

  Author URI: https://www.alumnionlineservices.com
  Text Domain: wp-ada-compliance

*/
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;

// set debug status
$wp_ada_compliance_debug =0; 
if($wp_ada_compliance_debug == 1){
error_reporting(E_ALL); 
ini_set('display_errors', 1);
}

// define update file path and basename
$wp_ada_compliance_plugin_directory = __FILE__;
$wp_ada_compliance_plugin_basename = plugin_basename( __FILE__ );

// define script host url
$wp_ada_compliance_make_script_host_url = 'https://www.alumnionlineservices.com';

/*********************************************
PLUGIN INSTALLATION
*******************************************/
register_activation_hook( __FILE__, 'wp_ada_compliance_install' );
register_uninstall_hook( __FILE__, 'wp_ada_compliance_uninstall');
register_deactivation_hook( __FILE__, 'wp_ada_compliance_deactivate');

/****************************************************
UPDATE CHECKER
// DOCS: https://w-shadow.com/blog/2010/09/02/automatic-updates-for-any-plugin/#download
****************************************************/
global $wp_ada_compliance_make_script_host_url;
require plugin_dir_path( __FILE__ ).'res/plugin-updates/plugin-update-checker.php';
$wp_ada_compliance_Updates = Puc_v4_Factory::buildUpdateChecker(
    $wp_ada_compliance_make_script_host_url.'/wp-ada-compliance-autoupdate.php?lic='.get_option('wp_ada_compliance_license_key', ""),
    __FILE__,
    'wp-ada-compliance', 0
);


// include startup files
include(plugin_dir_path( __FILE__ ).'startup.php');
?>